/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class KeyedLock<T> {
    private final ConcurrentMap<T, KeyLock> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final boolean fair;

    public KeyedLock(boolean fair) {
        this.fair = fair;
    }

    public KeyedLock() {
        this(false);
    }

    public Releasable acquire(T key) {
        KeyLock perNodeLock;
        int i;
        do {
            KeyLock newLock;
            if ((perNodeLock = (KeyLock)this.map.get(key)) == null && (perNodeLock = this.map.putIfAbsent(key, newLock = new KeyLock(this.fair))) == null) {
                newLock.lock();
                return new ReleasableLock(key, newLock);
            }
            assert (perNodeLock != null);
        } while ((i = perNodeLock.count.get()) <= 0 || !perNodeLock.count.compareAndSet(i, i + 1));
        perNodeLock.lock();
        return new ReleasableLock(key, perNodeLock);
    }

    public boolean isHeldByCurrentThread(T key) {
        KeyLock lock = (KeyLock)this.map.get(key);
        if (lock == null) {
            return false;
        }
        return lock.isHeldByCurrentThread();
    }

    private void release(T key, KeyLock lock) {
        assert (lock == this.map.get(key));
        lock.unlock();
        int decrementAndGet = lock.count.decrementAndGet();
        if (decrementAndGet == 0) {
            this.map.remove(key, lock);
        }
    }

    public boolean hasLockedKeys() {
        return !this.map.isEmpty();
    }

    private static final class KeyLock
    extends ReentrantLock {
        private final AtomicInteger count = new AtomicInteger(1);

        KeyLock(boolean fair) {
            super(fair);
        }
    }

    private final class ReleasableLock
    implements Releasable {
        final T key;
        final KeyLock lock;
        final AtomicBoolean closed = new AtomicBoolean();

        private ReleasableLock(T key, KeyLock lock) {
            this.key = key;
            this.lock = lock;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                KeyedLock.this.release(this.key, this.lock);
            }
        }
    }
}

