/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.FuzzyOptions;
import org.elasticsearch.search.suggest.completion.RegexOptions;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.elasticsearch.search.suggest.completion.context.ContextMappings;

public class CompletionSuggestionBuilder
extends SuggestionBuilder<CompletionSuggestionBuilder> {
    private static final XContentType CONTEXT_BYTES_XCONTENT_TYPE = XContentType.JSON;
    static final ParseField CONTEXTS_FIELD = new ParseField("contexts", new String[]{"context"});
    static final ParseField SKIP_DUPLICATES_FIELD = new ParseField("skip_duplicates", new String[0]);
    public static final String SUGGESTION_NAME = "completion";
    private static final ObjectParser<InnerBuilder, Void> PARSER = new ObjectParser("completion", null);
    protected FuzzyOptions fuzzyOptions;
    protected RegexOptions regexOptions;
    protected BytesReference contextBytes = null;
    protected boolean skipDuplicates = false;

    public CompletionSuggestionBuilder(String field) {
        super(field);
    }

    private CompletionSuggestionBuilder(String fieldname, CompletionSuggestionBuilder in) {
        super(fieldname, in);
        this.fuzzyOptions = in.fuzzyOptions;
        this.regexOptions = in.regexOptions;
        this.contextBytes = in.contextBytes;
        this.skipDuplicates = in.skipDuplicates;
    }

    public CompletionSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.fuzzyOptions = in.readOptionalWriteable(FuzzyOptions::new);
        this.regexOptions = in.readOptionalWriteable(RegexOptions::new);
        this.contextBytes = in.readOptionalBytesReference();
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.skipDuplicates = in.readBoolean();
        }
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.fuzzyOptions);
        out.writeOptionalWriteable(this.regexOptions);
        out.writeOptionalBytesReference(this.contextBytes);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.skipDuplicates);
        }
    }

    @Override
    public CompletionSuggestionBuilder prefix(String prefix) {
        super.prefix(prefix);
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, Fuzziness fuzziness) {
        super.prefix(prefix);
        this.fuzzyOptions = new FuzzyOptions.Builder().setFuzziness(fuzziness).build();
        return this;
    }

    public CompletionSuggestionBuilder prefix(String prefix, FuzzyOptions fuzzyOptions) {
        super.prefix(prefix);
        this.fuzzyOptions = fuzzyOptions;
        return this;
    }

    @Override
    public CompletionSuggestionBuilder regex(String regex) {
        super.regex(regex);
        return this;
    }

    public CompletionSuggestionBuilder regex(String regex, RegexOptions regexOptions) {
        this.regex(regex);
        this.regexOptions = regexOptions;
        return this;
    }

    public CompletionSuggestionBuilder contexts(Map<String, List<? extends ToXContent>> queryContexts) {
        Objects.requireNonNull(queryContexts, "contexts must not be null");
        try {
            XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)CONTEXT_BYTES_XCONTENT_TYPE);
            contentBuilder.startObject();
            for (Map.Entry<String, List<? extends ToXContent>> contextEntry : queryContexts.entrySet()) {
                contentBuilder.startArray(contextEntry.getKey());
                for (ToXContent toXContent : contextEntry.getValue()) {
                    toXContent.toXContent(contentBuilder, EMPTY_PARAMS);
                }
                contentBuilder.endArray();
            }
            contentBuilder.endObject();
            return this.contexts(contentBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CompletionSuggestionBuilder contexts(XContentBuilder contextBuilder) {
        this.contextBytes = BytesReference.bytes(contextBuilder);
        return this;
    }

    public boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    public CompletionSuggestionBuilder skipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
        return this;
    }

    @Override
    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fuzzyOptions != null) {
            this.fuzzyOptions.toXContent(builder, params);
        }
        if (this.regexOptions != null) {
            this.regexOptions.toXContent(builder, params);
        }
        if (this.skipDuplicates) {
            builder.field(SKIP_DUPLICATES_FIELD.getPreferredName(), this.skipDuplicates);
        }
        if (this.contextBytes != null) {
            try (StreamInput stream = this.contextBytes.streamInput();){
                builder.rawField(CONTEXTS_FIELD.getPreferredName(), (InputStream)stream);
            }
        }
        return builder;
    }

    public static CompletionSuggestionBuilder fromXContent(XContentParser parser) throws IOException {
        InnerBuilder builder = new InnerBuilder();
        PARSER.parse(parser, (Object)builder, null);
        String field = builder.field;
        if (field == null) {
            throw new ElasticsearchParseException("the required field option [" + FIELDNAME_FIELD.getPreferredName() + "] is missing", new Object[0]);
        }
        return new CompletionSuggestionBuilder(field, builder);
    }

    @Override
    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        MappedFieldType mappedFieldType;
        CompletionSuggestionContext suggestionContext = new CompletionSuggestionContext(context);
        MapperService mapperService = context.getMapperService();
        this.populateCommonFields(mapperService, suggestionContext);
        suggestionContext.setSkipDuplicates(this.skipDuplicates);
        suggestionContext.setFuzzyOptions(this.fuzzyOptions);
        suggestionContext.setRegexOptions(this.regexOptions);
        if (this.shardSize != null) {
            suggestionContext.setShardSize(this.shardSize);
        }
        if ((mappedFieldType = mapperService.fullName(suggestionContext.getField())) == null || !(mappedFieldType instanceof CompletionFieldMapper.CompletionFieldType)) {
            throw new IllegalArgumentException("Field [" + suggestionContext.getField() + "] is not a completion suggest field");
        }
        if (mappedFieldType instanceof CompletionFieldMapper.CompletionFieldType) {
            CompletionFieldMapper.CompletionFieldType type = (CompletionFieldMapper.CompletionFieldType)mappedFieldType;
            suggestionContext.setFieldType(type);
            if (type.hasContextMappings() && this.contextBytes != null) {
                Map<String, List<ContextMapping.InternalQueryContext>> queryContexts = CompletionSuggestionBuilder.parseContextBytes(this.contextBytes, context.getXContentRegistry(), type.getContextMappings());
                suggestionContext.setQueryContexts(queryContexts);
            } else if (this.contextBytes != null) {
                throw new IllegalArgumentException("suggester [" + type.name() + "] doesn't expect any context");
            }
        }
        assert (suggestionContext.getFieldType() != null) : "no completion field type set";
        return suggestionContext;
    }

    static Map<String, List<ContextMapping.InternalQueryContext>> parseContextBytes(BytesReference contextBytes, NamedXContentRegistry xContentRegistry, ContextMappings contextMappings) throws IOException {
        try (XContentParser contextParser = XContentHelper.createParser(xContentRegistry, LoggingDeprecationHandler.INSTANCE, contextBytes, CONTEXT_BYTES_XCONTENT_TYPE);){
            XContentParser.Token currentToken;
            contextParser.nextToken();
            HashMap<String, List<ContextMapping.InternalQueryContext>> queryContexts = new HashMap<String, List<ContextMapping.InternalQueryContext>>(contextMappings.size());
            assert (contextParser.currentToken() == XContentParser.Token.START_OBJECT);
            while ((currentToken = contextParser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                String currentFieldName = contextParser.currentName();
                ContextMapping<?> mapping = contextMappings.get(currentFieldName);
                queryContexts.put(currentFieldName, mapping.parseQueryContext(contextParser));
            }
            HashMap<String, List<ContextMapping.InternalQueryContext>> hashMap = queryContexts;
            return hashMap;
        }
    }

    @Override
    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    @Override
    protected boolean doEquals(CompletionSuggestionBuilder other) {
        return this.skipDuplicates == other.skipDuplicates && Objects.equals(this.fuzzyOptions, other.fuzzyOptions) && Objects.equals(this.regexOptions, other.regexOptions) && Objects.equals(this.contextBytes, other.contextBytes);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fuzzyOptions, this.regexOptions, this.contextBytes, this.skipDuplicates);
    }

    static {
        PARSER.declareField((parser, completionSuggestionContext, context) -> {
            if (parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (parser.booleanValue()) {
                    completionSuggestionContext.fuzzyOptions = new FuzzyOptions.Builder().build();
                }
            } else {
                completionSuggestionContext.fuzzyOptions = FuzzyOptions.parse(parser);
            }
        }, FuzzyOptions.FUZZY_OPTIONS, ObjectParser.ValueType.OBJECT_OR_BOOLEAN);
        PARSER.declareField((parser, completionSuggestionContext, context) -> {
            completionSuggestionContext.regexOptions = RegexOptions.parse(parser);
        }, RegexOptions.REGEX_OPTIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareString((rec$, x$0) -> ((InnerBuilder)rec$).field(x$0), FIELDNAME_FIELD);
        PARSER.declareString(SuggestionBuilder::analyzer, ANALYZER_FIELD);
        PARSER.declareInt(SuggestionBuilder::size, SIZE_FIELD);
        PARSER.declareInt(SuggestionBuilder::shardSize, SHARDSIZE_FIELD);
        PARSER.declareField((p, v, c) -> {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)CONTEXT_BYTES_XCONTENT_TYPE);
            builder.copyCurrentStructure(p);
            v.contextBytes = BytesReference.bytes(builder);
            p.skipChildren();
        }, CONTEXTS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(CompletionSuggestionBuilder::skipDuplicates, SKIP_DUPLICATES_FIELD);
    }

    private static class InnerBuilder
    extends CompletionSuggestionBuilder {
        private String field;

        InnerBuilder() {
            super("_na_");
        }

        private InnerBuilder field(String field) {
            this.field = field;
            return this;
        }
    }
}

