/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.httpclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Provider;
import java.security.Security;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.CoverallsResponse;

public class CoverallsClient {
    private static final String FILE_NAME = "coveralls.json";
    private static final ContentType MIME_TYPE;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final String coverallsUrl;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public CoverallsClient(String coverallsUrl) {
        this(coverallsUrl, CoverallsClient.createDefaultClient(), new ObjectMapper());
    }

    public CoverallsClient(String coverallsUrl, HttpClient httpClient, ObjectMapper objectMapper) {
        this.coverallsUrl = coverallsUrl;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public CoverallsResponse submit(File file) throws ProcessingException, IOException {
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("json_file", file, MIME_TYPE, FILE_NAME).build();
        HttpPost post = new HttpPost(this.coverallsUrl);
        post.setEntity(entity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
        return this.parseResponse(response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoverallsResponse parseResponse(HttpResponse response) throws ProcessingException, IOException {
        CoverallsResponse coverallsResponse;
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        InputStreamReader reader = null;
        try {
            if (response.getStatusLine().getStatusCode() >= 500) {
                throw new IOException("Coveralls API interal error");
            }
            reader = new InputStreamReader(entity.getContent(), contentType.getCharset());
            CoverallsResponse cr = (CoverallsResponse)this.objectMapper.readValue((Reader)reader, CoverallsResponse.class);
            if (cr.isError()) {
                throw new ProcessingException(this.getResponseErrorMessage(response, cr.getMessage()));
            }
            coverallsResponse = cr;
        }
        catch (JsonProcessingException ex) {
            try {
                throw new ProcessingException(this.getResponseErrorMessage(response, ex.getMessage()), ex);
                catch (IOException ex2) {
                    throw new IOException(this.getResponseErrorMessage(response, ex2.getMessage()), ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return coverallsResponse;
    }

    private String getResponseErrorMessage(HttpResponse response, String message) {
        int status = response.getStatusLine().getStatusCode();
        String reason = response.getStatusLine().getReasonPhrase();
        String errorMessage = "Report submission to Coveralls API failed with HTTP status " + status + ":";
        if (StringUtils.isNotBlank((String)reason)) {
            errorMessage = errorMessage + " " + reason;
        }
        if (StringUtils.isNotBlank((String)message)) {
            errorMessage = errorMessage + " (" + message + ")";
        }
        return errorMessage;
    }

    private static HttpClient createDefaultClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    static {
        for (Provider provider : Security.getProviders()) {
            if (!provider.getName().startsWith("SunPKCS11")) continue;
            Security.removeProvider(provider.getName());
        }
        MIME_TYPE = ContentType.create((String)"application/octet-stream", (String)"utf-8");
    }
}

