/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.simple;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.simple.SimpleContainerFactory;
import org.glassfish.jersey.simple.SimpleServer;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;

public class SimpleTestContainerFactory
implements TestContainerFactory {
    public TestContainer create(URI baseUri, DeploymentContext context) throws IllegalArgumentException {
        return new SimpleTestContainer(baseUri, context);
    }

    private static class SimpleTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(SimpleTestContainer.class.getName());
        private final DeploymentContext deploymentContext;
        private URI baseUri;
        private SimpleServer server;

        private SimpleTestContainer(URI baseUri, DeploymentContext context) {
            URI base = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).build(new Object[0]);
            if (!"/".equals(base.getRawPath())) {
                throw new TestContainerException(String.format("Cannot deploy on %s. Simple framework container only supports deployment on root path.", base.getRawPath()));
            }
            this.baseUri = base;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Creating SimpleTestContainer configured at the base URI " + this.baseUri);
            }
            this.deploymentContext = context;
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            LOGGER.log(Level.FINE, "Starting SimpleTestContainer...");
            try {
                this.server = SimpleContainerFactory.create((URI)this.baseUri, (ResourceConfig)this.deploymentContext.getResourceConfig());
                if (this.baseUri.getPort() == 0) {
                    this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(this.server.getPort()).build(new Object[0]);
                    LOGGER.log(Level.INFO, "Started SimpleTestContainer at the base URI " + this.baseUri);
                }
            }
            catch (ProcessingException e) {
                throw new TestContainerException((Throwable)e);
            }
        }

        public void stop() {
            LOGGER.log(Level.FINE, "Stopping SimpleTestContainer...");
            try {
                this.server.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Error Stopping SimpleTestContainer...", ex);
            }
            finally {
                this.server = null;
            }
        }
    }
}

