/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotReferences;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Language;

final class PolyglotLanguage
implements PolyglotImpl.VMObject {
    final PolyglotEngineImpl engine;
    final LanguageCache cache;
    final LanguageInfo info;
    Language api;
    final int index;
    private final boolean host;
    final RuntimeException initError;
    private volatile OptionDescriptors options;
    private volatile OptionValuesImpl optionValues;
    private volatile boolean initialized;
    private volatile PolyglotLanguageInstance initLanguage;
    private final LinkedList<PolyglotLanguageInstance> instancePool;
    final ContextProfile profile;
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> multiLanguageReference;
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> singleOrMultiLanguageReference;
    private final PolyglotReferences.AbstractContextReference multiContextReference;
    private final PolyglotReferences.AbstractContextReference singleOrMultiContextReference;
    final Assumption singleInstance = Truffle.getRuntime().createAssumption("Single language instance per engine.");
    private boolean firstInstance = true;
    @CompilerDirectives.CompilationFinal
    volatile Class<?> contextClass;
    volatile PolyglotLocals.LocalLocation[] previousContextLocalLocations;
    volatile PolyglotLocals.LocalLocation[] previousContextThreadLocalLocations;

    PolyglotLanguage(PolyglotEngineImpl engine, LanguageCache cache, int index, boolean host, RuntimeException initError) {
        this.engine = engine;
        this.cache = cache;
        this.initError = initError;
        this.index = index;
        this.host = host;
        this.profile = new ContextProfile(this);
        this.instancePool = new LinkedList();
        this.info = EngineAccessor.NODES.createLanguage(this, cache.getId(), cache.getName(), cache.getVersion(), cache.getDefaultMimeType(), cache.getMimeTypes(), cache.isInternal(), cache.isInteractive());
        this.multiLanguageReference = PolyglotReferences.createAlwaysMultiLanguage(this);
        this.multiContextReference = PolyglotReferences.createAlwaysMultiContext(this);
        this.singleOrMultiContextReference = PolyglotReferences.createAssumeSingleContext(this, engine.singleContext, null, this.multiContextReference, false);
        this.singleOrMultiLanguageReference = PolyglotReferences.createAssumeSingleLanguage(this, null, this.singleInstance, this.multiLanguageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PolyglotLanguageInstance> getInstancePool() {
        Object object = this.engine.lock;
        synchronized (object) {
            return new ArrayList<PolyglotLanguageInstance>(this.instancePool);
        }
    }

    TruffleLanguage.ContextPolicy getEffectiveContextPolicy(PolyglotLanguage inLanguage) {
        TruffleLanguage.ContextPolicy sourcePolicy = this.engine.singleContext.isValid() ? TruffleLanguage.ContextPolicy.EXCLUSIVE : (inLanguage != null ? inLanguage.cache.getPolicy() : TruffleLanguage.ContextPolicy.SHARED);
        return sourcePolicy;
    }

    PolyglotLanguageContext getCurrentLanguageContext() {
        return PolyglotContextImpl.requireContext().contexts[this.index];
    }

    PolyglotLanguageContext getCurrentLanguageContextOptional() {
        PolyglotContextImpl context = PolyglotContextImpl.currentNotEntered();
        if (context != null && context.engine == this.engine) {
            return context.contexts[this.index];
        }
        return null;
    }

    boolean isFirstInstance() {
        return this.firstInstance;
    }

    void initializeContextClass(Object contextImpl) {
        CompilerAsserts.neverPartOfCompilation();
        Class newClass = contextImpl == null ? Void.class : contextImpl.getClass();
        Class<?> currentClass = this.contextClass;
        if (currentClass == null) {
            this.contextClass = newClass;
        } else if (currentClass != newClass) {
            throw new IllegalStateException(String.format("Unstable context class expected %s got %s.", newClass, currentClass));
        }
    }

    boolean dependsOn(PolyglotLanguage otherLanguage) {
        Set<String> dependentLanguages = this.cache.getDependentLanguages();
        if (dependentLanguages.contains(otherLanguage.getId())) {
            return true;
        }
        for (String dependentLanguage : dependentLanguages) {
            PolyglotLanguage dependentLanguageObj = this.engine.idToLanguage.get(dependentLanguage);
            if (dependentLanguageObj == null || !dependentLanguageObj.dependsOn(otherLanguage)) continue;
            return true;
        }
        return false;
    }

    boolean isHost() {
        return this.host;
    }

    public OptionDescriptors getOptions() {
        try {
            this.engine.checkState();
            return this.getOptionsInternal();
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.engine, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionDescriptors getOptionsInternal() {
        if (!this.initialized) {
            Object object = this.engine.lock;
            synchronized (object) {
                if (!this.initialized) {
                    this.initLanguage = this.ensureInitialized(new PolyglotLanguageInstance(this));
                    this.initialized = true;
                }
            }
        }
        return this.options;
    }

    private PolyglotLanguageInstance createInstance() {
        assert (Thread.holdsLock(this.engine.lock));
        if (this.firstInstance) {
            this.firstInstance = false;
        } else if (this.singleInstance.isValid()) {
            this.singleInstance.invalidate();
        }
        PolyglotLanguageInstance instance = null;
        if (this.initLanguage != null) {
            instance = this.initLanguage;
            this.initLanguage = null;
        }
        if (instance == null) {
            instance = this.ensureInitialized(new PolyglotLanguageInstance(this));
        }
        return instance;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance ensureInitialized(PolyglotLanguageInstance instance) {
        if (!this.initialized) {
            Object object = this.engine.lock;
            synchronized (object) {
                if (!this.initialized) {
                    try {
                        this.options = EngineAccessor.LANGUAGE.describeOptions(instance.spi, this.cache.getId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", this.cache.getId(), this.cache.getClassName()), e);
                    }
                    this.initialized = true;
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLanguageInstance allocateInstance(OptionValuesImpl newOptions) {
        PolyglotLanguageInstance instance;
        Object object = this.engine.lock;
        synchronized (object) {
            switch (this.cache.getPolicy()) {
                case EXCLUSIVE: {
                    instance = this.createInstance();
                    break;
                }
                case REUSE: {
                    instance = this.fetchFromPool(newOptions, false);
                    break;
                }
                case SHARED: {
                    instance = this.fetchFromPool(newOptions, true);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            instance.ensureMultiContextInitialized();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance fetchFromPool(OptionValuesImpl newOptions, boolean shared) {
        Object object = this.engine.lock;
        synchronized (object) {
            PolyglotLanguageInstance foundInstance = null;
            Iterator iterator = this.instancePool.iterator();
            while (iterator.hasNext()) {
                PolyglotLanguageInstance instance = (PolyglotLanguageInstance)iterator.next();
                if (!instance.areOptionsCompatible(newOptions)) continue;
                if (!shared) {
                    iterator.remove();
                }
                foundInstance = instance;
                break;
            }
            if (foundInstance == null) {
                foundInstance = this.createInstance();
                foundInstance.claim(newOptions);
                if (shared) {
                    this.instancePool.addFirst(foundInstance);
                }
            }
            return foundInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeInstance(PolyglotLanguageInstance instance) {
        Object object = this.engine.lock;
        synchronized (object) {
            switch (this.cache.getPolicy()) {
                case EXCLUSIVE: {
                    break;
                }
                case REUSE: {
                    this.instancePool.addFirst(instance);
                    break;
                }
                case SHARED: {
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere("Unknown context cardinality.");
                }
            }
        }
    }

    void close() {
        assert (Thread.holdsLock(this.engine.lock));
        this.instancePool.clear();
    }

    PolyglotReferences.AbstractContextReference getContextReference() {
        if (this.singleInstance.isValid() && !this.engine.conservativeContextReferences) {
            return this.singleOrMultiContextReference;
        }
        return this.multiContextReference;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getLanguageReference() {
        if (this.singleInstance.isValid()) {
            return this.singleOrMultiLanguageReference;
        }
        return this.multiLanguageReference;
    }

    PolyglotReferences.AbstractContextReference getConservativeContextReference() {
        return this.multiContextReference;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getConservativeLanguageReference() {
        return this.multiLanguageReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            Object object = this.engine.lock;
            synchronized (object) {
                if (this.optionValues == null) {
                    this.optionValues = new OptionValuesImpl(this.engine, this.getOptionsInternal(), false);
                }
            }
        }
        return this.optionValues;
    }

    OptionValuesImpl getOptionValuesIfExists() {
        return this.optionValues;
    }

    public String getDefaultMimeType() {
        return this.cache.getDefaultMimeType();
    }

    void clearOptionValues() {
        this.optionValues = null;
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getImplementationName() {
        return this.cache.getImplementationName();
    }

    public boolean isInteractive() {
        return this.cache.isInteractive();
    }

    public Set<String> getMimeTypes() {
        return this.cache.getMimeTypes();
    }

    public String getVersion() {
        String version = this.cache.getVersion();
        if (version.equals("inherit")) {
            return this.engine.getVersion();
        }
        return version;
    }

    public String getId() {
        return this.cache.getId();
    }

    public String toString() {
        return "PolyglotLanguage [id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.isHost() + "]";
    }

    boolean assertCorrectEngine() {
        PolyglotContextImpl context = PolyglotContextImpl.requireContext();
        PolyglotLanguageContext languageContext = context.getContext(this);
        if (languageContext.isInitialized() && languageContext.language.engine != this.engine) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere(String.format("Context reference was used from an Engine that is currently not entered. ContextReference of engine %s was used but engine %s is currently entered. ContextReference must not be shared between multiple Engine instances.", languageContext.language.engine, this.engine));
        }
        return true;
    }

    static final class ContextProfile {
        private final Assumption singleContext;
        @CompilerDirectives.CompilationFinal
        private volatile WeakReference<Object> cachedSingleContext;
        @CompilerDirectives.CompilationFinal
        private volatile WeakReference<PolyglotLanguageContext> cachedSingleLanguageContext;

        ContextProfile(PolyglotLanguage language) {
            this.singleContext = language.engine.singleContext.isValid() ? Truffle.getRuntime().createAssumption("Language single context.") : NeverValidAssumption.INSTANCE;
        }

        public Assumption getSingleContext() {
            return this.singleContext;
        }

        PolyglotLanguageContext profile(Object context) {
            if (this.singleContext.isValid()) {
                PolyglotLanguageContext cachedSingle;
                WeakReference<PolyglotLanguageContext> ref = this.cachedSingleLanguageContext;
                PolyglotLanguageContext polyglotLanguageContext = cachedSingle = ref == null ? null : (PolyglotLanguageContext)ref.get();
                if (this.singleContext.isValid()) {
                    assert (cachedSingle == context) : ContextProfile.assertionError(cachedSingle, context);
                    return cachedSingle;
                }
            }
            return (PolyglotLanguageContext)context;
        }

        static String assertionError(Object cachedContext, Object currentContext) {
            return cachedContext + " != " + currentContext;
        }

        void notifyContextCreate(PolyglotLanguageContext context, TruffleLanguage.Env env) {
            if (this.singleContext.isValid()) {
                Object cachedSingle;
                WeakReference<Object> ref = this.cachedSingleContext;
                Object v0 = cachedSingle = ref == null ? null : ref.get();
                assert (cachedSingle != EngineAccessor.LANGUAGE.getContext(env) || cachedSingle == null) : "Non-null context objects should be distinct";
                if (ref == null) {
                    if (this.singleContext.isValid()) {
                        this.cachedSingleContext = new WeakReference<Object>(EngineAccessor.LANGUAGE.getContext(env));
                        this.cachedSingleLanguageContext = new WeakReference<PolyglotLanguageContext>(context);
                    }
                } else {
                    this.prepareForMultiContext();
                }
            }
        }

        public void prepareForMultiContext() {
            this.singleContext.invalidate();
            this.cachedSingleContext = null;
            this.cachedSingleLanguageContext = null;
        }
    }
}

