/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.byteman.agent.Location;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.TransformSet;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.type.TypeHelper;

public class RuleScript {
    private static int nextId = 0;
    private String name;
    private String targetClass;
    private boolean isInterface;
    private String targetMethod;
    private boolean isOverride;
    private String targetHelper;
    private String[] imports;
    private Location targetLocation;
    private String ruleText;
    private boolean deleted;
    private int line;
    private String file;
    private final boolean compileToBytecode;
    private final HashMap<String, String> keySet;
    private final String key_base;
    private List<TransformSet> transformSets;

    private static synchronized int nextId() {
        return nextId++;
    }

    public RuleScript(String name, String targetClass, boolean isInterface, boolean isOverride, String targetMethod, String targetHelper, String[] imports, Location targetLocation, String ruleText, int line, String file, boolean compileToBytecode) {
        this.name = name;
        this.targetClass = targetClass;
        this.isInterface = isInterface;
        this.isOverride = isOverride;
        this.targetMethod = targetMethod;
        this.targetHelper = targetHelper;
        this.imports = imports;
        this.targetLocation = targetLocation != null ? targetLocation : Location.create(LocationType.ENTRY, "");
        this.ruleText = ruleText;
        this.line = line;
        this.file = file;
        this.compileToBytecode = compileToBytecode;
        this.transformSets = new ArrayList<TransformSet>();
        this.keySet = new HashMap();
        this.key_base = name + "_" + RuleScript.nextId();
    }

    public String getName() {
        return this.name;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public String getTargetHelper() {
        return this.targetHelper;
    }

    public String[] getImports() {
        return this.imports;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public String getRuleText() {
        return this.ruleText;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isCompileToBytecode() {
        return this.compileToBytecode;
    }

    public synchronized String getRuleKey(String triggerClassName, String triggerMethodName, String triggerMethodDescriptor, ClassLoader loader) {
        if (triggerMethodName == null) {
            return this.key_base;
        }
        String lookup = triggerClassName + "." + triggerMethodName + TypeHelper.internalizeDescriptor(triggerMethodDescriptor) + "_" + loader.hashCode();
        String result = this.keySet.get(lookup);
        if (result == null) {
            result = this.key_base + ":" + this.keySet.size();
            this.keySet.put(lookup, result);
        }
        return result;
    }

    public List<TransformSet> getTransformSets() {
        return this.transformSets;
    }

    public int getTransformSetsCount() {
        return this.transformSets != null ? this.transformSets.size() : 0;
    }

    public List<Transform> allTransforms() {
        ArrayList<Transform> allTransforms = new ArrayList<Transform>();
        for (TransformSet transformSet : this.transformSets) {
            allTransforms.addAll(transformSet.getTransforms());
        }
        return allTransforms;
    }

    public synchronized boolean setDeleted() {
        if (!this.deleted) {
            this.deleted = true;
            return false;
        }
        return true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public synchronized boolean recordFailedTransform(ClassLoader loader, String internalClassName, Throwable th) {
        return this.recordTransform(loader, internalClassName, null, null, null, th);
    }

    public synchronized boolean recordTransform(ClassLoader loader, String internalClassName, String triggerMethodName, String desc, Rule rule, Throwable th) {
        if (this.deleted) {
            return false;
        }
        String fullMethodName = null;
        if (triggerMethodName != null) {
            fullMethodName = triggerMethodName + TypeHelper.internalizeDescriptor(desc);
        }
        TransformSet transformSet = this.ensureTransformSet(loader, internalClassName, null);
        transformSet.add(new Transform(loader, internalClassName, fullMethodName, rule, th));
        return true;
    }

    public synchronized boolean hasTransform(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        for (TransformSet transformSet : this.transformSets) {
            if (!transformSet.isFor(loader, clazz.getName())) continue;
            return !transformSet.isEmpty();
        }
        return false;
    }

    public synchronized boolean recordCompile(Rule rule, String triggerClass, ClassLoader loader, boolean successful, String detail) {
        if (this.deleted) {
            return false;
        }
        TransformSet transformSet = this.ensureTransformSet(loader, triggerClass, null);
        for (Transform transform : transformSet.getTransforms()) {
            if (transform.getRule().getKey() != rule.getKey()) continue;
            transform.setCompiled(successful, detail);
            boolean isInstalled = transformSet.isInstalled();
            transformSet.setInstalled(rule);
            return !isInstalled;
        }
        return false;
    }

    public synchronized void purge(ClassLoader loader, String triggerClassName) {
        TransformSet transformSet = this.lookupTransformSet(loader, triggerClassName);
        if (transformSet != null) {
            for (Transform transform : transformSet.getTransforms()) {
                Rule rule = transform.getRule();
                if (rule == null) continue;
                rule.purge();
            }
            transformSet.clearTransforms();
        }
    }

    public synchronized void purge() {
        for (TransformSet transformSet : this.transformSets) {
            for (Transform transform : transformSet.getTransforms()) {
                Rule rule = transform.getRule();
                if (rule == null) continue;
                rule.purge();
            }
            transformSet.clearTransforms();
        }
        this.transformSets.clear();
    }

    public TransformSet ensureTransformSet(ClassLoader loader, String triggerClass, Rule installedRule) {
        TransformSet transformSet = this.lookupTransformSet(loader, triggerClass);
        if (transformSet == null) {
            transformSet = new TransformSet(loader, triggerClass);
            transformSet.setInstalled(installedRule);
            this.transformSets.add(transformSet);
        }
        return transformSet;
    }

    public TransformSet lookupTransformSet(ClassLoader loader, String triggerClass) {
        for (TransformSet transformSet : this.transformSets) {
            if (!transformSet.isFor(loader, triggerClass)) continue;
            return transformSet;
        }
        return null;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        this.writeTo(writer);
        writer.flush();
        return stringWriter.toString();
    }

    public void writeTo(PrintWriter writer) {
        writer.print("# File ");
        writer.print(this.file);
        writer.print(" line ");
        writer.println(this.line);
        writer.print("RULE ");
        writer.println(this.name);
        if (this.isInterface) {
            writer.print("INTERFACE ");
        } else {
            writer.print("CLASS ");
        }
        if (this.isOverride) {
            writer.print("^");
        }
        writer.println(this.targetClass);
        writer.print("METHOD ");
        writer.println(this.targetMethod);
        if (this.imports != null) {
            for (int i = 0; i < this.imports.length; ++i) {
                writer.print("IMPORT ");
                writer.println(this.imports[i]);
            }
        }
        if (this.targetHelper != null) {
            writer.print("HELPER ");
            writer.println(this.targetHelper);
        }
        if (this.compileToBytecode) {
            writer.write("COMPILE\n");
        } else {
            writer.write("NOCOMPILE\n");
        }
        writer.println(this.targetLocation.toString());
        writer.println(this.ruleText);
        writer.println("ENDRULE");
    }
}

