/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.UnaryOperExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class MinusExpression
extends UnaryOperExpression {
    public MinusExpression(Rule rule, ParseNode token, Expression operand) {
        super(rule, 66560, operand.getType(), token, operand);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = this.getOperand(0).typeCheck(Type.N);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("MinusExpression.typeCheck() : invalid result type : " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            Object objValue = this.getOperand(0).interpret(helper);
            Number value = objValue instanceof Character ? (Number)Integer.valueOf(((Character)objValue).charValue()) : (Number)((Number)objValue);
            if (this.type == Type.B) {
                return (byte)(-value.intValue());
            }
            if (this.type == Type.S) {
                return (short)(-value.intValue());
            }
            if (this.type == Type.I) {
                return -value.intValue();
            }
            if (this.type == Type.J) {
                return -value.longValue();
            }
            if (this.type == Type.F) {
                return -value.longValue();
            }
            if (this.type == Type.D) {
                return -value.longValue();
            }
            return -value.intValue();
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("MinusExpression.typeCheck() : unexpected exception : " + this.token.getText() + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper = this.getOperand(0);
        Type operType = oper.getType();
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        oper.compile(mv, compileContext);
        compileContext.compileTypeConversion(operType, this.type);
        if (this.type == Type.B || this.type == Type.S || this.type == Type.I) {
            mv.visitInsn(116);
            expected = 1;
        } else if (this.type == Type.J) {
            mv.visitInsn(117);
            expected = 2;
        } else if (this.type == Type.F) {
            mv.visitInsn(118);
            expected = 1;
        } else if (this.type == Type.D) {
            mv.visitInsn(119);
            expected = 2;
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("MinusExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

