/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;

public class HandshakeCompletedListener
implements ChannelFutureListener {
    private final String userAgent;
    private final AuthToken authToken;
    private final RoutingContext routingContext;
    private final ChannelPromise connectionInitializedPromise;

    public HandshakeCompletedListener(String userAgent, AuthToken authToken, RoutingContext routingContext, ChannelPromise connectionInitializedPromise) {
        this.userAgent = Objects.requireNonNull(userAgent);
        this.authToken = Objects.requireNonNull(authToken);
        this.routingContext = routingContext;
        this.connectionInitializedPromise = Objects.requireNonNull(connectionInitializedPromise);
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            BoltProtocol protocol = BoltProtocol.forChannel(future.channel());
            protocol.initializeChannel(this.userAgent, this.authToken, this.routingContext, this.connectionInitializedPromise);
        } else {
            this.connectionInitializedPromise.setFailure(future.cause());
        }
    }
}

