/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableHandlerImpl;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;

public class RoutingTableRegistryImpl
implements RoutingTableRegistry {
    private final ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers;
    private final RoutingTableHandlerFactory factory;
    private final Logger logger;

    public RoutingTableRegistryImpl(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logger logger, long routingTablePurgeDelayMs) {
        this(new ConcurrentHashMap<DatabaseName, RoutingTableHandler>(), new RoutingTableHandlerFactory(connectionPool, rediscovery, clock, logger, routingTablePurgeDelayMs), logger);
    }

    RoutingTableRegistryImpl(ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers, RoutingTableHandlerFactory factory, Logger logger) {
        this.factory = factory;
        this.routingTableHandlers = routingTableHandlers;
        this.logger = logger;
    }

    @Override
    public CompletionStage<RoutingTableHandler> ensureRoutingTable(ConnectionContext context) {
        RoutingTableHandler handler = this.getOrCreate(context.databaseName());
        return handler.ensureRoutingTable(context).thenApply(ignored -> handler);
    }

    @Override
    public Set<BoltServerAddress> allServers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        for (RoutingTableHandler tableHandler : this.routingTableHandlers.values()) {
            servers.addAll(tableHandler.servers());
        }
        return servers;
    }

    @Override
    public void remove(DatabaseName databaseName) {
        this.routingTableHandlers.remove(databaseName);
        this.logger.debug("Routing table handler for database '%s' is removed.", databaseName.description());
    }

    @Override
    public void removeAged() {
        this.routingTableHandlers.forEach((databaseName, handler) -> {
            if (handler.isRoutingTableAged()) {
                this.logger.info("Routing table handler for database '%s' is removed because it has not been used for a long time. Routing table: %s", databaseName.description(), handler.routingTable());
                this.routingTableHandlers.remove(databaseName);
            }
        });
    }

    @Override
    public Optional<RoutingTableHandler> getRoutingTableHandler(DatabaseName databaseName) {
        return Optional.ofNullable(this.routingTableHandlers.get(databaseName));
    }

    public boolean contains(DatabaseName databaseName) {
        return this.routingTableHandlers.containsKey(databaseName);
    }

    private RoutingTableHandler getOrCreate(DatabaseName databaseName) {
        return this.routingTableHandlers.computeIfAbsent(databaseName, name -> {
            RoutingTableHandler handler = this.factory.newInstance((DatabaseName)name, this);
            this.logger.debug("Routing table handler for database '%s' is added.", databaseName.description());
            return handler;
        });
    }

    static class RoutingTableHandlerFactory {
        private final ConnectionPool connectionPool;
        private final Rediscovery rediscovery;
        private final Logger log;
        private final Clock clock;
        private final long routingTablePurgeDelayMs;

        RoutingTableHandlerFactory(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logger log, long routingTablePurgeDelayMs) {
            this.connectionPool = connectionPool;
            this.rediscovery = rediscovery;
            this.clock = clock;
            this.log = log;
            this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
        }

        RoutingTableHandler newInstance(DatabaseName databaseName, RoutingTableRegistry allTables) {
            ClusterRoutingTable routingTable = new ClusterRoutingTable(databaseName, this.clock, new BoltServerAddress[0]);
            return new RoutingTableHandlerImpl(routingTable, this.rediscovery, this.connectionPool, allTables, this.log, this.routingTablePurgeDelayMs);
        }
    }
}

