/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.redisson.api.RCascadeType;
import org.redisson.api.RDeque;
import org.redisson.api.RExpirable;
import org.redisson.api.RExpirableAsync;
import org.redisson.api.RList;
import org.redisson.api.RLiveObject;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RObject;
import org.redisson.api.RObjectAsync;
import org.redisson.api.RQueue;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RCascade;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RFieldAccessor;
import org.redisson.api.annotation.RId;
import org.redisson.api.annotation.RIndex;
import org.redisson.api.condition.Condition;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.liveobject.LiveObjectTemplate;
import org.redisson.liveobject.condition.ANDCondition;
import org.redisson.liveobject.condition.EQCondition;
import org.redisson.liveobject.condition.ORCondition;
import org.redisson.liveobject.core.AccessorInterceptor;
import org.redisson.liveobject.core.FieldAccessorInterceptor;
import org.redisson.liveobject.core.LiveObjectInterceptor;
import org.redisson.liveobject.core.RExpirableInterceptor;
import org.redisson.liveobject.core.RMapInterceptor;
import org.redisson.liveobject.misc.AdvBeanCopy;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;
import org.redisson.liveobject.resolver.RIdResolver;

public class RedissonLiveObjectService
implements RLiveObjectService {
    private static final ConcurrentMap<Class<? extends RIdResolver<?>>, RIdResolver<?>> PROVIDER_CACHE = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Class<?>> classCache;
    private final RedissonClient redisson;
    private final CommandAsyncExecutor commandExecutor;

    public RedissonLiveObjectService(RedissonClient redisson, ConcurrentMap<Class<?>, Class<?>> classCache, CommandAsyncExecutor commandExecutor) {
        this.redisson = redisson;
        this.classCache = classCache;
        this.commandExecutor = commandExecutor;
    }

    private RMap<String, Object> getMap(Object proxied) {
        return (RMap)ClassUtils.getField(proxied, "liveObjectLiveMap");
    }

    private <T> Object generateId(Class<T> entityClass) throws NoSuchFieldException {
        String idFieldName = this.getRIdFieldName(entityClass);
        RId annotation = ClassUtils.getDeclaredField(entityClass, idFieldName).getAnnotation(RId.class);
        RIdResolver<T> resolver = this.getResolver(entityClass, annotation.generator(), annotation);
        Object id = resolver.resolve(entityClass, annotation, idFieldName, this.redisson);
        return id;
    }

    private RIdResolver<?> getResolver(Class<?> cls, Class<? extends RIdResolver<?>> resolverClass, Annotation anno) {
        if (!PROVIDER_CACHE.containsKey(resolverClass)) {
            try {
                PROVIDER_CACHE.putIfAbsent(resolverClass, resolverClass.newInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (RIdResolver)PROVIDER_CACHE.get(resolverClass);
    }

    public <T> T createLiveObject(Class<T> entityClass, Object id) {
        return this.instantiateLiveObject(this.getProxyClass(entityClass), id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        T proxied = this.createLiveObject(entityClass, id);
        if (this.asLiveObject(proxied).isExists()) {
            return proxied;
        }
        return null;
    }

    Set<Object> traverseAnd(ANDCondition condition, NamingScheme namingScheme, Class<?> entityClass) {
        HashSet<Object> allIds = new HashSet<Object>();
        Collection firstSet = null;
        ArrayList<String> names = new ArrayList<String>();
        boolean isAllEqConditions = true;
        for (Condition cond : condition.getConditions()) {
            if (cond instanceof EQCondition) {
                EQCondition eqc = (EQCondition)cond;
                String indexName = namingScheme.getIndexName(entityClass, eqc.getName());
                RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
                Collection values = map.get(eqc.getValue());
                if (firstSet == null) {
                    firstSet = values;
                } else {
                    names.add(values.getName());
                }
            }
            if (!(cond instanceof ORCondition)) continue;
            isAllEqConditions = false;
            Set<Object> ids = this.traverseOr((ORCondition)cond, namingScheme, entityClass);
            allIds.addAll(ids);
        }
        if (!isAllEqConditions && allIds.isEmpty()) {
            return Collections.emptySet();
        }
        if (firstSet != null) {
            if (names.isEmpty()) {
                if (!isAllEqConditions && !allIds.isEmpty()) {
                    allIds.retainAll(firstSet.readAll());
                } else {
                    allIds.addAll(firstSet.readAll());
                }
            } else {
                Set intersect = firstSet.readIntersection(names.toArray(new String[names.size()]));
                if (!isAllEqConditions && !allIds.isEmpty()) {
                    allIds.retainAll(intersect);
                } else {
                    allIds.addAll(intersect);
                }
            }
        }
        return allIds;
    }

    Set<Object> traverseOr(ORCondition condition, NamingScheme namingScheme, Class<?> entityClass) {
        HashSet<Object> allIds = new HashSet<Object>();
        Collection firstSet = null;
        ArrayList<String> names = new ArrayList<String>();
        for (Condition cond : condition.getConditions()) {
            if (cond instanceof EQCondition) {
                EQCondition eqc = (EQCondition)cond;
                String indexName = namingScheme.getIndexName(entityClass, eqc.getName());
                RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
                Collection values = map.get(eqc.getValue());
                if (firstSet == null) {
                    firstSet = values;
                } else {
                    names.add(values.getName());
                }
            }
            if (!(cond instanceof ANDCondition)) continue;
            Set<Object> ids = this.traverseAnd((ANDCondition)cond, namingScheme, entityClass);
            allIds.addAll(ids);
        }
        if (firstSet != null) {
            if (names.isEmpty()) {
                allIds.addAll(firstSet.readAll());
            } else {
                allIds.addAll(firstSet.readUnion(names.toArray(new String[names.size()])));
            }
        }
        return allIds;
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass, Condition condition) {
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
        Collection<Object> ids = Collections.emptySet();
        if (condition instanceof EQCondition) {
            EQCondition c = (EQCondition)condition;
            String indexName = namingScheme.getIndexName(entityClass, c.getName());
            RSetMultimap map = this.redisson.getSetMultimap(indexName, namingScheme.getCodec());
            ids = map.getAll(c.getValue());
        } else if (condition instanceof ORCondition) {
            ids = this.traverseOr((ORCondition)condition, namingScheme, entityClass);
        } else if (condition instanceof ANDCondition) {
            ids = this.traverseAnd((ANDCondition)condition, namingScheme, entityClass);
        }
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(ids.size());
        for (Object id : ids) {
            T proxied = this.createLiveObject(entityClass, id);
            result.add(proxied);
        }
        return result;
    }

    @Override
    public <T> T attach(T detachedObject) {
        this.validateDetached(detachedObject);
        Class<?> entityClass = detachedObject.getClass();
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        Object id = ClassUtils.getField(detachedObject, idFieldName);
        return (T)this.createLiveObject(entityClass, id);
    }

    @Override
    public <T> T merge(T detachedObject) {
        HashMap<Object, Object> alreadyPersisted = new HashMap<Object, Object>();
        return this.persist(detachedObject, alreadyPersisted, RCascadeType.MERGE);
    }

    @Override
    public <T> T persist(T detachedObject) {
        HashMap<Object, Object> alreadyPersisted = new HashMap<Object, Object>();
        return this.persist(detachedObject, alreadyPersisted, RCascadeType.PERSIST);
    }

    private <T> T persist(T detachedObject, Map<Object, Object> alreadyPersisted, RCascadeType type) {
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        Object id = ClassUtils.getField(detachedObject, idFieldName);
        if (id == null) {
            try {
                id = this.generateId(detachedObject.getClass());
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
            ClassUtils.setField(detachedObject, idFieldName, id);
        }
        T attachedObject = this.attach(detachedObject);
        alreadyPersisted.put(detachedObject, attachedObject);
        RMap<String, Object> liveMap = this.getMap(attachedObject);
        ArrayList<String> excludedFields = new ArrayList<String>();
        excludedFields.add(idFieldName);
        boolean fastResult = liveMap.fastPut("redisson_live_object", "1");
        if (type == RCascadeType.PERSIST && !fastResult) {
            throw new IllegalArgumentException("This REntity already exists.");
        }
        for (FieldDescription.InDefinedShape field : Introspectior.getAllFields(detachedObject.getClass())) {
            Object object = ClassUtils.getField(detachedObject, field.getName());
            if (object == null) continue;
            RObject rObject = this.commandExecutor.getObjectBuilder().createObject(id, detachedObject.getClass(), object.getClass(), field.getName(), this.redisson);
            if (rObject != null) {
                this.commandExecutor.getObjectBuilder().store(rObject, field.getName(), liveMap);
                if (rObject instanceof SortedSet) {
                    ((RSortedSet)rObject).trySetComparator(((SortedSet)object).comparator());
                }
                if (rObject instanceof Collection) {
                    for (Object obj : (Collection)object) {
                        if (obj != null && ClassUtils.isAnnotationPresent(obj.getClass(), REntity.class)) {
                            Object persisted = alreadyPersisted.get(obj);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(obj, alreadyPersisted, type);
                            }
                            obj = persisted;
                        }
                        ((Collection)((Object)rObject)).add(obj);
                    }
                } else if (rObject instanceof Map) {
                    Map rMap = (Map)((Object)rObject);
                    Map map = (Map)object;
                    for (Map.Entry entry : map.entrySet()) {
                        Object persisted;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key != null && ClassUtils.isAnnotationPresent(key.getClass(), REntity.class)) {
                            persisted = alreadyPersisted.get(key);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(key, alreadyPersisted, type);
                            }
                            key = persisted;
                        }
                        if (value != null && ClassUtils.isAnnotationPresent(value.getClass(), REntity.class)) {
                            persisted = alreadyPersisted.get(value);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(value, alreadyPersisted, type);
                            }
                            value = persisted;
                        }
                        rMap.put(key, value);
                    }
                }
                excludedFields.add(field.getName());
                continue;
            }
            if (ClassUtils.isAnnotationPresent(object.getClass(), REntity.class)) {
                Object persisted = alreadyPersisted.get(object);
                if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                    persisted = this.persist(object, alreadyPersisted, type);
                }
                excludedFields.add(field.getName());
                BeanUtil.pojo.setSimpleProperty(attachedObject, field.getName(), persisted);
                continue;
            }
            this.validateAnnotation(detachedObject, field.getName());
        }
        this.copy(detachedObject, attachedObject, excludedFields);
        return attachedObject;
    }

    private void validateAnnotation(Object instance, String fieldName) {
        RCascade annotation;
        Class<?> clazz = instance.getClass();
        if (this.isLiveObject(instance)) {
            clazz = clazz.getSuperclass();
        }
        if ((annotation = ClassUtils.getAnnotation(clazz, fieldName, RCascade.class)) != null) {
            throw new IllegalArgumentException("RCascade annotation couldn't be defined for non-Redisson object '" + clazz + "' and field '" + fieldName + "'");
        }
    }

    private <T> boolean checkCascade(Object instance, RCascadeType type, String fieldName) {
        RCascade annotation;
        Class<?> clazz = instance.getClass();
        if (this.isLiveObject(instance)) {
            clazz = clazz.getSuperclass();
        }
        return (annotation = ClassUtils.getAnnotation(clazz, fieldName, RCascade.class)) != null && (Arrays.asList(annotation.value()).contains((Object)type) || Arrays.asList(annotation.value()).contains((Object)RCascadeType.ALL));
    }

    @Override
    public <T> T detach(T attachedObject) {
        HashMap<String, Object> alreadyDetached = new HashMap<String, Object>();
        return this.detach(attachedObject, alreadyDetached);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T detach(T attachedObject, Map<String, Object> alreadyDetached) {
        this.validateAttached(attachedObject);
        Object detached = this.instantiateDetachedObject(attachedObject.getClass().getSuperclass(), this.asLiveObject(attachedObject).getLiveObjectId());
        BeanCopy.beans(attachedObject, detached).declared(true, true).copy();
        alreadyDetached.put(this.getMap(attachedObject).getName(), detached);
        for (Map.Entry<String, Object> obj : this.getMap(attachedObject).entrySet()) {
            Object detachedObject;
            if (!this.checkCascade(attachedObject, RCascadeType.DETACH, obj.getKey())) continue;
            if (obj.getValue() instanceof RSortedSet) {
                SortedSet redissonSet = (SortedSet)obj.getValue();
                TreeSet<void> set = new TreeSet<void>(redissonSet.comparator());
                for (Object e : redissonSet) {
                    void var9_12;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    set.add(var9_12);
                }
                ClassUtils.setField(detached, obj.getKey(), set);
                continue;
            }
            if (obj.getValue() instanceof RDeque) {
                Collection redissonDeque = (Collection)obj.getValue();
                LinkedList<void> deque = new LinkedList<void>();
                for (Object e : redissonDeque) {
                    void var9_15;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    deque.add(var9_15);
                }
                ClassUtils.setField(detached, obj.getKey(), deque);
                continue;
            }
            if (obj.getValue() instanceof RQueue) {
                Collection redissonQueue = (Collection)obj.getValue();
                LinkedList<void> queue = new LinkedList<void>();
                for (Object e : redissonQueue) {
                    void var9_18;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    queue.add(var9_18);
                }
                ClassUtils.setField(detached, obj.getKey(), queue);
                continue;
            }
            if (obj.getValue() instanceof RSet) {
                HashSet<void> set = new HashSet<void>();
                Collection redissonSet = (Collection)obj.getValue();
                for (Object e : redissonSet) {
                    void var9_21;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    set.add(var9_21);
                }
                ClassUtils.setField(detached, obj.getKey(), set);
                continue;
            }
            if (obj.getValue() instanceof RList) {
                ArrayList<void> list = new ArrayList<void>();
                Collection redissonList = (Collection)obj.getValue();
                for (Object e : redissonList) {
                    void var9_24;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    list.add(var9_24);
                }
                ClassUtils.setField(detached, obj.getKey(), list);
                continue;
            }
            if (this.isLiveObject(obj.getValue())) {
                Object detachedObject2 = alreadyDetached.get(this.getMap(obj.getValue()).getName());
                if (detachedObject2 == null) {
                    detachedObject2 = this.detach(obj.getValue(), alreadyDetached);
                }
                ClassUtils.setField(detached, obj.getKey(), detachedObject2);
                continue;
            }
            if (obj.getValue() instanceof RMap) {
                LinkedHashMap map = new LinkedHashMap();
                Map redissonMap = (Map)obj.getValue();
                for (Map.Entry entry : redissonMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.isLiveObject(key)) {
                        Object detachedObject3 = alreadyDetached.get(this.getMap(key).getName());
                        if (detachedObject3 == null) {
                            detachedObject3 = this.detach(key, alreadyDetached);
                        }
                        key = detachedObject3;
                    }
                    if (this.isLiveObject(value)) {
                        Object detachedObject2 = alreadyDetached.get(this.getMap(value).getName());
                        if (detachedObject2 == null) {
                            detachedObject2 = this.detach(value, alreadyDetached);
                        }
                        value = detachedObject2;
                    }
                    map.put(key, value);
                }
                ClassUtils.setField(detached, obj.getKey(), map);
                continue;
            }
            this.validateAnnotation(detached, obj.getKey());
        }
        return (T)detached;
    }

    @Override
    public <T> void delete(T attachedObject) {
        HashSet<String> deleted = new HashSet<String>();
        this.delete(attachedObject, deleted);
    }

    private <T> void delete(T attachedObject, Set<String> deleted) {
        this.validateAttached(attachedObject);
        for (Map.Entry<String, Object> obj : this.getMap(attachedObject).entrySet()) {
            if (!this.checkCascade(attachedObject, RCascadeType.DELETE, obj.getKey())) continue;
            if (obj.getValue() instanceof RSortedSet) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RDeque) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RQueue) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RSet) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RList) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (this.isLiveObject(obj.getValue())) {
                if (!deleted.add(this.getMap(obj.getValue()).getName())) continue;
                this.delete(obj.getValue(), deleted);
                continue;
            }
            if (obj.getValue() instanceof RMap) {
                RMap map = (RMap)obj.getValue();
                this.deleteCollection(deleted, map.keySet());
                this.deleteCollection(deleted, map.values());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            this.validateAnnotation(attachedObject, obj.getKey());
        }
        this.asLiveObject(attachedObject).delete();
    }

    private void deleteCollection(Set<String> deleted, Iterable<?> objs) {
        for (Object object : objs) {
            if (!this.isLiveObject(object) || !deleted.add(this.getMap(object).getName())) continue;
            this.delete(object, deleted);
        }
    }

    @Override
    public <T> boolean delete(Class<T> entityClass, Object id) {
        T entity = this.createLiveObject(entityClass, id);
        return this.asLiveObject(entity).delete();
    }

    @Override
    public <T> RLiveObject asLiveObject(T instance) {
        return (RLiveObject)instance;
    }

    @Override
    public <T> RExpirable asRExpirable(T instance) {
        return (RExpirable)instance;
    }

    @Override
    public <T, K, V> RMap<K, V> asRMap(T instance) {
        return (RMap)instance;
    }

    @Override
    public <T> boolean isLiveObject(T instance) {
        return instance instanceof RLiveObject;
    }

    @Override
    public <T> boolean isExists(T instance) {
        return instance instanceof RLiveObject && this.asLiveObject(instance).isExists();
    }

    @Override
    public void registerClass(Class<?> cls) {
        if (!this.classCache.containsKey(cls)) {
            this.validateClass(cls);
            this.registerClassInternal(cls);
        }
    }

    @Override
    public void unregisterClass(Class<?> cls) {
        if (cls.isAssignableFrom(RLiveObject.class)) {
            this.classCache.remove(cls.getSuperclass());
        } else {
            this.classCache.remove(cls);
        }
    }

    @Override
    public boolean isClassRegistered(Class<?> cls) {
        return this.classCache.containsKey(cls) || this.classCache.containsValue(cls);
    }

    private <T> void copy(T detachedObject, T attachedObject, List<String> excludedFields) {
        ((BeanCopy)((BeanCopy)new AdvBeanCopy(detachedObject, attachedObject).ignoreNulls(true)).exclude(excludedFields.toArray(new String[excludedFields.size()]))).copy();
    }

    private String getRIdFieldName(Class<?> cls) {
        return ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(cls, RId.class).getOnly()).getName();
    }

    private <T> T instantiateLiveObject(Class<T> proxyClass, Object id) {
        if (id == null) {
            throw new IllegalStateException("Non-null value is required for the field with RId annotation.");
        }
        T instance = this.instantiate(proxyClass, id);
        this.asLiveObject(instance).setLiveObjectId(id);
        return instance;
    }

    private <T, K> T instantiateDetachedObject(Class<T> cls, K id) {
        String fieldName;
        T instance = this.instantiate(cls, id);
        if (ClassUtils.getField(instance, fieldName = this.getRIdFieldName(cls)) == null) {
            ClassUtils.setField(instance, fieldName, id);
        }
        return instance;
    }

    private <T> T instantiate(Class<T> cls, Object id) {
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                return (T)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("Can't find default constructor for " + cls);
    }

    private <T> Class<? extends T> getProxyClass(Class<T> entityClass) {
        this.registerClass(entityClass);
        return (Class)this.classCache.get(entityClass);
    }

    private <T> void validateClass(Class<T> entityClass) {
        if (entityClass.isAnonymousClass() || entityClass.isLocalClass()) {
            throw new IllegalArgumentException(entityClass.getName() + " is not publically accessable.");
        }
        if (!ClassUtils.isAnnotationPresent(entityClass, REntity.class)) {
            throw new IllegalArgumentException("REntity annotation is missing from class type declaration.");
        }
        FieldList fields = Introspectior.getFieldsWithAnnotation(entityClass, RIndex.class);
        Iterator iterator = (fields = (FieldList)fields.filter((ElementMatcher)ElementMatchers.fieldType((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.anyOf((Type[])new Type[]{Map.class, Collection.class, RObject.class}))))).iterator();
        if (iterator.hasNext()) {
            FieldDescription.InDefinedShape field = (FieldDescription.InDefinedShape)iterator.next();
            throw new IllegalArgumentException("RIndex annotation couldn't be defined for field '" + field.getName() + "' with type '" + field.getType() + "'");
        }
        FieldList<FieldDescription.InDefinedShape> fieldsWithRIdAnnotation = Introspectior.getFieldsWithAnnotation(entityClass, RId.class);
        if (fieldsWithRIdAnnotation.size() == 0) {
            throw new IllegalArgumentException("RId annotation is missing from class field declaration.");
        }
        if (fieldsWithRIdAnnotation.size() > 1) {
            throw new IllegalArgumentException("Only one field with RId annotation is allowed in class field declaration.");
        }
        FieldDescription.InDefinedShape idFieldDescription = (FieldDescription.InDefinedShape)fieldsWithRIdAnnotation.getOnly();
        String idFieldName = idFieldDescription.getName();
        Field idField = null;
        try {
            idField = ClassUtils.getDeclaredField(entityClass, idFieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (ClassUtils.isAnnotationPresent(idField.getType(), REntity.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of which class is annotated with REntity.");
        }
        if (idField.getType().isAssignableFrom(RObject.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of RObject");
        }
    }

    private <T> void validateDetached(T detachedObject) {
        if (detachedObject instanceof RLiveObject) {
            throw new IllegalArgumentException("The object supplied is already a RLiveObject");
        }
    }

    private <T> void validateAttached(T attachedObject) {
        if (!(attachedObject instanceof RLiveObject)) {
            throw new IllegalArgumentException("The object supplied is must be a RLiveObject");
        }
    }

    private <T> void registerClassInternal(Class<T> entityClass) {
        DynamicType.Builder builder = new ByteBuddy().subclass(entityClass);
        for (FieldDescription.InDefinedShape field : Introspectior.getTypeDescription(LiveObjectTemplate.class).getDeclaredFields()) {
            builder = builder.define((FieldDescription)field);
        }
        Class proxied = builder.method((ElementMatcher)ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.anyOf((Type[])new Type[]{RLiveObject.class, RExpirable.class, RObject.class})).and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter()).or((ElementMatcher)ElementMatchers.named((String)"isPhantom")).or((ElementMatcher)ElementMatchers.named((String)"delete")))).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{FieldProxy.Binder.install(LiveObjectInterceptor.Getter.class, LiveObjectInterceptor.Setter.class)}).to((Object)new LiveObjectInterceptor(this.redisson, entityClass, this.getRIdFieldName(entityClass), this.commandExecutor.getObjectBuilder()))).implement(new Type[]{RLiveObject.class}).method((ElementMatcher)ElementMatchers.isAnnotatedWith(RFieldAccessor.class).and((ElementMatcher)ElementMatchers.named((String)"get").or((ElementMatcher)ElementMatchers.named((String)"set")))).intercept((Implementation)MethodDelegation.to(FieldAccessorInterceptor.class)).method((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirable.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirableAsync.class))).intercept((Implementation)MethodDelegation.to(RExpirableInterceptor.class)).implement(new Type[]{RExpirable.class}).method((ElementMatcher)ElementMatchers.isDeclaredBy(Map.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(ConcurrentMap.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(RMapAsync.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(RMap.class))).intercept((Implementation)MethodDelegation.to(RMapInterceptor.class)).implement(new Type[]{RMap.class}).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RLiveObject.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirable.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirableAsync.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RObject.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RObjectAsync.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(ConcurrentMap.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Map.class))).and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter())).and((ElementMatcher)ElementMatchers.isPublic().or((ElementMatcher)ElementMatchers.isProtected()))).intercept((Implementation)MethodDelegation.to((Object)new AccessorInterceptor(this.redisson, this.commandExecutor.getObjectBuilder()))).make().load(entityClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        this.classCache.putIfAbsent(entityClass, proxied);
    }
}

