/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.config.BaseMasterSlaveServersConfig;

public class ClusterServersConfig
extends BaseMasterSlaveServersConfig<ClusterServersConfig> {
    private Map<String, String> natMap = Collections.emptyMap();
    private List<String> nodeAddresses = new ArrayList<String>();
    private int scanInterval = 5000;

    public ClusterServersConfig() {
    }

    ClusterServersConfig(ClusterServersConfig config) {
        super(config);
        this.setNodeAddresses(config.getNodeAddresses());
        this.setScanInterval(config.getScanInterval());
        this.setNatMap(new HashMap<String, String>(config.getNatMap()));
    }

    public ClusterServersConfig addNodeAddress(String ... addresses) {
        this.nodeAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public List<String> getNodeAddresses() {
        return this.nodeAddresses;
    }

    void setNodeAddresses(List<String> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public ClusterServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    public Map<String, String> getNatMap() {
        return this.natMap;
    }

    public ClusterServersConfig setNatMap(Map<String, String> natMap) {
        this.natMap = natMap;
        return this;
    }
}

