/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.resolver.AddressResolver;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RedisURI> sentinelHosts = new HashSet<RedisURI>();
    private final ConcurrentMap<RedisURI, RedisClient> sentinels = new ConcurrentHashMap<RedisURI, RedisClient>();
    private final AtomicReference<String> currentMaster = new AtomicReference();
    private final Set<RedisURI> disconnectedSlaves = new HashSet<RedisURI>();
    private ScheduledFuture<?> monitorFuture;
    private AddressResolver<InetSocketAddress> sentinelResolver;
    private final Map<String, String> natMap;
    private boolean usePassword = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config, UUID id) {
        super(config, id);
        RedisClient client;
        RedisURI addr;
        if (cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        if (cfg.getSentinelAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel node should be defined!");
        }
        this.config = this.create(cfg);
        this.initTimer(this.config);
        this.natMap = cfg.getNatMap();
        this.sentinelResolver = this.resolverGroup.getResolver((EventExecutor)this.getGroup().next());
        for (String address : cfg.getSentinelAddresses()) {
            addr = new RedisURI(address);
            client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getRetryInterval() * this.config.getRetryAttempts(), null);
            try {
                RedisConnection c = client.connect();
                try {
                    c.sync(RedisCommands.PING, new Object[0]);
                }
                catch (RedisAuthRequiredException e) {
                    this.usePassword = true;
                }
                client.shutdown();
                break;
            }
            catch (Exception c) {
            }
        }
        for (String address : cfg.getSentinelAddresses()) {
            addr = new RedisURI(address);
            if (NetUtil.createByteArrayFromIpAddressString((String)addr.getHost()) == null && !addr.getHost().equals("localhost")) {
                this.sentinelHosts.add(this.convert(addr.getHost(), "" + addr.getPort()));
            }
            client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getRetryInterval() * this.config.getRetryAttempts(), null);
            try {
                RedisConnection connection = client.connect();
                if (!connection.isActive()) continue;
                List<String> master = connection.sync(RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
                if (master.isEmpty()) {
                    throw new RedisConnectionException("Master node is undefined! SENTINEL GET-MASTER-ADDR-BY-NAME command returns empty result!");
                }
                String masterHost = this.createAddress(master.get(0), master.get(1));
                this.config.setMasterAddress(masterHost);
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = (String)map.get("flags");
                    String string = this.createAddress(ip, port);
                    this.config.addSlaveAddress(string);
                    this.log.debug("slave {} state: {}", (Object)string, (Object)map);
                    this.log.info("slave: {} added", (Object)string);
                    if (!flags.contains("s_down") && !flags.contains("disconnected")) continue;
                    RedisURI uri = new RedisURI(string);
                    this.disconnectedSlaves.add(uri);
                    this.log.warn("slave: {} is down", (Object)string);
                }
                List sentinelSentinels = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
                ArrayList<RFuture<Void>> connectionFutures = new ArrayList<RFuture<Void>>(sentinelSentinels.size());
                for (Map map : sentinelSentinels) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String string = (String)map.get("port");
                    RedisURI sentinelAddr = this.convert(ip, string);
                    RFuture<Void> future = this.registerSentinel(sentinelAddr, this.config);
                    connectionFutures.add(future);
                }
                RedisURI currentAddr = this.convert(client.getAddr().getAddress().getHostAddress(), "" + client.getAddr().getPort());
                RFuture<Void> f = this.registerSentinel(currentAddr, this.config);
                connectionFutures.add(f);
                for (RFuture rFuture : connectionFutures) {
                    rFuture.awaitUninterruptibly(this.config.getConnectTimeout());
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server. {}", (Object)e.getMessage());
            }
            finally {
                client.shutdownAsync();
            }
        }
        if (this.sentinels.isEmpty()) {
            this.stopThreads();
            throw new RedisConnectionException("At least two sentinels should be defined in Redis configuration! SENTINEL SENTINELS command returns empty result!");
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!");
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found!");
        }
        this.initSingleEntry();
        this.scheduleChangeCheck(cfg, null);
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() == -1L || this.sentinelHosts.isEmpty()) {
            return;
        }
        this.scheduleSentinelDNSCheck();
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        if (type == NodeType.SENTINEL && !this.usePassword) {
            result.setPassword(null);
        }
        return result;
    }

    private void scheduleSentinelDNSCheck() {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                final AtomicInteger sentinelsCounter = new AtomicInteger(SentinelConnectionManager.this.sentinelHosts.size());
                FutureListener<List<InetSocketAddress>> commonListener = new FutureListener<List<InetSocketAddress>>(){

                    public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                        if (sentinelsCounter.decrementAndGet() == 0) {
                            SentinelConnectionManager.this.scheduleSentinelDNSCheck();
                        }
                    }
                };
                for (final RedisURI host : SentinelConnectionManager.this.sentinelHosts) {
                    Future allNodes = SentinelConnectionManager.this.sentinelResolver.resolveAll((SocketAddress)InetSocketAddress.createUnresolved(host.getHost(), host.getPort()));
                    allNodes.addListener((GenericFutureListener)new FutureListener<List<InetSocketAddress>>(){

                        public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                            if (!future.isSuccess()) {
                                SentinelConnectionManager.this.log.error("Unable to resolve " + host.getHost(), future.cause());
                                return;
                            }
                            Set newUris = ((List)future.getNow()).stream().map(addr -> SentinelConnectionManager.this.convert(addr.getAddress().getHostAddress(), "" + addr.getPort())).collect(Collectors.toSet());
                            for (RedisURI uri : newUris) {
                                if (SentinelConnectionManager.this.sentinels.containsKey(uri)) continue;
                                SentinelConnectionManager.this.registerSentinel(uri, SentinelConnectionManager.this.getConfig());
                            }
                        }
                    });
                    allNodes.addListener((GenericFutureListener)commonListener);
                }
            }
        }, this.config.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    private void scheduleChangeCheck(final SentinelServersConfig cfg, final Iterator<RedisClient> iterator) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicReference lastException = new AtomicReference();
                Iterator iter = iterator;
                if (iter == null) {
                    ArrayList clients = new ArrayList(SentinelConnectionManager.this.sentinels.values());
                    Collections.shuffle(clients);
                    iter = clients.iterator();
                }
                SentinelConnectionManager.this.checkState(cfg, iter, lastException);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkState(SentinelServersConfig cfg, Iterator<RedisClient> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.scheduleChangeCheck(cfg, null);
            return;
        }
        if (!this.getShutdownLatch().acquire()) {
            return;
        }
        RedisClient client = iterator.next();
        RFuture<RedisConnection> connectionFuture = this.connectToNode(null, null, client, null);
        connectionFuture.onComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkState(cfg, iterator, lastException);
                return;
            }
            this.updateState(cfg, (RedisConnection)connection, iterator);
        });
    }

    private void updateState(final SentinelServersConfig cfg, final RedisConnection connection, final Iterator<RedisClient> iterator) {
        final AtomicInteger commands = new AtomicInteger(2);
        BiConsumer<Object, Throwable> commonListener = new BiConsumer<Object, Throwable>(){
            private final AtomicBoolean failed = new AtomicBoolean();

            @Override
            public void accept(Object t, Throwable u) {
                if (commands.decrementAndGet() == 0) {
                    SentinelConnectionManager.this.getShutdownLatch().release();
                    if (this.failed.get()) {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, iterator);
                    } else {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, null);
                    }
                }
                if (u != null && this.failed.compareAndSet(false, true)) {
                    SentinelConnectionManager.this.log.error("Can't execute SENTINEL commands on " + connection.getRedisClient().getAddr(), u);
                    SentinelConnectionManager.this.closeNodeConnection(connection);
                }
            }
        };
        RFuture masterFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
        masterFuture.onComplete((master, e) -> {
            if (e != null) {
                return;
            }
            String current = this.currentMaster.get();
            String newMaster = this.createAddress((String)master.get(0), master.get(1));
            if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, newMaster)) {
                RFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), new RedisURI(newMaster));
                changeFuture.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.currentMaster.compareAndSet(newMaster, current);
                    }
                });
            }
        });
        masterFuture.onComplete(commonListener);
        if (!this.config.checkSkipSlavesInit()) {
            RFuture slavesFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
            commands.incrementAndGet();
            slavesFuture.onComplete((slavesMap, e) -> {
                if (e != null) {
                    return;
                }
                final HashSet<String> currentSlaves = new HashSet<String>(slavesMap.size());
                ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
                for (Map map : slavesMap) {
                    if (map.isEmpty()) continue;
                    String string = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = (String)map.get("flags");
                    String masterHost = (String)map.get("master-host");
                    String masterPort = (String)map.get("master-port");
                    if (flags.contains("s_down") || flags.contains("disconnected")) {
                        this.slaveDown(string, port);
                        continue;
                    }
                    if ("?".equals(masterHost) || !this.isUseSameMaster(string, port, masterHost, masterPort)) continue;
                    String slaveAddr = this.createAddress(string, port);
                    currentSlaves.add(slaveAddr);
                    RFuture<Void> slaveFuture = this.addSlave(string, port, slaveAddr);
                    futures.add(slaveFuture);
                }
                CountableListener<Void> listener = new CountableListener<Void>(){

                    @Override
                    protected void onSuccess(Void value) {
                        MasterSlaveEntry entry = SentinelConnectionManager.this.getEntry(SentinelConnectionManager.this.singleSlotRange.getStartSlot());
                        HashSet<String> removedSlaves = new HashSet<String>();
                        for (ClientConnectionsEntry e : entry.getAllEntries()) {
                            InetSocketAddress addr = e.getClient().getAddr();
                            String slaveAddr = SentinelConnectionManager.this.createAddress(addr.getAddress().getHostAddress(), addr.getPort());
                            removedSlaves.add(slaveAddr);
                        }
                        removedSlaves.removeAll(currentSlaves);
                        for (String slave : removedSlaves) {
                            if (slave.equals(SentinelConnectionManager.this.currentMaster.get())) continue;
                            String hostPort = slave.replace("redis://", "");
                            int lastColonIdx = hostPort.lastIndexOf(":");
                            String host = hostPort.substring(0, lastColonIdx);
                            String port = hostPort.substring(lastColonIdx + 1);
                            SentinelConnectionManager.this.slaveDown(host, port);
                        }
                    }
                };
                listener.setCounter(futures.size());
                for (RFuture rFuture : futures) {
                    rFuture.onComplete(listener);
                }
            });
            slavesFuture.onComplete(commonListener);
        }
        RFuture sentinelsFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
        sentinelsFuture.onComplete((list, e) -> {
            if (e != null) {
                return;
            }
            Set<RedisURI> newUris = list.stream().filter(m -> {
                String flags = (String)m.get("flags");
                return !m.isEmpty() && !flags.contains("disconnected") && !flags.contains("s_down");
            }).map(m -> {
                String ip = (String)m.get("ip");
                String port = (String)m.get("port");
                return this.convert(ip, port);
            }).collect(Collectors.toSet());
            InetSocketAddress addr = connection.getRedisClient().getAddr();
            RedisURI currentAddr = this.convert(addr.getAddress().getHostAddress(), "" + addr.getPort());
            newUris.add(currentAddr);
            this.updateSentinels(newUris);
        });
        sentinelsFuture.onComplete(commonListener);
    }

    private void updateSentinels(Set<RedisURI> newUris) {
        HashSet currentUris = new HashSet(this.sentinels.keySet());
        HashSet<RedisURI> addedUris = new HashSet<RedisURI>(newUris);
        addedUris.removeAll(currentUris);
        for (RedisURI uri : addedUris) {
            this.registerSentinel(uri, this.getConfig());
        }
        currentUris.removeAll(newUris);
        for (RedisURI uri : currentUris) {
            RedisClient sentinel = (RedisClient)this.sentinels.remove(uri);
            if (sentinel == null) continue;
            sentinel.shutdownAsync();
            this.log.warn("sentinel: {} has down", (Object)uri);
        }
    }

    private String createAddress(String host, Object port) {
        if (host.contains(":")) {
            String pureHost = host.replaceAll("[\\[\\]]", "");
            if ((host = this.applyNatMap(pureHost)).contains(":")) {
                host = "[" + host + "]";
            }
        } else {
            host = this.applyNatMap(host);
        }
        return "redis://" + host + ":" + port;
    }

    @Override
    protected MasterSlaveEntry createMasterSlaveEntry(MasterSlaveServersConfig config) {
        MasterSlaveEntry entry = new MasterSlaveEntry(this, config);
        List<RFuture<Void>> fs = entry.initSlaveBalancer(this.disconnectedSlaves);
        for (RFuture<Void> future : fs) {
            future.syncUninterruptibly();
        }
        return entry;
    }

    private RFuture<Void> registerSentinel(RedisURI addr, MasterSlaveServersConfig c) {
        RedisClient sentinel = (RedisClient)this.sentinels.get(addr);
        if (sentinel != null) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, c.getConnectTimeout(), c.getRetryInterval() * c.getRetryAttempts(), null);
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<InetSocketAddress> future = client.resolveAddr();
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RFuture<RedisConnection> f = client.connectAsync();
            f.onComplete((connection, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                RFuture r = connection.async((long)this.config.getTimeout(), RedisCommands.PING, new Object[0]);
                r.onComplete((resp, exc) -> {
                    if (exc != null) {
                        result.tryFailure((Throwable)exc);
                        return;
                    }
                    if (this.sentinels.putIfAbsent(addr, client) == null) {
                        this.log.info("sentinel: {} added", (Object)addr);
                    }
                    result.trySuccess(null);
                });
            });
        });
        return result;
    }

    private RFuture<Void> addSlave(String ip, String port, String addr) {
        RedisURI uri;
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(uri = this.convert(ip, port)) && !this.config.checkSkipSlavesInit()) {
            RFuture<Void> future = entry.addSlave(new RedisURI(addr));
            future.onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    this.log.error("Can't add slave: " + addr, e);
                    return;
                }
                if (entry.isSlaveUnfreezed(uri) || entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                    String slaveAddr = ip + ":" + port;
                    this.log.info("slave: {} added", (Object)slaveAddr);
                    result.trySuccess(null);
                }
            });
        } else {
            if (entry.hasSlave(uri)) {
                this.slaveUp(ip, port);
            }
            result.trySuccess(null);
        }
        return result;
    }

    private RedisURI convert(String ip, String port) {
        String addr = this.createAddress(ip, port);
        RedisURI uri = new RedisURI(addr);
        return uri;
    }

    private void slaveDown(String ip, String port) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.warn("slave: {}:{} has down", (Object)ip, (Object)port);
        } else {
            RedisURI uri;
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(uri = this.convert(ip, port), ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {}:{} has down", (Object)ip, (Object)port);
            }
        }
    }

    private boolean isUseSameMaster(String slaveIp, String slavePort, String slaveMasterHost, String slaveMasterPort) {
        String slaveMaster;
        String master = this.currentMaster.get();
        if (!master.equals(slaveMaster = this.createAddress(slaveMasterHost, slaveMasterPort))) {
            this.log.warn("Skipped slave up {} for master {} differs from current {}", new Object[]{slaveIp + ":" + slavePort, slaveMaster, master});
            return false;
        }
        return true;
    }

    private void slaveUp(String ip, String port) {
        if (this.config.checkSkipSlavesInit()) {
            String slaveAddr = ip + ":" + port;
            this.log.info("slave: {} has up", (Object)slaveAddr);
            return;
        }
        RedisURI uri = this.convert(ip, port);
        if (this.getEntry(this.singleSlotRange.getStartSlot()).slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            String slaveAddr = ip + ":" + port;
            this.log.info("slave: {} has up", (Object)slaveAddr);
        }
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((SentinelServersConfig)cfg).getDatabase());
        return res;
    }

    public Collection<RedisClient> getSentinels() {
        return this.sentinels.values();
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
        for (RedisClient redisClient : this.sentinels.values()) {
            RFuture<Void> future = redisClient.shutdownAsync();
            futures.add(future);
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
        super.shutdown();
    }

    private String applyNatMap(String ip) {
        String mappedAddress = this.natMap.get(ip);
        if (mappedAddress != null) {
            return mappedAddress;
        }
        return ip;
    }
}

