/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.Arrays;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionTask;

public class JCacheEvictionTask
extends EvictionTask {
    private final String name;
    private final String timeoutSetName;
    private final String expiredChannelName;

    public JCacheEvictionTask(String name, String timeoutSetName, String expiredChannelName, CommandAsyncExecutor executor) {
        super(executor);
        this.name = name;
        this.timeoutSetName = timeoutSetName;
        this.expiredChannelName = expiredChannelName;
    }

    @Override
    String getName() {
        return this.name;
    }

    @Override
    RFuture<Integer> execute() {
        return this.executor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); for i, k in ipairs(expiredKeys) do local v = redis.call('hget', KEYS[1], k);local msg = struct.pack('Lc0Lc0', string.len(tostring(k)), tostring(k), string.len(tostring(v)), tostring(v));redis.call('publish', KEYS[3], msg);end; if #expiredKeys > 0 then redis.call('zrem', KEYS[2], unpack(expiredKeys)); redis.call('hdel', KEYS[1], unpack(expiredKeys)); end; return #expiredKeys;", Arrays.asList(this.name, this.timeoutSetName, this.expiredChannelName), System.currentTimeMillis(), 100);
    }
}

