/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.RedissonRx;
import org.redisson.api.RLockRx;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RedissonRxClient;
import org.redisson.rx.RedissonMapRxIterator;

public class RedissonMapRx<K, V> {
    private final RedissonMap<K, V> instance;
    private final RedissonRxClient redisson;

    public RedissonMapRx(RMap<K, V> instance, RedissonRx redisson) {
        this.instance = (RedissonMap)instance;
        this.redisson = redisson;
    }

    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new RedissonMapRxIterator(this.instance, pattern, count).create();
    }

    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    public Publisher<V> valueIterator(String pattern, int count) {
        return new RedissonMapRxIterator<K, V, V>(this.instance, pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        }.create();
    }

    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    public Publisher<K> keyIterator(String pattern, int count) {
        return new RedissonMapRxIterator<K, V, K>(this.instance, pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        }.create();
    }

    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(K key) {
        String name = this.instance.getLockByMapKey(key, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreRx getSemaphore(K key) {
        String name = this.instance.getLockByMapKey(key, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockRx getFairLock(K key) {
        String name = this.instance.getLockByMapKey(key, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockRx getReadWriteLock(K key) {
        String name = this.instance.getLockByMapKey(key, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockRx getLock(K key) {
        String name = this.instance.getLockByMapKey(key, "lock");
        return this.redisson.getLock(name);
    }
}

