/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.redisson.api.RFuture;
import org.redisson.misc.ProxyBuilder;
import org.redisson.rx.CommandRxExecutor;

public class RxProxyBuilder {
    public static <T> T create(CommandRxExecutor commandExecutor, Object instance, Class<T> clazz) {
        return RxProxyBuilder.create(commandExecutor, instance, null, clazz);
    }

    public static <T> T create(final CommandRxExecutor commandExecutor, Object instance, Object implementation, Class<T> clazz) {
        return ProxyBuilder.create(new ProxyBuilder.Callback(){

            @Override
            public Object execute(final Method mm, final Object instance, Method instanceMethod, final Object[] args) {
                Flowable<Object> flowable = commandExecutor.flowable(new Callable<RFuture<Object>>(){

                    @Override
                    public RFuture<Object> call() throws Exception {
                        return (RFuture)mm.invoke(instance, args);
                    }
                });
                if (instanceMethod.getReturnType() == Completable.class) {
                    return flowable.ignoreElements();
                }
                if (instanceMethod.getReturnType() == Single.class) {
                    return flowable.singleOrError();
                }
                return flowable.singleElement();
            }
        }, instance, implementation, clazz);
    }
}

