/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import jline.AnsiWindowsTerminal;
import jline.OSvTerminal;
import jline.Terminal;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.internal.Configuration;
import jline.internal.Log;
import jline.internal.Preconditions;

public class TerminalFactory {
    public static final String JLINE_TERMINAL = "jline.terminal";
    public static final String AUTO = "auto";
    public static final String UNIX = "unix";
    public static final String OSV = "osv";
    public static final String WIN = "win";
    public static final String WINDOWS = "windows";
    public static final String FREEBSD = "freebsd";
    public static final String NONE = "none";
    public static final String OFF = "off";
    public static final String FALSE = "false";
    private static Terminal term = null;
    private static final Map<Flavor, Class<? extends Terminal>> FLAVORS = new HashMap<Flavor, Class<? extends Terminal>>();

    public static synchronized Terminal create() {
        return TerminalFactory.create(null);
    }

    public static synchronized Terminal create(String string) {
        Terminal terminal;
        block15: {
            if (Log.TRACE) {
                Log.trace(new Throwable("CREATE MARKER"));
            }
            String string2 = "dumb".equals(System.getenv("TERM")) ? NONE : AUTO;
            String string3 = Configuration.getString(JLINE_TERMINAL, string2);
            Log.debug("Creating terminal; type=", string3);
            try {
                String string4 = string3.toLowerCase();
                if (string4.equals(UNIX)) {
                    terminal = TerminalFactory.getFlavor(Flavor.UNIX);
                    break block15;
                }
                if (string4.equals(OSV)) {
                    terminal = TerminalFactory.getFlavor(Flavor.OSV);
                    break block15;
                }
                if (string4.equals(WIN) || string4.equals(WINDOWS)) {
                    terminal = TerminalFactory.getFlavor(Flavor.WINDOWS);
                    break block15;
                }
                if (string4.equals(NONE) || string4.equals(OFF) || string4.equals(FALSE)) {
                    terminal = System.getenv("INSIDE_EMACS") != null ? new UnsupportedTerminal(true, false) : new UnsupportedTerminal(false, true);
                    break block15;
                }
                if (string4.equals(AUTO)) {
                    String string5 = Configuration.getOsName();
                    Flavor flavor = Flavor.UNIX;
                    if (string5.contains(WINDOWS)) {
                        flavor = Flavor.WINDOWS;
                    } else if (System.getenv("OSV_CPUS") != null) {
                        flavor = Flavor.OSV;
                    }
                    terminal = TerminalFactory.getFlavor(flavor, string);
                    break block15;
                }
                try {
                    terminal = (Terminal)Thread.currentThread().getContextClassLoader().loadClass(string3).newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(MessageFormat.format("Invalid terminal type: {0}", string3), exception);
                }
            }
            catch (Exception exception) {
                Log.error("Failed to construct terminal; falling back to unsupported", exception);
                terminal = new UnsupportedTerminal();
            }
        }
        Log.debug("Created Terminal: ", terminal);
        try {
            terminal.init();
        }
        catch (Throwable throwable) {
            Log.error("Terminal initialization failed; falling back to unsupported", throwable);
            return new UnsupportedTerminal();
        }
        return terminal;
    }

    public static synchronized void reset() {
        term = null;
    }

    public static synchronized void resetIf(Terminal terminal) {
        if (terminal == term) {
            TerminalFactory.reset();
        }
    }

    public static synchronized void configure(String string) {
        Preconditions.checkNotNull(string);
        System.setProperty(JLINE_TERMINAL, string);
    }

    public static synchronized void configure(Type type) {
        Preconditions.checkNotNull(type);
        TerminalFactory.configure(type.name().toLowerCase());
    }

    public static synchronized Terminal get(String string) {
        if (term == null) {
            term = TerminalFactory.create(string);
        }
        return term;
    }

    public static synchronized Terminal get() {
        return TerminalFactory.get(null);
    }

    public static synchronized void set(Terminal terminal) {
        term = terminal;
    }

    public static Terminal getFlavor(Flavor flavor) throws Exception {
        return TerminalFactory.getFlavor(flavor, null);
    }

    public static Terminal getFlavor(Flavor flavor, String string) throws Exception {
        Class<? extends Terminal> clazz = FLAVORS.get((Object)flavor);
        Terminal terminal = null;
        if (clazz != null) {
            Constructor<? extends Terminal> constructor;
            terminal = string != null ? ((constructor = clazz.getConstructor(String.class)) != null ? constructor.newInstance(string) : clazz.newInstance()) : clazz.newInstance();
        } else {
            throw new InternalError();
        }
        return terminal;
    }

    public static void registerFlavor(Flavor flavor, Class<? extends Terminal> clazz) {
        FLAVORS.put(flavor, clazz);
    }

    static {
        TerminalFactory.registerFlavor(Flavor.WINDOWS, AnsiWindowsTerminal.class);
        TerminalFactory.registerFlavor(Flavor.UNIX, UnixTerminal.class);
        TerminalFactory.registerFlavor(Flavor.OSV, OSvTerminal.class);
    }

    public static enum Flavor {
        WINDOWS,
        UNIX,
        OSV;

    }

    public static enum Type {
        AUTO,
        WINDOWS,
        UNIX,
        OSV,
        NONE;

    }
}

