/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jline.TerminalSupport;
import jline.internal.Configuration;
import jline.internal.Log;
import org.fusesource.jansi.internal.Kernel32;

public class WindowsTerminal
extends TerminalSupport {
    public static final String DIRECT_CONSOLE = WindowsTerminal.class.getName() + ".directConsole";
    public static final String ANSI = WindowsTerminal.class.getName() + ".ansi";
    private boolean directConsole;
    private int originalMode;

    public WindowsTerminal() throws Exception {
        super(true);
    }

    private static int getConsoleMode() {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_INPUT_HANDLE);
        if (l == (long)Kernel32.INVALID_HANDLE_VALUE) {
            return -1;
        }
        int[] nArray = new int[1];
        if (Kernel32.GetConsoleMode((long)l, (int[])nArray) == 0) {
            return -1;
        }
        return nArray[0];
    }

    private static void setConsoleMode(int n) {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_INPUT_HANDLE);
        if (l == (long)Kernel32.INVALID_HANDLE_VALUE) {
            return;
        }
        Kernel32.SetConsoleMode((long)l, (int)n);
    }

    private static int getWindowsTerminalWidth() {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.GetConsoleScreenBufferInfo((long)l, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)cONSOLE_SCREEN_BUFFER_INFO);
        return cONSOLE_SCREEN_BUFFER_INFO.windowWidth();
    }

    private static int getWindowsTerminalHeight() {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO cONSOLE_SCREEN_BUFFER_INFO = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.GetConsoleScreenBufferInfo((long)l, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)cONSOLE_SCREEN_BUFFER_INFO);
        return cONSOLE_SCREEN_BUFFER_INFO.windowHeight();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(Configuration.getBoolean(ANSI, true));
        this.setDirectConsole(Configuration.getBoolean(DIRECT_CONSOLE, true));
        this.originalMode = WindowsTerminal.getConsoleMode();
        WindowsTerminal.setConsoleMode(this.originalMode & ~ConsoleMode.ENABLE_ECHO_INPUT.code);
        this.setEchoEnabled(false);
    }

    @Override
    public void restore() throws Exception {
        WindowsTerminal.setConsoleMode(this.originalMode);
        super.restore();
    }

    @Override
    public int getWidth() {
        int n = WindowsTerminal.getWindowsTerminalWidth();
        return n < 1 ? 80 : n;
    }

    @Override
    public int getHeight() {
        int n = WindowsTerminal.getWindowsTerminalHeight();
        return n < 1 ? 24 : n;
    }

    @Override
    public void setEchoEnabled(boolean bl) {
        if (bl) {
            WindowsTerminal.setConsoleMode(WindowsTerminal.getConsoleMode() | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code);
        } else {
            WindowsTerminal.setConsoleMode(WindowsTerminal.getConsoleMode() & ~(ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code));
        }
        super.setEchoEnabled(bl);
    }

    @Override
    public void disableInterruptCharacter() {
        WindowsTerminal.setConsoleMode(WindowsTerminal.getConsoleMode() & ~ConsoleMode.ENABLE_PROCESSED_INPUT.code);
    }

    @Override
    public void enableInterruptCharacter() {
        WindowsTerminal.setConsoleMode(WindowsTerminal.getConsoleMode() | ConsoleMode.ENABLE_PROCESSED_INPUT.code);
    }

    public void setDirectConsole(boolean bl) {
        this.directConsole = bl;
        Log.debug("Direct console: ", bl);
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream inputStream) throws IOException {
        if (this.directConsole && this.isSystemIn(inputStream)) {
            return new InputStream(){
                private byte[] buf = null;
                int bufIdx = 0;

                @Override
                public int read() throws IOException {
                    while (this.buf == null || this.bufIdx == this.buf.length) {
                        this.buf = WindowsTerminal.this.readConsoleInput();
                        this.bufIdx = 0;
                    }
                    int n = this.buf[this.bufIdx] & 0xFF;
                    ++this.bufIdx;
                    return n;
                }
            };
        }
        return super.wrapInIfNeeded(inputStream);
    }

    protected boolean isSystemIn(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return false;
        }
        if (inputStream == System.in) {
            return true;
        }
        return inputStream instanceof FileInputStream && ((FileInputStream)inputStream).getFD() == FileDescriptor.in;
    }

    @Override
    public String getOutputEncoding() {
        int n = WindowsTerminal.getConsoleOutputCodepage();
        String string = "ms" + n;
        if (Charset.isSupported(string)) {
            return string;
        }
        String string2 = "cp" + n;
        if (Charset.isSupported(string2)) {
            return string2;
        }
        Log.debug("can't figure out the Java Charset of this code page (" + n + ")...");
        return super.getOutputEncoding();
    }

    private static Kernel32.INPUT_RECORD[] readConsoleInput(int n) throws IOException {
        long l = Kernel32.GetStdHandle((int)Kernel32.STD_INPUT_HANDLE);
        if (l == (long)Kernel32.INVALID_HANDLE_VALUE) {
            return null;
        }
        return Kernel32.readConsoleInputHelper((long)l, (int)n, (boolean)false);
    }

    private byte[] readConsoleInput() {
        Kernel32.INPUT_RECORD[] iNPUT_RECORDArray = null;
        try {
            iNPUT_RECORDArray = WindowsTerminal.readConsoleInput(1);
        }
        catch (IOException iOException) {
            Log.debug("read Windows console input error: ", iOException);
        }
        if (iNPUT_RECORDArray == null) {
            return new byte[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iNPUT_RECORDArray.length; ++i) {
            Kernel32.KEY_EVENT_RECORD kEY_EVENT_RECORD = iNPUT_RECORDArray[i].keyEvent;
            if (kEY_EVENT_RECORD.keyDown) {
                int n;
                if (kEY_EVENT_RECORD.uchar > '\u0000') {
                    int n2 = Kernel32.KEY_EVENT_RECORD.LEFT_ALT_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_ALT_PRESSED;
                    n = Kernel32.KEY_EVENT_RECORD.LEFT_CTRL_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_CTRL_PRESSED;
                    if ((kEY_EVENT_RECORD.uchar >= '@' && kEY_EVENT_RECORD.uchar <= '_' || kEY_EVENT_RECORD.uchar >= 'a' && kEY_EVENT_RECORD.uchar <= 'z') && (kEY_EVENT_RECORD.controlKeyState & n2) != 0 && (kEY_EVENT_RECORD.controlKeyState & n) == 0) {
                        stringBuilder.append('\u001b');
                    }
                    stringBuilder.append(kEY_EVENT_RECORD.uchar);
                    continue;
                }
                String string = null;
                switch (kEY_EVENT_RECORD.keyCode) {
                    case 33: {
                        string = "\u001b[5~";
                        break;
                    }
                    case 34: {
                        string = "\u001b[6~";
                        break;
                    }
                    case 35: {
                        string = "\u001b[4~";
                        break;
                    }
                    case 36: {
                        string = "\u001b[1~";
                        break;
                    }
                    case 37: {
                        string = "\u001b[D";
                        break;
                    }
                    case 38: {
                        string = "\u001b[A";
                        break;
                    }
                    case 39: {
                        string = "\u001b[C";
                        break;
                    }
                    case 40: {
                        string = "\u001b[B";
                        break;
                    }
                    case 45: {
                        string = "\u001b[2~";
                        break;
                    }
                    case 46: {
                        string = "\u001b[3~";
                        break;
                    }
                }
                if (string == null) continue;
                for (n = 0; n < kEY_EVENT_RECORD.repeatCount; ++n) {
                    stringBuilder.append(string);
                }
                continue;
            }
            if (kEY_EVENT_RECORD.keyCode != 18 || kEY_EVENT_RECORD.uchar <= '\u0000') continue;
            stringBuilder.append(kEY_EVENT_RECORD.uchar);
        }
        return stringBuilder.toString().getBytes();
    }

    private static int getConsoleOutputCodepage() {
        return Kernel32.GetConsoleOutputCP();
    }

    public static enum ConsoleMode {
        ENABLE_LINE_INPUT(2),
        ENABLE_ECHO_INPUT(4),
        ENABLE_PROCESSED_INPUT(1),
        ENABLE_WINDOW_INPUT(8),
        ENABLE_MOUSE_INPUT(16),
        ENABLE_PROCESSED_OUTPUT(1),
        ENABLE_WRAP_AT_EOL_OUTPUT(2);

        public final int code;

        private ConsoleMode(int n2) {
            this.code = n2;
        }
    }
}

