/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Stack;
import jline.DefaultTerminal2;
import jline.Terminal;
import jline.Terminal2;
import jline.TerminalFactory;
import jline.UnixTerminal;
import jline.console.ConsoleKeys;
import jline.console.CursorBuffer;
import jline.console.KeyMap;
import jline.console.KillRing;
import jline.console.Operation;
import jline.console.UserInterruptException;
import jline.console.WCWidth;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.Ansi;
import jline.internal.Configuration;
import jline.internal.Curses;
import jline.internal.InputStreamReader;
import jline.internal.Log;
import jline.internal.NonBlockingInputStream;
import jline.internal.Nullable;
import jline.internal.Preconditions;
import jline.internal.Urls;

public class ConsoleReader
implements Closeable {
    public static final String JLINE_NOBELL = "jline.nobell";
    public static final String JLINE_ESC_TIMEOUT = "jline.esc.timeout";
    public static final String JLINE_INPUTRC = "jline.inputrc";
    public static final String INPUT_RC = ".inputrc";
    public static final String DEFAULT_INPUT_RC = "/etc/inputrc";
    public static final String JLINE_EXPAND_EVENTS = "jline.expandevents";
    public static final char BACKSPACE = '\b';
    public static final char RESET_LINE = '\r';
    public static final char KEYBOARD_BELL = '\u0007';
    public static final char NULL_MASK = '\u0000';
    public static final int TAB_WIDTH = 8;
    private static final ResourceBundle resources = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName());
    private static final int ESCAPE = 27;
    private static final int READ_EXPIRED = -2;
    private final Terminal2 terminal;
    private final Writer out;
    private final CursorBuffer buf = new CursorBuffer();
    private boolean cursorOk;
    private String prompt;
    private int promptLen;
    private boolean expandEvents = Configuration.getBoolean("jline.expandevents", true);
    private boolean bellEnabled = !Configuration.getBoolean("jline.nobell", true);
    private boolean handleUserInterrupt = false;
    private boolean handleLitteralNext = true;
    private Character mask;
    private Character echoCharacter;
    private CursorBuffer originalBuffer = null;
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    private int parenBlinkTimeout = 500;
    private final StringBuilder opBuffer = new StringBuilder();
    private final Stack<Character> pushBackChar = new Stack();
    private NonBlockingInputStream in;
    private long escapeTimeout;
    private Reader reader;
    private char charSearchChar = '\u0000';
    private char charSearchLastInvokeChar = '\u0000';
    private char charSearchFirstInvokeChar = '\u0000';
    private String yankBuffer = "";
    private KillRing killRing = new KillRing();
    private String encoding;
    private boolean quotedInsert;
    private boolean recording;
    private String macro = "";
    private String appName;
    private URL inputrcUrl;
    private ConsoleKeys consoleKeys;
    private String commentBegin = null;
    private boolean skipLF = false;
    private boolean copyPasteDetection = false;
    private State state = State.NORMAL;
    public static final String JLINE_COMPLETION_THRESHOLD = "jline.completion.threshold";
    private final List<Completer> completers = new LinkedList<Completer>();
    private CompletionHandler completionHandler = new CandidateListCompletionHandler();
    private int autoprintThreshold = Configuration.getInteger("jline.completion.threshold", 100);
    private boolean paginationEnabled;
    private History history = new MemoryHistory();
    private boolean historyEnabled = true;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Thread maskThread;

    private static InputStream wrapSystemIn() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return System.in.read();
            }
        };
    }

    private static OutputStream wrapSystemOut() {
        return new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                System.out.write(n);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                System.out.write(byArray, n, n2);
                System.out.flush();
            }

            @Override
            public void flush() throws IOException {
                System.out.flush();
            }
        };
    }

    public ConsoleReader() throws IOException {
        this(null, ConsoleReader.wrapSystemIn(), ConsoleReader.wrapSystemOut(), null);
    }

    public ConsoleReader(InputStream inputStream, OutputStream outputStream) throws IOException {
        this(null, inputStream, outputStream, null);
    }

    public ConsoleReader(InputStream inputStream, OutputStream outputStream, Terminal terminal) throws IOException {
        this(null, inputStream, outputStream, terminal);
    }

    public ConsoleReader(@Nullable String string, InputStream inputStream, OutputStream outputStream, @Nullable Terminal terminal) throws IOException {
        this(string, inputStream, outputStream, terminal, null);
    }

    public ConsoleReader(@Nullable String string, InputStream inputStream, OutputStream outputStream, @Nullable Terminal terminal, @Nullable String string2) throws IOException {
        this.appName = string != null ? string : "JLine";
        this.encoding = string2 != null ? string2 : Configuration.getEncoding();
        Terminal terminal2 = terminal != null ? terminal : TerminalFactory.get();
        this.terminal = terminal2 instanceof Terminal2 ? (Terminal2)terminal2 : new DefaultTerminal2(terminal2);
        String string3 = terminal2.getOutputEncoding() != null ? terminal2.getOutputEncoding() : this.encoding;
        this.out = new OutputStreamWriter(terminal2.wrapOutIfNeeded(outputStream), string3);
        this.setInput(inputStream);
        this.inputrcUrl = ConsoleReader.getInputRc();
        this.consoleKeys = new ConsoleKeys(this.appName, this.inputrcUrl);
        if (terminal2 instanceof UnixTerminal && "/dev/tty".equals(((UnixTerminal)terminal2).getSettings().getTtyDevice()) && Configuration.getBoolean("jline.sigcont", false)) {
            this.setupSigCont();
        }
    }

    private void setupSigCont() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Signal");
            Class<?> clazz2 = Class.forName("sun.misc.SignalHandler");
            Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz2}, new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    ConsoleReader.this.terminal.init();
                    try {
                        ConsoleReader.this.drawLine();
                        ConsoleReader.this.flush();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return null;
                }
            });
            clazz.getMethod("handle", clazz, clazz2).invoke(null, clazz.getConstructor(String.class).newInstance("CONT"), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL getInputRc() throws IOException {
        String string = Configuration.getString(JLINE_INPUTRC);
        if (string == null) {
            File file = new File(Configuration.getUserHome(), INPUT_RC);
            if (!file.exists()) {
                file = new File(DEFAULT_INPUT_RC);
            }
            return file.toURI().toURL();
        }
        return Urls.create(string);
    }

    public KeyMap getKeys() {
        return this.consoleKeys.getKeys();
    }

    void setInput(InputStream inputStream) throws IOException {
        boolean bl;
        this.escapeTimeout = Configuration.getLong(JLINE_ESC_TIMEOUT, 100L);
        boolean bl2 = bl = this.escapeTimeout > 0L && this.terminal.isSupported() && inputStream != null;
        if (this.in != null) {
            this.in.shutdown();
        }
        InputStream inputStream2 = this.terminal.wrapInIfNeeded(inputStream);
        this.in = new NonBlockingInputStream(inputStream2, bl);
        this.reader = new InputStreamReader((InputStream)this.in, this.encoding);
    }

    @Override
    public void close() {
        if (this.in != null) {
            this.in.shutdown();
        }
    }

    @Deprecated
    public void shutdown() {
        this.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public InputStream getInput() {
        return this.in;
    }

    public Writer getOutput() {
        return this.out;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void setExpandEvents(boolean bl) {
        this.expandEvents = bl;
    }

    public boolean getExpandEvents() {
        return this.expandEvents;
    }

    public void setCopyPasteDetection(boolean bl) {
        this.copyPasteDetection = bl;
    }

    public boolean isCopyPasteDetectionEnabled() {
        return this.copyPasteDetection;
    }

    public void setBellEnabled(boolean bl) {
        this.bellEnabled = bl;
    }

    public boolean getBellEnabled() {
        return this.bellEnabled;
    }

    public void setHandleUserInterrupt(boolean bl) {
        this.handleUserInterrupt = bl;
    }

    public boolean getHandleUserInterrupt() {
        return this.handleUserInterrupt;
    }

    public void setHandleLitteralNext(boolean bl) {
        this.handleLitteralNext = bl;
    }

    public boolean getHandleLitteralNext() {
        return this.handleLitteralNext;
    }

    public void setCommentBegin(String string) {
        this.commentBegin = string;
    }

    public String getCommentBegin() {
        String string = this.commentBegin;
        if (string == null && (string = this.consoleKeys.getVariable("comment-begin")) == null) {
            string = "#";
        }
        return string;
    }

    public void setPrompt(String string) {
        this.prompt = string;
        this.promptLen = string == null ? 0 : this.wcwidth(Ansi.stripAnsi(ConsoleReader.lastLine(string)), 0);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setEchoCharacter(Character c) {
        this.echoCharacter = c;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    protected final boolean resetLine() throws IOException {
        char c;
        if (this.buf.cursor == 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (this.buf.cursor > 0 && (c = this.buf.current()) != '\u0000') {
            stringBuilder.append(c);
            this.backspace();
        }
        String string = stringBuilder.reverse().toString();
        this.killRing.addBackwards(string);
        return true;
    }

    int wcwidth(CharSequence charSequence, int n) {
        return this.wcwidth(charSequence, 0, charSequence.length(), n);
    }

    int wcwidth(CharSequence charSequence, int n, int n2, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < n2) {
            int n6;
            int n7;
            if (!Character.isHighSurrogate((char)(n7 = charSequence.charAt(n5++))) || n5 >= n2) {
                n6 = n7;
            } else {
                char c = charSequence.charAt(n5);
                if (Character.isLowSurrogate(c)) {
                    ++n5;
                    n6 = Character.toCodePoint((char)n7, c);
                } else {
                    n6 = n7;
                }
            }
            n4 += this.wcwidth(n6, n4);
        }
        return n4 - n3;
    }

    int wcwidth(int n, int n2) {
        if (n == 9) {
            return this.nextTabStop(n2);
        }
        if (n < 32) {
            return 2;
        }
        int n3 = WCWidth.wcwidth(n);
        return n3 > 0 ? n3 : 0;
    }

    int nextTabStop(int n) {
        int n2 = 8;
        int n3 = (n + n2 - 1) % n2;
        int n4 = n + n2 - n3;
        int n5 = this.getTerminal().getWidth();
        return n4 < n5 ? n4 - n : n5 - n;
    }

    int getCursorPosition() {
        return this.promptLen + this.wcwidth(this.buf.buffer, 0, this.buf.cursor, this.promptLen);
    }

    private static String lastLine(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf("\n");
        if (n >= 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public boolean setCursorPosition(int n) throws IOException {
        if (n == this.buf.cursor) {
            return true;
        }
        return this.moveCursor(n - this.buf.cursor) != 0;
    }

    private void setBuffer(String string) throws IOException {
        int n;
        if (string.equals(this.buf.buffer.toString())) {
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.buf.buffer.length();
        for (n = 0; n < n3 && n < n4 && string.charAt(n) == this.buf.buffer.charAt(n); ++n) {
            ++n2;
        }
        n = this.buf.cursor - n2;
        if (n < 0) {
            this.moveToEnd();
            n = this.buf.buffer.length() - n2;
        }
        this.backspace(n);
        this.killLine();
        this.buf.buffer.setLength(n2);
        this.putString(string.substring(n2));
    }

    private void setBuffer(CharSequence charSequence) throws IOException {
        this.setBuffer(String.valueOf(charSequence));
    }

    private void setBufferKeepPos(String string) throws IOException {
        int n = this.buf.cursor;
        this.setBuffer(string);
        this.setCursorPosition(n);
    }

    private void setBufferKeepPos(CharSequence charSequence) throws IOException {
        this.setBufferKeepPos(String.valueOf(charSequence));
    }

    public void drawLine() throws IOException {
        String string = this.getPrompt();
        if (string != null) {
            this.rawPrint(string);
        }
        this.fmtPrint(this.buf.buffer, 0, this.buf.cursor, this.promptLen);
        this.drawBuffer();
    }

    public void redrawLine() throws IOException {
        this.tputs("carriage_return", new Object[0]);
        this.drawLine();
    }

    final String finishBuffer() throws IOException {
        String string;
        String string2 = string = this.buf.buffer.toString();
        if (this.expandEvents) {
            try {
                string = this.expandEvents(string);
                string2 = string.replace("!", "\\!");
                string2 = string2.replaceAll("^\\^", "\\\\^");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.error("Could not expand event", illegalArgumentException);
                this.beep();
                this.buf.clear();
                string = "";
            }
        }
        if (string.length() > 0) {
            if (this.mask == null && this.isHistoryEnabled()) {
                this.history.add(string2);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return string;
    }

    protected String expandEvents(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        block16: for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            switch (n) {
                case 92: {
                    int n2;
                    if (i + 1 < string.length() && ((n2 = (int)string.charAt(i + 1)) == 33 || n2 == 94 && i == 0)) {
                        n = n2;
                        ++i;
                    }
                    stringBuilder.append((char)n);
                    continue block16;
                }
                case 33: {
                    String string2;
                    int n2;
                    if (i + 1 < string.length()) {
                        n = string.charAt(++i);
                        n2 = 0;
                        String string3 = null;
                        switch (n) {
                            case 33: {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!!: event not found");
                                }
                                string3 = this.history.get(this.history.index() - 1).toString();
                                break;
                            }
                            case 35: {
                                stringBuilder.append(stringBuilder.toString());
                                break;
                            }
                            case 63: {
                                int n3 = string.indexOf(63, i + 1);
                                if (n3 < 0) {
                                    n3 = string.length();
                                }
                                string2 = string.substring(i + 1, n3);
                                i = n3;
                                int n4 = this.searchBackwards(string2);
                                if (n4 < 0) {
                                    throw new IllegalArgumentException("!?" + string2 + ": event not found");
                                }
                                string3 = this.history.get(n4).toString();
                                break;
                            }
                            case 36: {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!$: event not found");
                                }
                                String string4 = this.history.get(this.history.index() - 1).toString().trim();
                                int n5 = string4.lastIndexOf(32);
                                if (n5 != -1) {
                                    string3 = string4.substring(n5 + 1);
                                    break;
                                }
                                string3 = string4;
                                break;
                            }
                            case 9: 
                            case 32: {
                                stringBuilder.append('!');
                                stringBuilder.append((char)n);
                                break;
                            }
                            case 45: {
                                n2 = 1;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                int n6 = ++i;
                                while (i < string.length() && (n = string.charAt(i)) >= 48 && n <= 57) {
                                    ++i;
                                }
                                int n7 = 0;
                                try {
                                    n7 = Integer.parseInt(string.substring(n6, i));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IllegalArgumentException((n2 != 0 ? "!-" : "!") + string.substring(n6, i) + ": event not found");
                                }
                                if (n2 != 0) {
                                    if (n7 > 0 && n7 <= this.history.size()) {
                                        string3 = this.history.get(this.history.index() - n7).toString();
                                        break;
                                    }
                                    throw new IllegalArgumentException((n2 != 0 ? "!-" : "!") + string.substring(n6, i) + ": event not found");
                                }
                                if (n7 > this.history.index() - this.history.size() && n7 <= this.history.index()) {
                                    string3 = this.history.get(n7 - 1).toString();
                                    break;
                                }
                                throw new IllegalArgumentException((n2 != 0 ? "!-" : "!") + string.substring(n6, i) + ": event not found");
                            }
                            default: {
                                String string5 = string.substring(i);
                                i = string.length();
                                int n8 = this.searchBackwards(string5, this.history.index(), true);
                                if (n8 < 0) {
                                    throw new IllegalArgumentException("!" + string5 + ": event not found");
                                }
                                string3 = this.history.get(n8).toString();
                            }
                        }
                        if (string3 == null) continue block16;
                        stringBuilder.append(string3);
                        continue block16;
                    }
                    stringBuilder.append((char)n);
                    continue block16;
                }
                case 94: {
                    String string2;
                    int n2;
                    if (i == 0) {
                        n2 = string.indexOf(94, i + 1);
                        int n9 = string.indexOf(94, n2 + 1);
                        if (n9 < 0) {
                            n9 = string.length();
                        }
                        if (n2 > 0 && n9 > 0) {
                            String string6 = string.substring(i + 1, n2);
                            String string7 = string.substring(n2 + '\u0001', n9);
                            string2 = this.history.get(this.history.index() - 1).toString().replace(string6, string7);
                            stringBuilder.append(string2);
                            i = n9 + 1;
                            continue block16;
                        }
                    }
                    stringBuilder.append((char)n);
                    continue block16;
                }
                default: {
                    stringBuilder.append((char)n);
                }
            }
        }
        String string8 = stringBuilder.toString();
        if (!string.equals(string8)) {
            this.fmtPrint(string8, this.getCursorPosition());
            this.println();
            this.flush();
        }
        return string8;
    }

    public void putString(CharSequence charSequence) throws IOException {
        int n = this.getCursorPosition();
        this.buf.write(charSequence);
        if (this.mask == null) {
            this.fmtPrint(charSequence, n);
        } else if (this.mask.charValue() != '\u0000') {
            this.rawPrint(this.mask.charValue(), charSequence.length());
        }
        this.drawBuffer();
    }

    private void drawBuffer(int n) throws IOException {
        int n2 = this.buf.length() - this.buf.cursor;
        if (this.buf.cursor != this.buf.length() || n != 0) {
            if (this.mask != null) {
                if (this.mask.charValue() != '\u0000') {
                    this.rawPrint(this.mask.charValue(), n2);
                } else {
                    n2 = 0;
                }
            } else {
                this.fmtPrint(this.buf.buffer, this.buf.cursor, this.buf.length());
            }
        }
        int n3 = this.promptLen + this.wcwidth(this.buf.buffer, 0, this.buf.length(), this.promptLen);
        if (this.terminal.hasWeirdWrap() && !this.cursorOk) {
            int n4 = this.terminal.getWidth();
            if (n3 > 0 && n3 % n4 == 0) {
                this.rawPrint(32);
                this.tputs("carriage_return", new Object[0]);
            }
            this.cursorOk = true;
        }
        this.clearAhead(n, n3);
        this.back(n2);
    }

    private void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private void clearAhead(int n, int n2) throws IOException {
        if (n == 0) {
            return;
        }
        int n3 = this.terminal.getWidth();
        if (this.terminal.getStringCapability("clr_eol") != null) {
            int n4 = n2;
            int n5 = n4 % n3;
            int n6 = Math.min(n, n3 - n5);
            this.tputs("clr_eol", new Object[0]);
            n -= n6;
            while (n > 0) {
                int n7 = n4;
                n4 = n4 - n4 % n3 + n3;
                this.moveCursorFromTo(n7, n4);
                n6 = Math.min(n, n3);
                this.tputs("clr_eol", new Object[0]);
                n -= n6;
            }
            this.moveCursorFromTo(n4, n2);
        } else if (!this.terminal.getBooleanCapability("auto_right_margin")) {
            int n8 = n2;
            int n9 = n8 % n3;
            int n10 = Math.min(n, n3 - n9);
            this.rawPrint(' ', n10);
            n -= n10;
            n8 += n10;
            while (n > 0) {
                this.moveCursorFromTo(n8++, n8);
                n10 = Math.min(n, n3);
                this.rawPrint(' ', n10);
                n -= n10;
                n8 += n10;
            }
            this.moveCursorFromTo(n8, n2);
        } else {
            this.rawPrint(' ', n);
            this.moveCursorFromTo(n2 + n, n2);
        }
    }

    protected void back(int n) throws IOException {
        if (n == 0) {
            return;
        }
        int n2 = this.promptLen + this.wcwidth(this.buf.buffer, 0, this.buf.cursor, this.promptLen);
        int n3 = n2 + (this.mask != null ? n : this.wcwidth(this.buf.buffer, this.buf.cursor, this.buf.cursor + n, n2));
        this.moveCursorFromTo(n3, n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private int backspace(int n) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int n2 = -this.moveCursor(-n);
        int n3 = this.wcwidth(this.buf.buffer, this.buf.cursor, this.buf.cursor + n2, this.getCursorPosition());
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + n2);
        this.drawBuffer(n3);
        return n2;
    }

    public boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    protected boolean moveToEnd() throws IOException {
        if (this.buf.cursor == this.buf.length()) {
            return true;
        }
        return this.moveCursor(this.buf.length() - this.buf.cursor) > 0;
    }

    private boolean deleteCurrentCharacter() throws IOException {
        if (this.buf.length() == 0 || this.buf.cursor == this.buf.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private Operation viDeleteChangeYankToRemap(Operation operation) {
        switch (operation) {
            case VI_EOF_MAYBE: 
            case ABORT: 
            case BACKWARD_CHAR: 
            case FORWARD_CHAR: 
            case END_OF_LINE: 
            case VI_MATCH: 
            case VI_BEGINNING_OF_LINE_OR_ARG_DIGIT: 
            case VI_ARG_DIGIT: 
            case VI_PREV_WORD: 
            case VI_END_WORD: 
            case VI_CHAR_SEARCH: 
            case VI_NEXT_WORD: 
            case VI_FIRST_PRINT: 
            case VI_GOTO_MARK: 
            case VI_COLUMN: 
            case VI_DELETE_TO: 
            case VI_YANK_TO: 
            case VI_CHANGE_TO: {
                return operation;
            }
        }
        return Operation.VI_MOVEMENT_MODE;
    }

    private boolean viRubout(int n) throws IOException {
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            bl = this.backspace();
        }
        return bl;
    }

    private boolean viDelete(int n) throws IOException {
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            bl = this.deleteCurrentCharacter();
        }
        return bl;
    }

    private boolean viChangeCase(int n) throws IOException {
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            boolean bl2 = bl = this.buf.cursor < this.buf.buffer.length();
            if (!bl) continue;
            char c = this.buf.buffer.charAt(this.buf.cursor);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            this.buf.buffer.setCharAt(this.buf.cursor, c);
            this.drawBuffer(1);
            this.moveCursor(1);
        }
        return bl;
    }

    private boolean viChangeChar(int n, int n2) throws IOException {
        if (n2 < 0 || n2 == 27 || n2 == 3) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            boolean bl2 = bl = this.buf.cursor < this.buf.buffer.length();
            if (!bl) continue;
            this.buf.buffer.setCharAt(this.buf.cursor, (char)n2);
            this.drawBuffer(1);
            if (i >= n - 1) continue;
            this.moveCursor(1);
        }
        return bl;
    }

    private boolean viPreviousWord(int n) throws IOException {
        boolean bl = true;
        if (this.buf.cursor == 0) {
            return false;
        }
        int n2 = this.buf.cursor - 1;
        for (int i = 0; n2 > 0 && i < n; ++i) {
            while (n2 > 0 && ConsoleReader.isWhitespace(this.buf.buffer.charAt(n2))) {
                --n2;
            }
            while (n2 > 0 && !ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2 - 1))) {
                --n2;
            }
            if (n2 <= 0 || i >= n - 1) continue;
            --n2;
        }
        this.setCursorPosition(n2);
        return bl;
    }

    private boolean viDeleteTo(int n, int n2, boolean bl) throws IOException {
        if (n == n2) {
            return true;
        }
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        this.setCursorPosition(n);
        this.buf.cursor = n;
        this.buf.buffer.delete(n, n2);
        this.drawBuffer(n2 - n);
        if (!bl && n > 0 && n == this.buf.length()) {
            this.moveCursor(-1);
        }
        return true;
    }

    private boolean viYankTo(int n, int n2) throws IOException {
        int n3 = n;
        if (n2 < n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        if (n == n2) {
            this.yankBuffer = "";
            return true;
        }
        this.yankBuffer = this.buf.buffer.substring(n, n2);
        this.setCursorPosition(n3);
        return true;
    }

    private boolean viPut(int n) throws IOException {
        if (this.yankBuffer.length() == 0) {
            return true;
        }
        if (this.buf.cursor < this.buf.buffer.length()) {
            this.moveCursor(1);
        }
        for (int i = 0; i < n; ++i) {
            this.putString(this.yankBuffer);
        }
        this.moveCursor(-1);
        return true;
    }

    private boolean viCharSearch(int n, int n2, int n3) throws IOException {
        if (n3 < 0 || n2 < 0) {
            return false;
        }
        char c = (char)n3;
        if (n2 == 59 || n2 == 44) {
            if (this.charSearchChar == '\u0000') {
                return false;
            }
            if (this.charSearchLastInvokeChar == ';' || this.charSearchLastInvokeChar == ',') {
                if (this.charSearchLastInvokeChar != n2) {
                    this.charSearchFirstInvokeChar = ConsoleReader.switchCase(this.charSearchFirstInvokeChar);
                }
            } else if (n2 == 44) {
                this.charSearchFirstInvokeChar = ConsoleReader.switchCase(this.charSearchFirstInvokeChar);
            }
            c = this.charSearchChar;
        } else {
            this.charSearchChar = c;
            this.charSearchFirstInvokeChar = (char)n2;
        }
        this.charSearchLastInvokeChar = (char)n2;
        boolean bl = Character.isLowerCase(this.charSearchFirstInvokeChar);
        boolean bl2 = Character.toLowerCase(this.charSearchFirstInvokeChar) == 't';
        boolean bl3 = false;
        if (bl) {
            block0: while (n-- > 0) {
                for (int i = this.buf.cursor + 1; i < this.buf.buffer.length(); ++i) {
                    if (this.buf.buffer.charAt(i) != c) continue;
                    this.setCursorPosition(i);
                    bl3 = true;
                    continue block0;
                }
            }
            if (bl3) {
                if (bl2) {
                    this.moveCursor(-1);
                }
                if (this.isInViMoveOperationState()) {
                    this.moveCursor(1);
                }
            }
        } else {
            block2: while (n-- > 0) {
                for (int i = this.buf.cursor - 1; i >= 0; --i) {
                    if (this.buf.buffer.charAt(i) != c) continue;
                    this.setCursorPosition(i);
                    bl3 = true;
                    continue block2;
                }
            }
            if (bl3 && bl2) {
                this.moveCursor(1);
            }
        }
        return bl3;
    }

    private static char switchCase(char c) {
        if (Character.isUpperCase(c)) {
            return Character.toLowerCase(c);
        }
        return Character.toUpperCase(c);
    }

    private final boolean isInViMoveOperationState() {
        return this.state == State.VI_CHANGE_TO || this.state == State.VI_DELETE_TO || this.state == State.VI_YANK_TO;
    }

    private boolean viNextWord(int n) throws IOException {
        int n2 = this.buf.cursor;
        int n3 = this.buf.buffer.length();
        for (int i = 0; n2 < n3 && i < n; ++i) {
            while (n2 < n3 && !ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2))) {
                ++n2;
            }
            if (i >= n - 1 && this.state == State.VI_CHANGE_TO) continue;
            while (n2 < n3 && ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2))) {
                ++n2;
            }
        }
        this.setCursorPosition(n2);
        return true;
    }

    private boolean viEndWord(int n) throws IOException {
        int n2 = this.buf.cursor;
        int n3 = this.buf.buffer.length();
        for (int i = 0; n2 < n3 && i < n; ++i) {
            if (n2 < n3 - 1 && !ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2)) && ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2 + 1))) {
                ++n2;
            }
            while (n2 < n3 && ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2))) {
                ++n2;
            }
            while (n2 < n3 - 1 && !ConsoleReader.isDelimiter(this.buf.buffer.charAt(n2 + 1))) {
                ++n2;
            }
        }
        this.setCursorPosition(n2);
        return true;
    }

    private boolean previousWord() throws IOException {
        while (ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!ConsoleReader.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private boolean nextWord() throws IOException {
        while (ConsoleReader.isDelimiter(this.buf.nextChar()) && this.moveCursor(1) != 0) {
        }
        while (!ConsoleReader.isDelimiter(this.buf.nextChar()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private boolean unixWordRubout(int n) throws IOException {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            char c;
            if (this.buf.cursor == 0) {
                bl = false;
                break;
            }
            while (ConsoleReader.isWhitespace(this.buf.current()) && (c = this.buf.current()) != '\u0000') {
                stringBuilder.append(c);
                this.backspace();
            }
            while (!ConsoleReader.isWhitespace(this.buf.current()) && (c = this.buf.current()) != '\u0000') {
                stringBuilder.append(c);
                this.backspace();
            }
            --n;
        }
        String string = stringBuilder.reverse().toString();
        this.killRing.addBackwards(string);
        return bl;
    }

    private String insertComment(boolean bl) throws IOException {
        String string = this.getCommentBegin();
        this.setCursorPosition(0);
        this.putString(string);
        if (bl) {
            this.consoleKeys.setKeyMap("vi-insert");
        }
        return this.accept();
    }

    private int viSearch(char c) throws IOException {
        int n;
        int n2;
        int n3 = c == '/' ? 1 : 0;
        CursorBuffer cursorBuffer = this.buf.copy();
        this.setCursorPosition(0);
        this.killLine();
        this.putString(Character.toString(c));
        this.flush();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = -1;
        while (!bl && !bl2 && (n4 = this.readCharacter()) != -1) {
            switch (n4) {
                case 27: {
                    bl = true;
                    break;
                }
                case 8: 
                case 127: {
                    this.backspace();
                    if (this.buf.cursor != 0) break;
                    bl = true;
                    break;
                }
                case 10: 
                case 13: {
                    bl2 = true;
                    break;
                }
                default: {
                    this.putString(Character.toString((char)n4));
                }
            }
            this.flush();
        }
        if (n4 == -1 || bl) {
            this.setCursorPosition(0);
            this.killLine();
            this.putString(cursorBuffer.buffer);
            this.setCursorPosition(cursorBuffer.cursor);
            return -1;
        }
        String string = this.buf.buffer.substring(1);
        int n5 = -1;
        int n6 = this.history.index();
        int n7 = n2 = n6 <= this.history.size() ? 0 : n6 - this.history.size();
        if (n3 != 0) {
            for (n = n2; n < n6; ++n) {
                if (!this.history.get(n).toString().contains(string)) continue;
                n5 = n;
                break;
            }
        } else {
            for (n = n6 - 1; n >= n2; --n) {
                if (!this.history.get(n).toString().contains(string)) continue;
                n5 = n;
                break;
            }
        }
        if (n5 == -1) {
            this.setCursorPosition(0);
            this.killLine();
            this.putString(cursorBuffer.buffer);
            this.setCursorPosition(0);
            return -1;
        }
        this.setCursorPosition(0);
        this.killLine();
        this.putString(this.history.get(n5));
        this.setCursorPosition(0);
        this.flush();
        bl2 = false;
        while (!bl2 && (n4 = this.readCharacter()) != -1) {
            n = n3;
            switch (n4) {
                case 80: 
                case 112: {
                    n = n3 == 0 ? 1 : 0;
                }
                case 78: 
                case 110: {
                    int n8;
                    boolean bl3 = false;
                    if (n != 0) {
                        for (n8 = n5 + 1; !bl3 && n8 < n6; ++n8) {
                            if (!this.history.get(n8).toString().contains(string)) continue;
                            n5 = n8;
                            bl3 = true;
                        }
                    } else {
                        for (n8 = n5 - 1; !bl3 && n8 >= n2; --n8) {
                            if (!this.history.get(n8).toString().contains(string)) continue;
                            n5 = n8;
                            bl3 = true;
                        }
                    }
                    if (!bl3) break;
                    this.setCursorPosition(0);
                    this.killLine();
                    this.putString(this.history.get(n5));
                    this.setCursorPosition(0);
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            this.flush();
        }
        return n4;
    }

    public void setParenBlinkTimeout(int n) {
        this.parenBlinkTimeout = n;
    }

    private void insertClose(String string) throws IOException {
        this.putString(string);
        int n = this.buf.cursor;
        this.moveCursor(-1);
        this.viMatch();
        if (this.in.isNonBlockingEnabled()) {
            this.in.peek(this.parenBlinkTimeout);
        }
        this.setCursorPosition(n);
        this.flush();
    }

    private boolean viMatch() throws IOException {
        int n = this.buf.cursor;
        if (n == this.buf.length()) {
            return false;
        }
        int n2 = ConsoleReader.getBracketType(this.buf.buffer.charAt(n));
        int n3 = n2 < 0 ? -1 : 1;
        int n4 = 1;
        if (n2 == 0) {
            return false;
        }
        while (n4 > 0) {
            if ((n += n3) < 0 || n >= this.buf.buffer.length()) {
                return false;
            }
            int n5 = ConsoleReader.getBracketType(this.buf.buffer.charAt(n));
            if (n5 == n2) {
                ++n4;
                continue;
            }
            if (n5 != -n2) continue;
            --n4;
        }
        if (n3 > 0 && this.isInViMoveOperationState()) {
            ++n;
        }
        this.setCursorPosition(n);
        this.flush();
        return true;
    }

    private static int getBracketType(char c) {
        switch (c) {
            case '[': {
                return 1;
            }
            case ']': {
                return -1;
            }
            case '{': {
                return 2;
            }
            case '}': {
                return -2;
            }
            case '(': {
                return 3;
            }
            case ')': {
                return -3;
            }
        }
        return 0;
    }

    private boolean deletePreviousWord() throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (ConsoleReader.isDelimiter(c = this.buf.current()) && c != '\u0000') {
            stringBuilder.append(c);
            this.backspace();
        }
        while (!ConsoleReader.isDelimiter(c = this.buf.current()) && c != '\u0000') {
            stringBuilder.append(c);
            this.backspace();
        }
        String string = stringBuilder.reverse().toString();
        this.killRing.addBackwards(string);
        return true;
    }

    private boolean deleteNextWord() throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (ConsoleReader.isDelimiter(c = this.buf.nextChar()) && c != '\u0000') {
            stringBuilder.append(c);
            this.delete();
        }
        while (!ConsoleReader.isDelimiter(c = this.buf.nextChar()) && c != '\u0000') {
            stringBuilder.append(c);
            this.delete();
        }
        String string = stringBuilder.toString();
        this.killRing.add(string);
        return true;
    }

    private boolean capitalizeWord() throws IOException {
        char c;
        boolean bl = true;
        int n = 1;
        while (this.buf.cursor + n - 1 < this.buf.length() && !ConsoleReader.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + n - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + n - 1, bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
            bl = false;
            ++n;
        }
        this.drawBuffer();
        this.moveCursor(n - 1);
        return true;
    }

    private boolean upCaseWord() throws IOException {
        char c;
        int n = 1;
        while (this.buf.cursor + n - 1 < this.buf.length() && !ConsoleReader.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + n - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + n - 1, Character.toUpperCase(c));
            ++n;
        }
        this.drawBuffer();
        this.moveCursor(n - 1);
        return true;
    }

    private boolean downCaseWord() throws IOException {
        char c;
        int n = 1;
        while (this.buf.cursor + n - 1 < this.buf.length() && !ConsoleReader.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + n - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + n - 1, Character.toLowerCase(c));
            ++n;
        }
        this.drawBuffer();
        this.moveCursor(n - 1);
        return true;
    }

    private boolean transposeChars(int n) throws IOException {
        while (n > 0) {
            if (this.buf.cursor == 0 || this.buf.cursor == this.buf.buffer.length()) {
                return false;
            }
            int n2 = this.buf.cursor - 1;
            int n3 = this.buf.cursor;
            char c = this.buf.buffer.charAt(n2);
            this.buf.buffer.setCharAt(n2, this.buf.buffer.charAt(n3));
            this.buf.buffer.setCharAt(n3, c);
            this.moveInternal(-1);
            this.drawBuffer();
            this.moveInternal(2);
            --n;
        }
        return true;
    }

    public boolean isKeyMap(String string) {
        KeyMap keyMap = this.consoleKeys.getKeys();
        KeyMap keyMap2 = this.consoleKeys.getKeyMaps().get(string);
        if (keyMap2 == null) {
            return false;
        }
        return keyMap == keyMap2;
    }

    public String accept() throws IOException {
        this.moveToEnd();
        this.println();
        this.flush();
        return this.finishBuffer();
    }

    private void abort() throws IOException {
        this.beep();
        this.buf.clear();
        this.println();
        this.redrawLine();
    }

    public int moveCursor(int n) throws IOException {
        int n2 = n;
        if (this.buf.cursor == 0 && n2 <= 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && n2 >= 0) {
            return 0;
        }
        if (this.buf.cursor + n2 < 0) {
            n2 = -this.buf.cursor;
        } else if (this.buf.cursor + n2 > this.buf.buffer.length()) {
            n2 = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(n2);
        return n2;
    }

    private void moveInternal(int n) throws IOException {
        int n2;
        int n3;
        this.buf.cursor += n;
        if (this.mask == null) {
            if (n < 0) {
                n3 = this.promptLen + this.wcwidth(this.buf.buffer, 0, this.buf.cursor, this.promptLen);
                n2 = n3 + this.wcwidth(this.buf.buffer, this.buf.cursor, this.buf.cursor - n, n3);
            } else {
                n2 = this.promptLen + this.wcwidth(this.buf.buffer, 0, this.buf.cursor - n, this.promptLen);
                n3 = n2 + this.wcwidth(this.buf.buffer, this.buf.cursor - n, this.buf.cursor, n2);
            }
        } else if (this.mask.charValue() != '\u0000') {
            n3 = this.promptLen + this.buf.cursor;
            n2 = n3 - n;
        } else {
            return;
        }
        this.moveCursorFromTo(n2, n3);
    }

    private void moveCursorFromTo(int n, int n2) throws IOException {
        int n3;
        if (n == n2) {
            return;
        }
        int n4 = this.getTerminal().getWidth();
        int n5 = n / n4;
        int n6 = n % n4;
        int n7 = n2 / n4;
        int n8 = n2 % n4;
        if (n5 == n7 + 1) {
            if (!this.tputs("cursor_up", new Object[0])) {
                this.tputs("parm_up_cursor", 1);
            }
        } else if (n5 > n7) {
            if (!this.tputs("parm_up_cursor", n5 - n7)) {
                for (n3 = n7; n3 < n5; ++n3) {
                    this.tputs("cursor_up", new Object[0]);
                }
            }
        } else if (n5 < n7) {
            this.tputs("carriage_return", new Object[0]);
            this.rawPrint('\n', n7 - n5);
            n6 = 0;
        }
        if (n6 == n8 - 1) {
            this.tputs("cursor_right", new Object[0]);
        } else if (n6 == n8 + 1) {
            this.tputs("cursor_left", new Object[0]);
        } else if (n6 < n8) {
            if (!this.tputs("parm_right_cursor", n8 - n6)) {
                for (n3 = n6; n3 < n8; ++n3) {
                    this.tputs("cursor_right", new Object[0]);
                }
            }
        } else if (n6 > n8 && !this.tputs("parm_left_cursor", n6 - n8)) {
            for (n3 = n8; n3 < n6; ++n3) {
                this.tputs("cursor_left", new Object[0]);
            }
        }
        this.cursorOk = true;
    }

    public int readCharacter() throws IOException {
        return this.readCharacter(false);
    }

    public int readCharacter(boolean bl) throws IOException {
        int n = this.reader.read();
        if (n >= 0) {
            Log.trace("Keystroke: ", n);
            if (this.terminal.isSupported()) {
                this.clearEcho(n);
            }
            if (n == 27 && bl && this.in.peek(this.escapeTimeout) >= 32) {
                int n2 = this.reader.read();
                return n2 += 1000;
            }
        }
        return n;
    }

    private int clearEcho(int n) throws IOException {
        if (!this.terminal.isEchoEnabled()) {
            return 0;
        }
        int n2 = this.getCursorPosition();
        int n3 = this.wcwidth(n, n2);
        this.moveCursorFromTo(n2 + n3, n2);
        this.drawBuffer(n3);
        return n3;
    }

    public int readCharacter(char ... cArray) throws IOException {
        return this.readCharacter(false, cArray);
    }

    public int readCharacter(boolean bl, char ... cArray) throws IOException {
        char c;
        Arrays.sort(cArray);
        while (Arrays.binarySearch(cArray, c = (char)this.readCharacter(bl)) < 0) {
        }
        return c;
    }

    public Object readBinding(KeyMap keyMap) throws IOException {
        Object object;
        this.opBuffer.setLength(0);
        do {
            int n;
            int n2 = n = this.pushBackChar.isEmpty() ? this.readCharacter() : (int)this.pushBackChar.pop().charValue();
            if (n == -1) {
                return null;
            }
            this.opBuffer.appendCodePoint(n);
            if (this.recording) {
                this.macro = this.macro + new String(Character.toChars(n));
            }
            if (this.quotedInsert) {
                object = Operation.SELF_INSERT;
                this.quotedInsert = false;
            } else {
                object = keyMap.getBound(this.opBuffer);
            }
            if (!this.recording && !(object instanceof KeyMap)) {
                if (object != Operation.YANK_POP && object != Operation.YANK) {
                    this.killRing.resetLastYank();
                }
                if (object != Operation.KILL_LINE && object != Operation.KILL_WHOLE_LINE && object != Operation.BACKWARD_KILL_WORD && object != Operation.KILL_WORD && object != Operation.UNIX_LINE_DISCARD && object != Operation.UNIX_WORD_RUBOUT) {
                    this.killRing.resetLastKill();
                }
            }
            if (object == Operation.DO_LOWERCASE_VERSION) {
                this.opBuffer.setLength(this.opBuffer.length() - 1);
                this.opBuffer.append(Character.toLowerCase((char)n));
                object = keyMap.getBound(this.opBuffer);
            }
            if (object instanceof KeyMap) {
                if (n != 27 || !this.pushBackChar.isEmpty() || !this.in.isNonBlockingEnabled() || this.in.peek(this.escapeTimeout) != -2 || (object = ((KeyMap)object).getAnotherKey()) == null || object instanceof KeyMap) continue;
                this.opBuffer.setLength(0);
            }
            while (object == null && this.opBuffer.length() > 0) {
                n = this.opBuffer.charAt(this.opBuffer.length() - 1);
                this.opBuffer.setLength(this.opBuffer.length() - 1);
                Object object2 = keyMap.getBound(this.opBuffer);
                if (!(object2 instanceof KeyMap) || (object = ((KeyMap)object2).getAnotherKey()) == null) continue;
                this.pushBackChar.push(Character.valueOf((char)n));
            }
        } while (object == null || object instanceof KeyMap);
        return object;
    }

    public String getLastBinding() {
        return this.opBuffer.toString();
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character c) throws IOException {
        return this.readLine(null, c);
    }

    public String readLine(String string) throws IOException {
        return this.readLine(string, null);
    }

    public String readLine(String string, Character c) throws IOException {
        return this.readLine(string, c, null);
    }

    public boolean setKeyMap(String string) {
        return this.consoleKeys.setKeyMap(string);
    }

    public String getKeyMap() {
        return this.consoleKeys.getKeys().getName();
    }

    public String readLine(String string, Character c, String string2) throws IOException {
        int n = 0;
        Character c2 = this.mask = c != null ? c : this.echoCharacter;
        if (string != null) {
            this.setPrompt(string);
        } else {
            string = this.getPrompt();
        }
        try {
            if (string2 != null) {
                this.buf.write(string2);
            }
            if (!this.terminal.isSupported()) {
                this.beforeReadLine(string, c);
            }
            if (string2 != null && string2.length() > 0 || string != null && string.length() > 0) {
                this.drawLine();
                this.out.flush();
            }
            if (!this.terminal.isSupported()) {
                String string3 = this.readLineSimple();
                return string3;
            }
            if (this.handleUserInterrupt) {
                this.terminal.disableInterruptCharacter();
            }
            if (this.handleLitteralNext && this.terminal instanceof UnixTerminal) {
                ((UnixTerminal)this.terminal).disableLitteralNextCharacter();
            }
            String string4 = this.prompt;
            this.state = State.NORMAL;
            boolean bl = true;
            this.pushBackChar.clear();
            while (true) {
                int n2;
                Object object;
                Object object2;
                if ((object2 = this.readBinding(this.getKeys())) == null) {
                    String string5 = null;
                    return string5;
                }
                int n3 = 0;
                if (this.opBuffer.length() > 0) {
                    n3 = this.opBuffer.codePointBefore(this.opBuffer.length());
                }
                Log.trace("Binding: ", object2);
                if (object2 instanceof String) {
                    object = (String)object2;
                    for (n2 = 0; n2 < ((String)object).length(); ++n2) {
                        this.pushBackChar.push(Character.valueOf(((String)object).charAt(((String)object).length() - 1 - n2)));
                    }
                    this.opBuffer.setLength(0);
                    continue;
                }
                if (object2 instanceof ActionListener) {
                    ((ActionListener)object2).actionPerformed(null);
                    this.opBuffer.setLength(0);
                    continue;
                }
                object = new CursorBuffer();
                ((CursorBuffer)object).buffer.append((CharSequence)this.buf.buffer);
                ((CursorBuffer)object).cursor = this.buf.cursor;
                if (this.state == State.SEARCH || this.state == State.FORWARD_SEARCH) {
                    n2 = -1;
                    switch ((Operation)((Object)object2)) {
                        case ABORT: {
                            this.state = State.NORMAL;
                            this.buf.clear();
                            this.buf.write(this.originalBuffer.buffer);
                            this.buf.cursor = this.originalBuffer.cursor;
                            break;
                        }
                        case REVERSE_SEARCH_HISTORY: {
                            this.state = State.SEARCH;
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex <= 0) break;
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case FORWARD_SEARCH_HISTORY: {
                            this.state = State.FORWARD_SEARCH;
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex <= -1 || this.searchIndex >= this.history.size() - 1) break;
                            this.searchIndex = this.searchForwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case BACKWARD_DELETE_CHAR: {
                            if (this.searchTerm.length() <= 0) break;
                            this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                            if (this.state == State.SEARCH) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchForwards(this.searchTerm.toString());
                            break;
                        }
                        case SELF_INSERT: {
                            this.searchTerm.appendCodePoint(n3);
                            if (this.state == State.SEARCH) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchForwards(this.searchTerm.toString());
                            break;
                        }
                        default: {
                            if (this.searchIndex != -1) {
                                this.history.moveTo(this.searchIndex);
                                n2 = this.history.current().toString().indexOf(this.searchTerm.toString());
                            }
                            if (object2 != Operation.ACCEPT_LINE) {
                                object2 = null;
                            }
                            this.state = State.NORMAL;
                        }
                    }
                    if (this.state == State.SEARCH || this.state == State.FORWARD_SEARCH) {
                        if (this.searchTerm.length() == 0) {
                            if (this.state == State.SEARCH) {
                                this.printSearchStatus("", "");
                            } else {
                                this.printForwardSearchStatus("", "");
                            }
                            this.searchIndex = -1;
                        } else if (this.searchIndex == -1) {
                            this.beep();
                            this.printSearchStatus(this.searchTerm.toString(), "");
                        } else if (this.state == State.SEARCH) {
                            this.printSearchStatus(this.searchTerm.toString(), this.history.get(this.searchIndex).toString());
                        } else {
                            this.printForwardSearchStatus(this.searchTerm.toString(), this.history.get(this.searchIndex).toString());
                        }
                    } else {
                        this.restoreLine(string4, n2);
                    }
                }
                if (this.state != State.SEARCH && this.state != State.FORWARD_SEARCH) {
                    n2 = 0;
                    int n4 = n == 0 ? 1 : n;
                    bl = true;
                    if (object2 instanceof Operation) {
                        Operation operation = (Operation)((Object)object2);
                        int n5 = this.buf.cursor;
                        State state = this.state;
                        if (this.state == State.VI_CHANGE_TO || this.state == State.VI_YANK_TO || this.state == State.VI_DELETE_TO) {
                            operation = this.viDeleteChangeYankToRemap(operation);
                        }
                        switch (operation) {
                            case COMPLETE: {
                                boolean bl2 = false;
                                if (this.copyPasteDetection && n3 == 9 && (!this.pushBackChar.isEmpty() || this.in.isNonBlockingEnabled() && this.in.peek(this.escapeTimeout) != -2)) {
                                    bl2 = true;
                                }
                                if (!bl2) {
                                    bl = this.complete();
                                    break;
                                }
                                this.putString(this.opBuffer);
                                break;
                            }
                            case POSSIBLE_COMPLETIONS: {
                                this.printCompletionCandidates();
                                break;
                            }
                            case BEGINNING_OF_LINE: {
                                bl = this.setCursorPosition(0);
                                break;
                            }
                            case YANK: {
                                bl = this.yank();
                                break;
                            }
                            case YANK_POP: {
                                bl = this.yankPop();
                                break;
                            }
                            case KILL_LINE: {
                                bl = this.killLine();
                                break;
                            }
                            case KILL_WHOLE_LINE: {
                                bl = this.setCursorPosition(0) && this.killLine();
                                break;
                            }
                            case CLEAR_SCREEN: {
                                bl = this.clearScreen();
                                this.redrawLine();
                                break;
                            }
                            case OVERWRITE_MODE: {
                                this.buf.setOverTyping(!this.buf.isOverTyping());
                                break;
                            }
                            case SELF_INSERT: {
                                this.putString(this.opBuffer);
                                break;
                            }
                            case ACCEPT_LINE: {
                                String string6 = this.accept();
                                return string6;
                            }
                            case ABORT: {
                                if (this.searchTerm != null) break;
                                this.abort();
                                break;
                            }
                            case INTERRUPT: {
                                if (!this.handleUserInterrupt) break;
                                this.println();
                                this.flush();
                                String string7 = this.buf.buffer.toString();
                                this.buf.clear();
                                this.history.moveToEnd();
                                throw new UserInterruptException(string7);
                            }
                            case VI_MOVE_ACCEPT_LINE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                String string8 = this.accept();
                                return string8;
                            }
                            case BACKWARD_WORD: {
                                bl = this.previousWord();
                                break;
                            }
                            case FORWARD_WORD: {
                                bl = this.nextWord();
                                break;
                            }
                            case PREVIOUS_HISTORY: {
                                bl = this.moveHistory(false);
                                break;
                            }
                            case VI_PREVIOUS_HISTORY: {
                                bl = this.moveHistory(false, n4) && this.setCursorPosition(0);
                                break;
                            }
                            case NEXT_HISTORY: {
                                bl = this.moveHistory(true);
                                break;
                            }
                            case VI_NEXT_HISTORY: {
                                bl = this.moveHistory(true, n4) && this.setCursorPosition(0);
                                break;
                            }
                            case BACKWARD_DELETE_CHAR: {
                                bl = this.backspace();
                                break;
                            }
                            case EXIT_OR_DELETE_CHAR: {
                                if (this.buf.buffer.length() == 0) {
                                    String string9 = null;
                                    return string9;
                                }
                                bl = this.deleteCurrentCharacter();
                                break;
                            }
                            case DELETE_CHAR: {
                                bl = this.deleteCurrentCharacter();
                                break;
                            }
                            case BACKWARD_CHAR: {
                                bl = this.moveCursor(-n4) != 0;
                                break;
                            }
                            case FORWARD_CHAR: {
                                bl = this.moveCursor(n4) != 0;
                                break;
                            }
                            case UNIX_LINE_DISCARD: {
                                bl = this.resetLine();
                                break;
                            }
                            case UNIX_WORD_RUBOUT: {
                                bl = this.unixWordRubout(n4);
                                break;
                            }
                            case BACKWARD_KILL_WORD: {
                                bl = this.deletePreviousWord();
                                break;
                            }
                            case KILL_WORD: {
                                bl = this.deleteNextWord();
                                break;
                            }
                            case BEGINNING_OF_HISTORY: {
                                bl = this.history.moveToFirst();
                                if (!bl) break;
                                this.setBuffer(this.history.current());
                                break;
                            }
                            case END_OF_HISTORY: {
                                bl = this.history.moveToLast();
                                if (!bl) break;
                                this.setBuffer(this.history.current());
                                break;
                            }
                            case HISTORY_SEARCH_BACKWARD: {
                                this.searchTerm = new StringBuffer(this.buf.upToCursor());
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.history.index(), true);
                                if (this.searchIndex == -1) {
                                    this.beep();
                                    break;
                                }
                                bl = this.history.moveTo(this.searchIndex);
                                if (!bl) break;
                                this.setBufferKeepPos(this.history.current());
                                break;
                            }
                            case HISTORY_SEARCH_FORWARD: {
                                this.searchTerm = new StringBuffer(this.buf.upToCursor());
                                int n6 = this.history.index() + 1;
                                if (n6 == this.history.size()) {
                                    this.history.moveToEnd();
                                    this.setBufferKeepPos(this.searchTerm.toString());
                                    break;
                                }
                                if (n6 >= this.history.size()) break;
                                this.searchIndex = this.searchForwards(this.searchTerm.toString(), n6, true);
                                if (this.searchIndex == -1) {
                                    this.beep();
                                    break;
                                }
                                bl = this.history.moveTo(this.searchIndex);
                                if (!bl) break;
                                this.setBufferKeepPos(this.history.current());
                                break;
                            }
                            case REVERSE_SEARCH_HISTORY: {
                                this.originalBuffer = new CursorBuffer();
                                this.originalBuffer.write(this.buf.buffer);
                                this.originalBuffer.cursor = this.buf.cursor;
                                if (this.searchTerm != null) {
                                    this.previousSearchTerm = this.searchTerm.toString();
                                }
                                this.searchTerm = new StringBuffer(this.buf.buffer);
                                this.state = State.SEARCH;
                                if (this.searchTerm.length() > 0) {
                                    this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                    if (this.searchIndex == -1) {
                                        this.beep();
                                    }
                                    this.printSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? this.history.get(this.searchIndex).toString() : "");
                                    break;
                                }
                                this.searchIndex = -1;
                                this.printSearchStatus("", "");
                                break;
                            }
                            case FORWARD_SEARCH_HISTORY: {
                                this.originalBuffer = new CursorBuffer();
                                this.originalBuffer.write(this.buf.buffer);
                                this.originalBuffer.cursor = this.buf.cursor;
                                if (this.searchTerm != null) {
                                    this.previousSearchTerm = this.searchTerm.toString();
                                }
                                this.searchTerm = new StringBuffer(this.buf.buffer);
                                this.state = State.FORWARD_SEARCH;
                                if (this.searchTerm.length() > 0) {
                                    this.searchIndex = this.searchForwards(this.searchTerm.toString());
                                    if (this.searchIndex == -1) {
                                        this.beep();
                                    }
                                    this.printForwardSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? this.history.get(this.searchIndex).toString() : "");
                                    break;
                                }
                                this.searchIndex = -1;
                                this.printForwardSearchStatus("", "");
                                break;
                            }
                            case CAPITALIZE_WORD: {
                                bl = this.capitalizeWord();
                                break;
                            }
                            case UPCASE_WORD: {
                                bl = this.upCaseWord();
                                break;
                            }
                            case DOWNCASE_WORD: {
                                bl = this.downCaseWord();
                                break;
                            }
                            case END_OF_LINE: {
                                bl = this.moveToEnd();
                                break;
                            }
                            case TAB_INSERT: {
                                this.putString("\t");
                                break;
                            }
                            case RE_READ_INIT_FILE: {
                                this.consoleKeys.loadKeys(this.appName, this.inputrcUrl);
                                break;
                            }
                            case START_KBD_MACRO: {
                                this.recording = true;
                                break;
                            }
                            case END_KBD_MACRO: {
                                this.recording = false;
                                this.macro = this.macro.substring(0, this.macro.length() - this.opBuffer.length());
                                break;
                            }
                            case CALL_LAST_KBD_MACRO: {
                                int n7;
                                for (n7 = 0; n7 < this.macro.length(); ++n7) {
                                    this.pushBackChar.push(Character.valueOf(this.macro.charAt(this.macro.length() - 1 - n7)));
                                }
                                this.opBuffer.setLength(0);
                                break;
                            }
                            case VI_EDITING_MODE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_MOVEMENT_MODE: {
                                if (this.state == State.NORMAL) {
                                    this.moveCursor(-1);
                                }
                                this.consoleKeys.setKeyMap("vi-move");
                                break;
                            }
                            case VI_INSERTION_MODE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_APPEND_MODE: {
                                this.moveCursor(1);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_APPEND_EOL: {
                                bl = this.moveToEnd();
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_EOF_MAYBE: {
                                if (this.buf.buffer.length() == 0) {
                                    String string10 = null;
                                    return string10;
                                }
                                String string11 = this.accept();
                                return string11;
                            }
                            case TRANSPOSE_CHARS: {
                                bl = this.transposeChars(n4);
                                break;
                            }
                            case INSERT_COMMENT: {
                                String string12 = this.insertComment(false);
                                return string12;
                            }
                            case INSERT_CLOSE_CURLY: {
                                this.insertClose("}");
                                break;
                            }
                            case INSERT_CLOSE_PAREN: {
                                this.insertClose(")");
                                break;
                            }
                            case INSERT_CLOSE_SQUARE: {
                                this.insertClose("]");
                                break;
                            }
                            case VI_INSERT_COMMENT: {
                                String string13 = this.insertComment(true);
                                return string13;
                            }
                            case VI_MATCH: {
                                bl = this.viMatch();
                                break;
                            }
                            case VI_SEARCH: {
                                int n7 = this.viSearch(this.opBuffer.charAt(0));
                                if (n7 == -1) break;
                                this.pushBackChar.push(Character.valueOf((char)n7));
                                break;
                            }
                            case VI_ARG_DIGIT: {
                                n = n * 10 + this.opBuffer.charAt(0) - 48;
                                n2 = 1;
                                break;
                            }
                            case VI_BEGINNING_OF_LINE_OR_ARG_DIGIT: {
                                if (n > 0) {
                                    n = n * 10 + this.opBuffer.charAt(0) - 48;
                                    n2 = 1;
                                    break;
                                }
                                bl = this.setCursorPosition(0);
                                break;
                            }
                            case VI_FIRST_PRINT: {
                                bl = this.setCursorPosition(0) && this.viNextWord(1);
                                break;
                            }
                            case VI_PREV_WORD: {
                                bl = this.viPreviousWord(n4);
                                break;
                            }
                            case VI_NEXT_WORD: {
                                bl = this.viNextWord(n4);
                                break;
                            }
                            case VI_END_WORD: {
                                bl = this.viEndWord(n4);
                                break;
                            }
                            case VI_INSERT_BEG: {
                                bl = this.setCursorPosition(0);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_RUBOUT: {
                                bl = this.viRubout(n4);
                                break;
                            }
                            case VI_DELETE: {
                                bl = this.viDelete(n4);
                                break;
                            }
                            case VI_DELETE_TO: {
                                if (this.state == State.VI_DELETE_TO) {
                                    bl = this.setCursorPosition(0) && this.killLine();
                                    this.state = state = State.NORMAL;
                                    break;
                                }
                                this.state = State.VI_DELETE_TO;
                                break;
                            }
                            case VI_YANK_TO: {
                                if (this.state == State.VI_YANK_TO) {
                                    this.yankBuffer = this.buf.buffer.toString();
                                    this.state = state = State.NORMAL;
                                    break;
                                }
                                this.state = State.VI_YANK_TO;
                                break;
                            }
                            case VI_CHANGE_TO: {
                                if (this.state == State.VI_CHANGE_TO) {
                                    bl = this.setCursorPosition(0) && this.killLine();
                                    this.state = state = State.NORMAL;
                                    this.consoleKeys.setKeyMap("vi-insert");
                                    break;
                                }
                                this.state = State.VI_CHANGE_TO;
                                break;
                            }
                            case VI_KILL_WHOLE_LINE: {
                                bl = this.setCursorPosition(0) && this.killLine();
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_PUT: {
                                bl = this.viPut(n4);
                                break;
                            }
                            case VI_CHAR_SEARCH: {
                                int n8 = n3 != 59 && n3 != 44 ? (this.pushBackChar.isEmpty() ? this.readCharacter() : (int)this.pushBackChar.pop().charValue()) : 0;
                                bl = this.viCharSearch(n4, n3, n8);
                                break;
                            }
                            case VI_CHANGE_CASE: {
                                bl = this.viChangeCase(n4);
                                break;
                            }
                            case VI_CHANGE_CHAR: {
                                bl = this.viChangeChar(n4, this.pushBackChar.isEmpty() ? this.readCharacter() : (int)this.pushBackChar.pop().charValue());
                                break;
                            }
                            case VI_DELETE_TO_EOL: {
                                bl = this.viDeleteTo(this.buf.cursor, this.buf.buffer.length(), false);
                                break;
                            }
                            case VI_CHANGE_TO_EOL: {
                                bl = this.viDeleteTo(this.buf.cursor, this.buf.buffer.length(), true);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case EMACS_EDITING_MODE: {
                                this.consoleKeys.setKeyMap("emacs");
                                break;
                            }
                            case QUIT: {
                                this.getCursorBuffer().clear();
                                String string14 = this.accept();
                                return string14;
                            }
                            case QUOTED_INSERT: {
                                this.quotedInsert = true;
                                break;
                            }
                            case PASTE_FROM_CLIPBOARD: {
                                this.paste();
                                break;
                            }
                        }
                        if (state != State.NORMAL) {
                            if (state == State.VI_DELETE_TO) {
                                bl = this.viDeleteTo(n5, this.buf.cursor, false);
                            } else if (state == State.VI_CHANGE_TO) {
                                bl = this.viDeleteTo(n5, this.buf.cursor, true);
                                this.consoleKeys.setKeyMap("vi-insert");
                            } else if (state == State.VI_YANK_TO) {
                                bl = this.viYankTo(n5, this.buf.cursor);
                            }
                            this.state = State.NORMAL;
                        }
                        if (this.state == State.NORMAL && n2 == 0) {
                            n = 0;
                        }
                        if (this.state != State.SEARCH && this.state != State.FORWARD_SEARCH) {
                            this.originalBuffer = null;
                            this.previousSearchTerm = "";
                            this.searchTerm = null;
                            this.searchIndex = -1;
                        }
                    }
                }
                if (!bl) {
                    this.beep();
                }
                this.opBuffer.setLength(0);
                this.flush();
            }
        }
        finally {
            if (!this.terminal.isSupported()) {
                this.afterReadLine();
            }
            if (this.handleUserInterrupt) {
                this.terminal.enableInterruptCharacter();
            }
        }
    }

    private String readLineSimple() throws IOException {
        int n;
        if (this.skipLF) {
            this.skipLF = false;
            n = this.readCharacter();
            if (n == -1 || n == 13) {
                return this.finishBuffer();
            }
            if (n != 10) {
                this.buf.buffer.append((char)n);
            }
        }
        while ((n = this.readCharacter()) != -1 || this.buf.buffer.length() != 0) {
            if (n == -1 || n == 10) {
                return this.finishBuffer();
            }
            if (n == 13) {
                this.skipLF = true;
                return this.finishBuffer();
            }
            this.buf.buffer.append((char)n);
        }
        return null;
    }

    public boolean addCompleter(Completer completer) {
        return this.completers.add(completer);
    }

    public boolean removeCompleter(Completer completer) {
        return this.completers.remove(completer);
    }

    public Collection<Completer> getCompleters() {
        return Collections.unmodifiableList(this.completers);
    }

    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.completionHandler = Preconditions.checkNotNull(completionHandler);
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    protected boolean complete() throws IOException {
        Completer completer;
        if (this.completers.size() == 0) {
            return false;
        }
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        String string = this.buf.buffer.toString();
        int n = this.buf.cursor;
        int n2 = -1;
        Iterator<Completer> iterator = this.completers.iterator();
        while (iterator.hasNext() && (n2 = (completer = iterator.next()).complete(string, n, linkedList)) == -1) {
        }
        return linkedList.size() != 0 && this.getCompletionHandler().complete(this, linkedList, n2);
    }

    protected void printCompletionCandidates() throws IOException {
        if (this.completers.size() == 0) {
            return;
        }
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        String string = this.buf.buffer.toString();
        int n = this.buf.cursor;
        for (Completer completer : this.completers) {
            if (completer.complete(string, n, linkedList) != -1) break;
        }
        CandidateListCompletionHandler.printCandidates(this, linkedList);
        this.drawLine();
    }

    public void setAutoprintThreshold(int n) {
        this.autoprintThreshold = n;
    }

    public int getAutoprintThreshold() {
        return this.autoprintThreshold;
    }

    public void setPaginationEnabled(boolean bl) {
        this.paginationEnabled = bl;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistoryEnabled(boolean bl) {
        this.historyEnabled = bl;
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private boolean moveHistory(boolean bl, int n) throws IOException {
        boolean bl2 = true;
        for (int i = 0; i < n && (bl2 = this.moveHistory(bl)); ++i) {
        }
        return bl2;
    }

    private boolean moveHistory(boolean bl) throws IOException {
        if (bl && !this.history.next()) {
            return false;
        }
        if (!bl && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    private int fmtPrint(CharSequence charSequence, int n) throws IOException {
        return this.fmtPrint(charSequence, 0, charSequence.length(), n);
    }

    private int fmtPrint(CharSequence charSequence, int n, int n2) throws IOException {
        return this.fmtPrint(charSequence, n, n2, this.getCursorPosition());
    }

    private int fmtPrint(CharSequence charSequence, int n, int n2, int n3) throws IOException {
        Preconditions.checkNotNull(charSequence);
        for (int i = n; i < n2; ++i) {
            int n4;
            char c = charSequence.charAt(i);
            if (c == '\t') {
                n4 = this.nextTabStop(n3);
                n3 += n4;
                while (n4-- > 0) {
                    this.out.write(32);
                }
                continue;
            }
            if (c < ' ') {
                this.out.write(94);
                this.out.write((char)(c + 64));
                n3 += 2;
                continue;
            }
            n4 = WCWidth.wcwidth(c);
            if (n4 <= 0) continue;
            this.out.write(c);
            n3 += n4;
        }
        this.cursorOk = false;
        return n3;
    }

    public void print(CharSequence charSequence) throws IOException {
        this.rawPrint(charSequence.toString());
    }

    public void println(CharSequence charSequence) throws IOException {
        this.print(charSequence);
        this.println();
    }

    public void println() throws IOException {
        this.rawPrint(LINE_SEPARATOR);
    }

    final void rawPrint(int n) throws IOException {
        this.out.write(n);
        this.cursorOk = false;
    }

    final void rawPrint(String string) throws IOException {
        this.out.write(string);
        this.cursorOk = false;
    }

    private void rawPrint(char c, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.rawPrint(c);
        }
    }

    private void rawPrintln(String string) throws IOException {
        this.rawPrint(string);
        this.println();
    }

    public boolean delete() throws IOException {
        if (this.buf.cursor == this.buf.buffer.length()) {
            return false;
        }
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return true;
    }

    public boolean killLine() throws IOException {
        int n = this.buf.cursor;
        int n2 = this.buf.buffer.length();
        if (n >= n2) {
            return false;
        }
        int n3 = n2 - n;
        int n4 = this.getCursorPosition();
        int n5 = this.wcwidth(this.buf.buffer, n, n2, n4);
        this.clearAhead(n5, n4);
        char[] cArray = new char[n3];
        this.buf.buffer.getChars(n, n + n3, cArray, 0);
        this.buf.buffer.delete(n, n + n3);
        String string = new String(cArray);
        this.killRing.add(string);
        return true;
    }

    public boolean yank() throws IOException {
        String string = this.killRing.yank();
        if (string == null) {
            return false;
        }
        this.putString(string);
        return true;
    }

    public boolean yankPop() throws IOException {
        if (!this.killRing.lastYank()) {
            return false;
        }
        String string = this.killRing.yank();
        if (string == null) {
            return false;
        }
        this.backspace(string.length());
        String string2 = this.killRing.yankPop();
        if (string2 == null) {
            return false;
        }
        this.putString(string2);
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.tputs("clear_screen", new Object[0])) {
            this.println();
        }
        return true;
    }

    public void beep() throws IOException {
        if (this.bellEnabled && this.tputs("bell", new Object[0])) {
            this.flush();
        }
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String string;
            Object object = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (object == null) {
                try {
                    object = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object == null) {
                return false;
            }
            if (object instanceof Reader) {
                String string2;
                string = "";
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string.length() > 0) {
                        string = string + "\n";
                    }
                    string = string + string2;
                }
            } else {
                string = object.toString();
            }
            if (string == null) {
                return true;
            }
            this.putString(string);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.error("Paste failed: ", unsupportedFlavorException);
            return false;
        }
    }

    public void addTriggeredAction(char c, ActionListener actionListener) {
        this.getKeys().bind(Character.toString(c), actionListener);
    }

    public void printColumns(Collection<? extends CharSequence> collection) throws IOException {
        int n;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int n2 = this.getTerminal().getWidth();
        int n3 = this.getTerminal().getHeight();
        int n4 = 0;
        for (CharSequence charSequence2 : collection) {
            n = this.wcwidth(Ansi.stripAnsi(charSequence2.toString()), 0);
            n4 = Math.max(n4, n);
        }
        Log.debug("Max width: ", n4 += 3);
        int n5 = this.isPaginationEnabled() ? n3 - 1 : Integer.MAX_VALUE;
        StringBuilder stringBuilder = new StringBuilder();
        n = 0;
        for (CharSequence charSequence : collection) {
            int n6;
            if (n + n4 > n2) {
                this.rawPrintln(stringBuilder.toString());
                stringBuilder.setLength(0);
                n = 0;
                if (--n5 == 0) {
                    this.print(resources.getString("DISPLAY_MORE"));
                    this.flush();
                    n6 = this.readCharacter();
                    if (n6 == 13 || n6 == 10) {
                        n5 = 1;
                    } else if (n6 != 113) {
                        n5 = n3 - 1;
                    }
                    this.tputs("carriage_return", new Object[0]);
                    if (n6 == 113) break;
                }
            }
            stringBuilder.append(charSequence.toString());
            n6 = this.wcwidth(Ansi.stripAnsi(charSequence.toString()), 0);
            for (int i = 0; i < n4 - n6; ++i) {
                stringBuilder.append(' ');
            }
            n += n4;
        }
        if (stringBuilder.length() > 0) {
            this.rawPrintln(stringBuilder.toString());
        }
    }

    private void beforeReadLine(String string, Character c) {
        if (c != null && this.maskThread == null) {
            final String string2 = "\r" + string + "                                                   \r" + string;
            this.maskThread = new Thread(){

                @Override
                public void run() {
                    while (!4.interrupted()) {
                        try {
                            Writer writer = ConsoleReader.this.getOutput();
                            writer.write(string2);
                            writer.flush();
                            4.sleep(3L);
                        }
                        catch (IOException iOException) {
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            };
            this.maskThread.setPriority(10);
            this.maskThread.setDaemon(true);
            this.maskThread.start();
        }
    }

    private void afterReadLine() {
        if (this.maskThread != null && this.maskThread.isAlive()) {
            this.maskThread.interrupt();
        }
        this.maskThread = null;
    }

    public void resetPromptLine(String string, String string2, int n) throws IOException {
        this.moveToEnd();
        this.buf.buffer.append(this.prompt);
        int n2 = 0;
        if (this.prompt != null) {
            n2 = this.prompt.length();
        }
        this.buf.cursor += n2;
        this.setPrompt("");
        this.backspaceAll();
        this.setPrompt(string);
        this.redrawLine();
        this.setBuffer(string2);
        if (n < 0) {
            n = string2.length();
        }
        this.setCursorPosition(n);
        this.flush();
    }

    public void printSearchStatus(String string, String string2) throws IOException {
        this.printSearchStatus(string, string2, "(reverse-i-search)`");
    }

    public void printForwardSearchStatus(String string, String string2) throws IOException {
        this.printSearchStatus(string, string2, "(i-search)`");
    }

    private void printSearchStatus(String string, String string2, String string3) throws IOException {
        String string4 = string3 + string + "': ";
        int n = string2.indexOf(string);
        this.resetPromptLine(string4, string2, n);
    }

    public void restoreLine(String string, int n) throws IOException {
        String string2 = ConsoleReader.lastLine(string);
        String string3 = this.buf.buffer.toString();
        this.resetPromptLine(string2, string3, n);
    }

    public int searchBackwards(String string, int n) {
        return this.searchBackwards(string, n, false);
    }

    public int searchBackwards(String string) {
        return this.searchBackwards(string, this.history.index());
    }

    public int searchBackwards(String string, int n, boolean bl) {
        ListIterator<History.Entry> listIterator = this.history.entries(n);
        while (listIterator.hasPrevious()) {
            History.Entry entry = listIterator.previous();
            if (!(bl ? entry.value().toString().startsWith(string) : entry.value().toString().contains(string))) continue;
            return entry.index();
        }
        return -1;
    }

    public int searchForwards(String string, int n) {
        return this.searchForwards(string, n, false);
    }

    public int searchForwards(String string) {
        return this.searchForwards(string, this.history.index());
    }

    public int searchForwards(String string, int n, boolean bl) {
        if (n >= this.history.size()) {
            n = this.history.size() - 1;
        }
        ListIterator<History.Entry> listIterator = this.history.entries(n);
        if (this.searchIndex != -1 && listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasNext()) {
            History.Entry entry = listIterator.next();
            if (!(bl ? entry.value().toString().startsWith(string) : entry.value().toString().contains(string))) continue;
            return entry.index();
        }
        return -1;
    }

    private static boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    private boolean tputs(String string, Object ... objectArray) throws IOException {
        String string2 = this.terminal.getStringCapability(string);
        if (string2 == null) {
            return false;
        }
        Curses.tputs(this.out, string2, objectArray);
        return true;
    }

    private static enum State {
        NORMAL,
        SEARCH,
        FORWARD_SEARCH,
        VI_YANK_TO,
        VI_DELETE_TO,
        VI_CHANGE_TO;

    }
}

