/*
 * Decompiled with CFR 0.152.
 */
package jline.console.history;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.console.history.PersistentHistory;
import jline.internal.Log;
import jline.internal.Preconditions;

public class FileHistory
extends MemoryHistory
implements PersistentHistory,
Flushable {
    private final File file;

    public FileHistory(File file) throws IOException {
        this(file, true);
    }

    public FileHistory(File file, boolean bl) throws IOException {
        this.file = Preconditions.checkNotNull(file).getAbsoluteFile();
        if (bl) {
            this.load();
        }
    }

    public void load() throws IOException {
        this.load(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void load(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (file.exists()) {
            Log.trace("Loading history from: ", file);
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                this.load(fileReader);
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        this.load(new InputStreamReader(inputStream));
    }

    public void load(Reader reader) throws IOException {
        String string;
        Preconditions.checkNotNull(reader);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            this.internalAdd(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object;
        Log.trace("Flushing history");
        if (!this.file.exists()) {
            object = this.file.getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                Log.warn("Failed to create directory: ", object);
            }
            if (!this.file.createNewFile()) {
                Log.warn("Failed to create file: ", this.file);
            }
        }
        object = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        try {
            for (History.Entry entry : this) {
                ((PrintStream)object).println(entry.value());
            }
        }
        finally {
            ((PrintStream)object).close();
        }
    }

    @Override
    public void purge() throws IOException {
        Log.trace("Purging history");
        this.clear();
        if (!this.file.delete()) {
            Log.warn("Failed to delete history file: ", this.file);
        }
    }
}

