/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.IOException;
import java.io.InputStream;
import jline.internal.Log;

public class NonBlockingInputStream
extends InputStream
implements Runnable {
    private InputStream in;
    private int ch = -2;
    private boolean threadIsReading = false;
    private boolean isShutdown = false;
    private IOException exception = null;
    private boolean nonBlockingEnabled;

    public NonBlockingInputStream(InputStream inputStream, boolean bl) {
        this.in = inputStream;
        this.nonBlockingEnabled = bl;
        if (bl) {
            Thread thread = new Thread(this);
            thread.setName("NonBlockingInputStreamThread");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public synchronized void shutdown() {
        if (!this.isShutdown && this.nonBlockingEnabled) {
            this.isShutdown = true;
            this.notify();
        }
    }

    public boolean isNonBlockingEnabled() {
        return this.nonBlockingEnabled && !this.isShutdown;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.shutdown();
    }

    @Override
    public int read() throws IOException {
        if (this.nonBlockingEnabled) {
            return this.read(0L, false);
        }
        return this.in.read();
    }

    public int peek(long l) throws IOException {
        if (!this.nonBlockingEnabled || this.isShutdown) {
            throw new UnsupportedOperationException("peek() cannot be called as non-blocking operation is disabled");
        }
        return this.read(l, true);
    }

    public int read(long l) throws IOException {
        if (!this.nonBlockingEnabled || this.isShutdown) {
            throw new UnsupportedOperationException("read() with timeout cannot be called as non-blocking operation is disabled");
        }
        return this.read(l, false);
    }

    private synchronized int read(long l, boolean bl) throws IOException {
        int n;
        if (this.exception != null) {
            assert (this.ch == -2);
            IOException iOException = this.exception;
            if (!bl) {
                this.exception = null;
            }
            throw iOException;
        }
        if (this.ch >= -1) {
            assert (this.exception == null);
        } else if ((l == 0L || this.isShutdown) && !this.threadIsReading) {
            this.ch = this.in.read();
        } else {
            if (!this.threadIsReading) {
                this.threadIsReading = true;
                this.notify();
            }
            int n2 = n = l <= 0L ? 1 : 0;
            while (n != 0 || l > 0L) {
                long l2 = System.currentTimeMillis();
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.exception != null) {
                    assert (this.ch == -2);
                    IOException iOException = this.exception;
                    if (!bl) {
                        this.exception = null;
                    }
                    throw iOException;
                }
                if (this.ch >= -1) {
                    assert (this.exception == null);
                    break;
                }
                if (n != 0) continue;
                l -= System.currentTimeMillis() - l2;
            }
        }
        n = this.ch;
        if (!bl) {
            this.ch = -2;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.nonBlockingEnabled ? this.read(0L) : this.in.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Log.debug("NonBlockingInputStream start");
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            NonBlockingInputStream nonBlockingInputStream = this;
            synchronized (nonBlockingInputStream) {
                bl = this.isShutdown;
                bl2 = this.threadIsReading;
                try {
                    if (!bl && !bl2) {
                        this.wait(0L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (bl || !bl2) continue;
            int n = -2;
            IOException iOException = null;
            try {
                n = this.in.read();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            NonBlockingInputStream nonBlockingInputStream2 = this;
            synchronized (nonBlockingInputStream2) {
                this.exception = iOException;
                this.ch = n;
                this.threadIsReading = false;
                this.notify();
            }
        }
        Log.debug("NonBlockingInputStream shutdown");
    }
}

