/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.internal.Configuration;
import jline.internal.Log;
import jline.internal.Preconditions;

public final class TerminalLineSettings {
    public static final String JLINE_STTY = "jline.stty";
    public static final String DEFAULT_STTY = "stty";
    public static final String JLINE_SH = "jline.sh";
    public static final String DEFAULT_SH = "sh";
    private static final String UNDEFINED;
    public static final String DEFAULT_TTY = "/dev/tty";
    private static final boolean SUPPORTS_REDIRECT;
    private static final Object REDIRECT_INHERIT;
    private static final Method REDIRECT_INPUT_METHOD;
    private static final Map<String, TerminalLineSettings> SETTINGS;
    private String sttyCommand;
    private String shCommand;
    private String ttyDevice;
    private String config;
    private String initialConfig;
    private long configLastFetched;
    private boolean useRedirect;

    @Deprecated
    public TerminalLineSettings() throws IOException, InterruptedException {
        this(DEFAULT_TTY);
    }

    @Deprecated
    public TerminalLineSettings(String string) throws IOException, InterruptedException {
        this(string, false);
    }

    private TerminalLineSettings(String string, boolean bl) throws IOException, InterruptedException {
        Preconditions.checkNotNull(string);
        this.sttyCommand = Configuration.getString(JLINE_STTY, DEFAULT_STTY);
        this.shCommand = Configuration.getString(JLINE_SH, DEFAULT_SH);
        this.ttyDevice = string;
        this.useRedirect = SUPPORTS_REDIRECT && DEFAULT_TTY.equals(string);
        this.initialConfig = this.get("-g").trim();
        this.config = this.get("-a");
        this.configLastFetched = System.currentTimeMillis();
        Log.debug("Config: ", this.config);
        if (this.config.length() == 0) {
            throw new IOException(MessageFormat.format("Unrecognized stty code: {0}", this.config));
        }
    }

    public static synchronized TerminalLineSettings getSettings(String string) throws IOException, InterruptedException {
        TerminalLineSettings terminalLineSettings = SETTINGS.get(string);
        if (terminalLineSettings == null) {
            terminalLineSettings = new TerminalLineSettings(string, false);
            SETTINGS.put(string, terminalLineSettings);
        }
        return terminalLineSettings;
    }

    public String getTtyDevice() {
        return this.ttyDevice;
    }

    public String getConfig() {
        return this.config;
    }

    public void restore() throws IOException, InterruptedException {
        this.set(this.initialConfig);
    }

    public String get(String string) throws IOException, InterruptedException {
        Preconditions.checkNotNull(string);
        return this.stty(string);
    }

    public void set(String string) throws IOException, InterruptedException {
        Preconditions.checkNotNull(string);
        this.stty(string.split(" "));
    }

    public void set(String ... stringArray) throws IOException, InterruptedException {
        Preconditions.checkNotNull(stringArray);
        this.stty(stringArray);
    }

    public void undef(String string) throws IOException, InterruptedException {
        Preconditions.checkNotNull(string);
        this.stty(string, UNDEFINED);
    }

    public int getProperty(String string) {
        Preconditions.checkNotNull(string);
        if (!this.fetchConfig(string)) {
            return -1;
        }
        return TerminalLineSettings.getProperty(string, this.config);
    }

    public String getPropertyAsString(String string) {
        Preconditions.checkNotNull(string);
        if (!this.fetchConfig(string)) {
            return null;
        }
        return TerminalLineSettings.getPropertyAsString(string, this.config);
    }

    private boolean fetchConfig(String string) {
        long l;
        block5: {
            l = System.currentTimeMillis();
            try {
                if (this.config == null || l - this.configLastFetched > 1000L) {
                    this.config = this.get("-a");
                }
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                Log.debug("Failed to query stty ", string, "\n", exception);
                if (this.config != null) break block5;
                return false;
            }
        }
        if (l - this.configLastFetched > 1000L) {
            this.configLastFetched = l;
        }
        return true;
    }

    protected static String getPropertyAsString(String string, String string2) {
        Pattern pattern = Pattern.compile(string + "\\s+=\\s+(.*?)[;\\n\\r]");
        Matcher matcher = pattern.matcher(string2);
        if (!(matcher.find() || (matcher = (pattern = Pattern.compile(string + "\\s+([^;]*)[;\\n\\r]")).matcher(string2)).find() || (matcher = (pattern = Pattern.compile("(\\S*)\\s+" + string)).matcher(string2)).find())) {
            return null;
        }
        return matcher.group(1);
    }

    protected static int getProperty(String string, String string2) {
        String string3 = TerminalLineSettings.getPropertyAsString(string, string2);
        return string3 != null ? TerminalLineSettings.parseControlChar(string3) : -1;
    }

    private static int parseControlChar(String string) {
        if ("<undef>".equals(string)) {
            return -1;
        }
        if (string.charAt(0) == '0') {
            return Integer.parseInt(string, 8);
        }
        if (string.charAt(0) >= '1' && string.charAt(0) <= '9') {
            return Integer.parseInt(string, 10);
        }
        if (string.charAt(0) == '^') {
            if (string.charAt(1) == '?') {
                return 127;
            }
            return string.charAt(1) - 64;
        }
        if (string.charAt(0) == 'M' && string.charAt(1) == '-') {
            if (string.charAt(2) == '^') {
                if (string.charAt(3) == '?') {
                    return 255;
                }
                return string.charAt(3) - 64 + 128;
            }
            return string.charAt(2) + 128;
        }
        return string.charAt(0);
    }

    private String stty(String ... stringArray) throws IOException, InterruptedException {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = this.sttyCommand;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return this.exec(stringArray2);
    }

    private String exec(String ... stringArray) throws IOException, InterruptedException {
        CharSequence charSequence;
        Preconditions.checkNotNull(stringArray);
        Log.trace("Running: ", stringArray);
        Process process = null;
        if (this.useRedirect) {
            try {
                process = TerminalLineSettings.inheritInput(new ProcessBuilder(stringArray)).start();
            }
            catch (Throwable throwable) {
                this.useRedirect = false;
            }
        }
        if (process == null) {
            charSequence = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)charSequence).append(' ');
                }
                ((StringBuilder)charSequence).append(stringArray[i]);
            }
            ((StringBuilder)charSequence).append(" < ");
            ((StringBuilder)charSequence).append(this.ttyDevice);
            process = new ProcessBuilder(this.shCommand, "-c", ((StringBuilder)charSequence).toString()).start();
        }
        charSequence = TerminalLineSettings.waitAndCapture(process);
        Log.trace("Result: ", charSequence);
        return charSequence;
    }

    private static ProcessBuilder inheritInput(ProcessBuilder processBuilder) throws Exception {
        REDIRECT_INPUT_METHOD.invoke((Object)processBuilder, REDIRECT_INHERIT);
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitAndCapture(Process process) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream2 = process.getErrorStream();
            while ((n = inputStream2.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            outputStream = process.getOutputStream();
            process.waitFor();
        }
        catch (Throwable throwable) {
            TerminalLineSettings.close(inputStream, outputStream, inputStream2);
            throw throwable;
        }
        TerminalLineSettings.close(inputStream, outputStream, inputStream2);
        return byteArrayOutputStream.toString();
    }

    private static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        boolean bl;
        SETTINGS = new HashMap<String, TerminalLineSettings>();
        UNDEFINED = Configuration.isHpux() ? "^-" : "undef";
        Object object = null;
        Method method = null;
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessBuilder$Redirect");
            object = clazz.getField("INHERIT").get(null);
            method = ProcessBuilder.class.getMethod("redirectInput", clazz);
            bl = System.class.getMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        SUPPORTS_REDIRECT = bl;
        REDIRECT_INHERIT = object;
        REDIRECT_INPUT_METHOD = method;
    }
}

