/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven.BasicArtifact;
import org_scala_tools_maven.ScalaSourceMojoSupport;
import org_scala_tools_maven_executions.JavaMainCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaGenJsonMojo
extends ScalaSourceMojoSupport {
    protected String logo;
    protected String license;
    protected String tags = "";
    private String description;
    protected String vscaladoc2Version;
    protected File sourceDir;
    protected String _mainClass = "net_alchim31_vscaladoc2_genjson.Main";
    protected boolean _prettyPrint = true;

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = this.sourceDir.getCanonicalPath())) {
            sources.add(scalaSourceDir);
        }
        return this.normalize(sources);
    }

    @Override
    protected void doExecute() throws Exception {
        if (StringUtils.isNotEmpty((String)this._mainClass)) {
            File cfg = this.makeJsonCfg();
            this.setDependenciesForJcmd();
            JavaMainCaller jcmd = this.getEmptyScalaCommand(this._mainClass);
            jcmd.addJvmArgs(this.jvmArgs);
            jcmd.addArgs(cfg.getCanonicalPath());
            jcmd.run(this.displayCmd);
        } else {
            this.getLog().warn((CharSequence)"Not mainClass or valid launcher found/define");
        }
    }

    private void setDependenciesForJcmd() {
        BasicArtifact artifact = new BasicArtifact();
        artifact.artifactId = "vscaladoc2_genjson";
        artifact.groupId = "net.alchim31.vscaladoc2";
        artifact.version = this.vscaladoc2Version;
        this.dependencies = new BasicArtifact[]{artifact};
    }

    private void toJson(Object pojo, boolean prettyPrint, File f) throws Exception {
        ObjectMapper m = new ObjectMapper();
        JsonFactory jf = new JsonFactory();
        JsonGenerator jg = jf.createJsonGenerator(f, JsonEncoding.UTF8);
        if (prettyPrint) {
            jg.useDefaultPrettyPrinter();
        }
        m.writeValue(jg, pojo);
    }

    private File makeJsonCfg() throws Exception {
        this.initFilters();
        File dir = new File(this.project.getBuild().getDirectory());
        dir.mkdirs();
        File f = new File(dir, "vscaladoc2_cfg.json");
        this.toJson(new Cfg(this), this._prettyPrint, f);
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Cfg {
        public String groupId = "";
        public String artifactId = "undef";
        public String version = "0.0.0";
        public String description = "";
        public String logo = "";
        public String license = "";
        public String kind = "";
        public String tags = "";
        public List<List<String>> dependencies = Collections.emptyList();
        public List<List<Object>> sources = Collections.emptyList();
        public List<String> artifacts = Collections.emptyList();
        public List<String> additionnalArgs = Collections.emptyList();

        protected Cfg(ScalaGenJsonMojo data) throws Exception {
            this.groupId = data.project.getGroupId();
            this.artifactId = data.project.getArtifactId();
            this.version = data.project.getVersion();
            this.logo = data.logo;
            this.license = data.license;
            this.description = data.description;
            this.tags = data.tags;
            if (StringUtils.isBlank((String)this.license) && !data.project.getLicenses().isEmpty()) {
                License lic = (License)data.project.getLicenses().get(0);
                this.license = String.format("<a href='%s'>%s</a>", lic.getUrl(), lic.getName());
            }
            this.dependencies = this.makeDependencies(data);
            this.sources = this.makeSources(data);
            this.artifacts = this.makeArtifacts(data);
            if (data.args != null && data.args.length > 0) {
                this.additionnalArgs = Arrays.asList((Object[])data.args);
            }
            this.kind = this.makeKind(data);
        }

        private String makeKind(ScalaGenJsonMojo data) {
            String back = null;
            String pkg = data.project.getPackaging();
            back = "pom".equals(pkg) ? "group" : pkg;
            return back;
        }

        protected List<List<String>> makeDependencies(ScalaGenJsonMojo data) throws Exception {
            ArrayList<List<String>> back = new ArrayList<List<String>>();
            List deps = data.project.getCompileArtifacts();
            for (Artifact dep : deps) {
                ArrayList<String> e = new ArrayList<String>(3);
                e.add(dep.getFile().getCanonicalPath());
                e.add(dep.getArtifactId() + "/" + dep.getVersion());
                back.add(e);
            }
            return back;
        }

        protected List<List<Object>> makeSources(ScalaGenJsonMojo data) throws Exception {
            ArrayList<List<Object>> back = new ArrayList<List<Object>>();
            List<File> dirs = data.getSourceDirectories();
            ArrayList includes = new ArrayList(data.includes);
            ArrayList excludes = new ArrayList(data.excludes);
            for (File dir : dirs) {
                ArrayList<Object> e = new ArrayList<Object>(3);
                e.add(dir.getCanonicalPath());
                e.add(excludes);
                e.add(includes);
                back.add(e);
            }
            return back;
        }

        protected List<String> makeArtifacts(ScalaGenJsonMojo data) throws Exception {
            ArrayList<String> back = new ArrayList<String>();
            List modules = data.project.getCollectedProjects();
            for (MavenProject module : modules) {
                back.add(module.getArtifactId() + "/" + module.getVersion());
            }
            return back;
        }
    }
}

