/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AddTakesScreenshot;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Augmenter {
    private final Map<String, AugmenterProvider> augmentors = new HashMap<String, AugmenterProvider>();

    public Augmenter() {
        this.addAugmentation("takesScreenshot", new AddTakesScreenshot());
    }

    public void addAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.augmentors.put(capabilityName, handlerClass);
    }

    public WebDriver augment(WebDriver driver) {
        if (!(driver instanceof RemoteWebDriver)) {
            return driver;
        }
        Map capabilities = ((RemoteWebDriver)driver).getCapabilities().asMap();
        CompoundHandler handler = new CompoundHandler((RemoteWebDriver)driver);
        for (Map.Entry capablityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = this.augmentors.get(capablityName.getKey());
            if (augmenter == null || (value = capablityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            handler.addCapabilityHander(augmenter.getDescribedInterface(), augmenter.getImplementation(value));
        }
        if (handler.isNeedingApplication()) {
            HashSet interfaces = new HashSet();
            interfaces.addAll(handler.getInterfaces());
            interfaces.addAll(this.getInterfacesFrom(driver.getClass()));
            return (WebDriver)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler);
        }
        return driver;
    }

    private Set<Class<?>> getInterfacesFrom(Class<?> clazz) {
        Class<?>[] interfaces;
        HashSet toReturn = new HashSet();
        if (clazz == null || Object.class.equals(clazz)) {
            return toReturn;
        }
        for (Class<?> face : interfaces = clazz.getInterfaces()) {
            toReturn.add(face);
            toReturn.addAll(this.getInterfacesFrom(face));
        }
        toReturn.addAll(this.getInterfacesFrom(clazz.getSuperclass()));
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompoundHandler
    implements InvocationHandler {
        private Map<Method, InterfaceImplementation> handlers = new HashMap<Method, InterfaceImplementation>();
        private Set<Class<?>> interfaces = new HashSet();
        private final RemoteWebDriver driver;

        private CompoundHandler(RemoteWebDriver driver) {
            this.driver = driver;
        }

        public void addCapabilityHander(Class<?> fromInterface, InterfaceImplementation handledBy) {
            this.interfaces.add(fromInterface);
            for (Method method : fromInterface.getDeclaredMethods()) {
                this.handlers.put(method, handledBy);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            try {
                if (handler == null) {
                    return method.invoke((Object)this.driver, args);
                }
                return handler.invoke(new ExecuteMethod(this.driver), method, args);
            }
            catch (InvocationTargetException e) {
                throw this.unwrapException(e);
            }
        }

        private Throwable unwrapException(Throwable e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                return e;
            }
            if (cause.getClass().getName().startsWith("java.lang.reflect")) {
                return this.unwrapException(cause);
            }
            return cause;
        }

        public Set<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public boolean isNeedingApplication() {
            return this.interfaces.size() > 0;
        }
    }
}

