/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ScreenshotException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandler {
    private static final String MESSAGE = "message";
    private static final String SCREEN_SHOT = "screen";
    private static final String CLASS = "class";
    private static final String STACK_TRACE = "stackTrace";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String METHOD_NAME = "methodName";
    private static final String CLASS_NAME = "className";
    private static final String FILE_NAME = "fileName";
    private static final String UNKNOWN_CLASS = "<anonymous class>";
    private static final String UNKNOWN_METHOD = "<anonymous method>";
    private static final String UNKNOWN_FILE = "<unknown file>";
    private final ErrorCodes errorCodes = new ErrorCodes();
    private boolean includeServerErrors;

    public ErrorHandler() {
        this(false);
    }

    public ErrorHandler(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public boolean isIncludeServerErrors() {
        return this.includeServerErrors;
    }

    public void setIncludeServerErrors(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public Response throwIfResponseFailed(Response response) throws RuntimeException {
        Constructor constructor;
        if (response.getStatus() == 0) {
            return response;
        }
        Class outerErrorType = this.errorCodes.getExceptionType(response.getStatus());
        Object value = response.getValue();
        String message = null;
        Object cause = null;
        if (!(value instanceof Map)) {
            message = value == null ? null : String.valueOf(value);
        } else {
            try {
                Map rawErrorData = (Map)response.getValue();
                message = (String)rawErrorData.get(MESSAGE);
                if (this.includeServerErrors) {
                    cause = this.rebuildServerError(rawErrorData);
                }
                if (rawErrorData.containsKey(SCREEN_SHOT)) {
                    cause = new ScreenshotException((String)rawErrorData.get(SCREEN_SHOT), (Throwable)cause);
                }
            }
            catch (ClassCastException e) {
                message = String.valueOf(value);
            }
        }
        Object toThrow = null;
        try {
            constructor = outerErrorType.getConstructor(String.class, Throwable.class);
            toThrow = (RuntimeException)constructor.newInstance(message, cause);
        }
        catch (Exception e) {
        }
        catch (OutOfMemoryError error) {
            // empty catch block
        }
        if (toThrow == null) {
            try {
                constructor = outerErrorType.getConstructor(String.class);
                toThrow = (RuntimeException)constructor.newInstance(message);
            }
            catch (Exception e) {
            }
            catch (OutOfMemoryError error) {
                // empty catch block
            }
        }
        throw toThrow != null ? toThrow : new WebDriverException(message, cause);
    }

    private Throwable rebuildServerError(Map<String, Object> rawErrorData) {
        if (!rawErrorData.containsKey(CLASS) && !rawErrorData.containsKey(STACK_TRACE)) {
            return null;
        }
        Object toReturn = null;
        String message = (String)rawErrorData.get(MESSAGE);
        if (rawErrorData.containsKey(CLASS)) {
            String className = (String)rawErrorData.get(CLASS);
            try {
                Class<?> clazz = Class.forName(className);
                if (Throwable.class.isAssignableFrom(clazz)) {
                    Class<?> throwableType = clazz;
                    Constructor<?> constructor = throwableType.getConstructor(String.class);
                    toReturn = (Throwable)constructor.newInstance(message);
                }
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (toReturn == null) {
            toReturn = new UnknownServerException(message);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        if (rawErrorData.containsKey(STACK_TRACE)) {
            List stackTraceInfo = (List)rawErrorData.get(STACK_TRACE);
            Iterable stackFrames = Iterables.transform((Iterable)stackTraceInfo, (Function)new FrameInfoToStackFrame());
            stackFrames = Iterables.filter((Iterable)stackFrames, (Predicate)Predicates.notNull());
            stackTrace = (StackTraceElement[])Iterables.toArray((Iterable)stackFrames, StackTraceElement.class);
        }
        ((Throwable)toReturn).setStackTrace(stackTrace);
        return toReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrameInfoToStackFrame
    implements Function<Map<String, Object>, StackTraceElement> {
        private FrameInfoToStackFrame() {
        }

        public StackTraceElement apply(Map<String, Object> frameInfo) {
            if (frameInfo == null) {
                return null;
            }
            Number lineNumber = (Number)frameInfo.get(ErrorHandler.LINE_NUMBER);
            if (lineNumber == null) {
                return null;
            }
            String className = frameInfo.containsKey(ErrorHandler.CLASS_NAME) ? String.valueOf(frameInfo.get(ErrorHandler.CLASS_NAME)) : ErrorHandler.UNKNOWN_CLASS;
            String methodName = frameInfo.containsKey(ErrorHandler.METHOD_NAME) ? String.valueOf(frameInfo.get(ErrorHandler.METHOD_NAME)) : ErrorHandler.UNKNOWN_METHOD;
            String fileName = frameInfo.containsKey(ErrorHandler.FILE_NAME) ? String.valueOf(frameInfo.get(ErrorHandler.FILE_NAME)) : ErrorHandler.UNKNOWN_FILE;
            return new StackTraceElement(className, methodName, fileName, lineNumber.intValue());
        }
    }

    public static class UnknownServerException
    extends WebDriverException {
        private UnknownServerException(String s) {
            super(s);
        }
    }
}

