/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.RenderedRemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath {
    private final ErrorHandler errorHandler = new ErrorHandler();
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    protected Process clientProcess;

    public RemoteWebDriver(CommandExecutor executor, Capabilities desiredCapabilities) {
        this.executor = executor;
        this.startClient();
        this.startSession(desiredCapabilities);
    }

    public RemoteWebDriver(Capabilities desiredCapabilities) throws Exception {
        this((URL)null, desiredCapabilities);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities) throws Exception {
        this(new HttpCommandExecutor(remoteAddress), desiredCapabilities);
    }

    protected void startSession(Capabilities desiredCapabilities) {
        Platform platform;
        Response response = this.execute(DriverCommand.NEW_SESSION, (Map<String, ?>)ImmutableMap.of((Object)"desiredCapabilities", (Object)desiredCapabilities));
        Map rawCapabilities = (Map)response.getValue();
        DesiredCapabilities returnedCapabilities = new DesiredCapabilities();
        for (Map.Entry entry : rawCapabilities.entrySet()) {
            if ("platform".equals(entry.getKey())) continue;
            returnedCapabilities.setCapability((String)entry.getKey(), entry.getValue());
        }
        String platformString = (String)rawCapabilities.get("platform");
        try {
            platform = platformString == null || "".equals(platformString) ? Platform.ANY : Platform.valueOf((String)platformString);
        }
        catch (IllegalArgumentException e) {
            platform = Platform.extractFromSysProperty((String)platformString);
        }
        returnedCapabilities.setPlatform(platform);
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    protected void startClient() {
    }

    protected void stopClient() {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.executor;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void get(String url) {
        this.execute(DriverCommand.GET, (Map<String, ?>)ImmutableMap.of((Object)"url", (Object)url));
    }

    public String getTitle() {
        Response response = this.execute(DriverCommand.GET_TITLE);
        return response.getValue().toString();
    }

    public String getCurrentUrl() {
        return this.execute(DriverCommand.GET_CURRENT_URL).getValue().toString();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String by, String using) {
        Response response = this.execute(DriverCommand.FIND_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (WebElement)response.getValue();
    }

    protected List<WebElement> findElements(String by, String using) {
        Response response = this.execute(DriverCommand.FIND_ELEMENTS, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)by, (Object)"value", (Object)using));
        return (List)response.getValue();
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public String getPageSource() {
        return (String)this.execute(DriverCommand.GET_PAGE_SOURCE).getValue();
    }

    public void close() {
        this.execute(DriverCommand.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            this.execute(DriverCommand.QUIT);
        }
        finally {
            this.sessionId = null;
            this.stopClient();
        }
    }

    public Set<String> getWindowHandles() {
        Response response = this.execute(DriverCommand.GET_WINDOW_HANDLES);
        List returnedValues = (List)response.getValue();
        return new LinkedHashSet<String>(returnedValues);
    }

    public String getWindowHandle() {
        return String.valueOf(this.execute(DriverCommand.GET_CURRENT_WINDOW_HANDLE).getValue());
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.capabilities.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return this.execute(DriverCommand.EXECUTE_SCRIPT, (Map<String, ?>)params).getValue();
    }

    public boolean isJavascriptEnabled() {
        return this.capabilities.isJavascriptEnabled();
    }

    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    protected RemoteWebElement newRemoteWebElement() {
        RemoteWebElement toReturn = this.capabilities.isJavascriptEnabled() ? new RenderedRemoteWebElement() : new RemoteWebElement();
        toReturn.setParent(this);
        return toReturn;
    }

    protected Response execute(DriverCommand driverCommand, Map<String, ?> parameters) {
        Response response;
        Command command = new Command(this.sessionId, driverCommand, parameters);
        try {
            response = this.executor.execute(command);
            Object value = new JsonToWebElementConverter().apply(response.getValue());
            response.setValue(value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        return this.errorHandler.throwIfResponseFailed(response);
    }

    protected Response execute(DriverCommand command) {
        return this.execute(command, (Map<String, ?>)ImmutableMap.of());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JsonToWebElementConverter
    implements Function<Object, Object> {
        private JsonToWebElementConverter() {
        }

        public Object apply(Object result) {
            if (result instanceof Collection) {
                Collection results = (Collection)result;
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)results, (Function)this));
            }
            if (result instanceof Map) {
                Map resultAsMap = (Map)result;
                if (resultAsMap.containsKey("ELEMENT")) {
                    RemoteWebElement element = RemoteWebDriver.this.newRemoteWebElement();
                    element.setId(String.valueOf(resultAsMap.get("ELEMENT")));
                    return element;
                }
                return Maps.transformValues((Map)resultAsMap, (Function)this);
            }
            if (result instanceof Number) {
                if (result instanceof Float || result instanceof Double) {
                    return ((Number)result).doubleValue();
                }
                return ((Number)result).longValue();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebElementToJsonConverter
    implements Function<Object, Object> {
        private WebElementToJsonConverter() {
        }

        public Object apply(Object arg) {
            if (arg == null || arg instanceof String || arg instanceof Boolean || arg instanceof Number) {
                return arg;
            }
            if (arg instanceof RemoteWebElement) {
                return ImmutableMap.of((Object)"ELEMENT", (Object)((RemoteWebElement)arg).getId());
            }
            if (arg instanceof Collection) {
                Collection args = (Collection)arg;
                return Collections2.transform((Collection)args, (Function)this);
            }
            if (arg instanceof Map) {
                Map args = (Map)arg;
                HashMap converted = Maps.newHashMapWithExpectedSize((int)args.size());
                for (Map.Entry entry : args.entrySet()) {
                    Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        throw new IllegalArgumentException("All keys in Map script arguments must be strings: " + key.getClass().getName());
                    }
                    converted.put((String)key, this.apply(entry.getValue()));
                }
                return converted;
            }
            throw new IllegalArgumentException("Argument is of an illegal type: " + arg.getClass().getName());
        }
    }

    protected class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        protected RemoteTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)frameIndex));
            return RemoteWebDriver.this;
        }

        public WebDriver frame(String frameName) {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)frameName));
            return RemoteWebDriver.this;
        }

        public WebDriver window(String windowName) {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_WINDOW, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)windowName));
            return RemoteWebDriver.this;
        }

        public WebDriver defaultContent() {
            HashMap frameId = Maps.newHashMap();
            frameId.put("id", null);
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME, frameId);
            return RemoteWebDriver.this;
        }

        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute(DriverCommand.GET_ACTIVE_ELEMENT);
            return (WebElement)response.getValue();
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        public void back() {
            RemoteWebDriver.this.execute(DriverCommand.GO_BACK);
        }

        public void forward() {
            RemoteWebDriver.this.execute(DriverCommand.GO_FORWARD);
        }

        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            RemoteWebDriver.this.execute(DriverCommand.REFRESH);
        }
    }

    protected class RemoteTimeouts
    implements WebDriver.Timeouts {
        protected RemoteTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            RemoteWebDriver.this.execute(DriverCommand.IMPLICITLY_WAIT, (Map<String, ?>)ImmutableMap.of((Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(Math.max(0L, time), unit)));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteWebDriverOptions
    implements WebDriver.Options {
        private RemoteWebDriverOptions() {
        }

        public void addCookie(Cookie cookie) {
            RemoteWebDriver.this.execute(DriverCommand.ADD_COOKIE, (Map<String, ?>)ImmutableMap.of((Object)"cookie", (Object)cookie));
        }

        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute(DriverCommand.DELETE_COOKIE, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            RemoteWebDriver.this.execute(DriverCommand.DELETE_ALL_COOKIES);
        }

        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute(DriverCommand.GET_ALL_COOKIES).getValue();
            try {
                List cookies = (List)new JsonToBeanConverter().convert(List.class, returned);
                HashSet<Cookie> toReturn = new HashSet<Cookie>();
                for (Map rawCookie : cookies) {
                    String name = (String)rawCookie.get("name");
                    String value = (String)rawCookie.get("value");
                    String path = (String)rawCookie.get("path");
                    String domain = (String)rawCookie.get("domain");
                    Boolean secure = (Boolean)rawCookie.get("secure");
                    toReturn.add((Cookie)new ReturnedCookie(name, value, domain, path, null, secure.booleanValue(), RemoteWebDriver.this.getCurrentUrl()));
                }
                return toReturn;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public Speed getSpeed() {
            Response response = RemoteWebDriver.this.execute(DriverCommand.GET_SPEED);
            return Speed.valueOf((String)((String)response.getValue()));
        }

        public void setSpeed(Speed speed) {
            RemoteWebDriver.this.execute(DriverCommand.SET_SPEED, (Map<String, ?>)ImmutableMap.of((Object)"speed", (Object)speed));
        }

        public WebDriver.Timeouts timeouts() {
            return new RemoteTimeouts();
        }
    }
}

