/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import java.util.regex.Pattern;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.constraint.PropertyNameConstraint;
import org.spockframework.runtime.Condition;
import org.spockframework.util.CollectionUtil;

public class RegexPropertyNameConstraint
extends PropertyNameConstraint {
    private final Pattern pattern;

    public RegexPropertyNameConstraint(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        String propertyName = this.getPropertyName(invocation);
        return propertyName != null && this.pattern.matcher(propertyName).matches();
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        Condition condition = new Condition(CollectionUtil.listOf(this.getPropertyName(invocation), this.pattern.pattern(), false), String.format("propertyName ==~ /%s/", this.pattern.pattern()), null, null, null, null);
        return condition.getRendering();
    }
}

