/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.lang.SpreadWildcard;
import org.spockframework.lang.Wildcard;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.constraint.CodeArgumentConstraint;
import org.spockframework.mock.constraint.EqualArgumentConstraint;
import org.spockframework.mock.constraint.EqualMethodNameConstraint;
import org.spockframework.mock.constraint.EqualPropertyNameConstraint;
import org.spockframework.mock.constraint.NamedArgumentListConstraint;
import org.spockframework.mock.constraint.NegatingArgumentConstraint;
import org.spockframework.mock.constraint.PositionalArgumentListConstraint;
import org.spockframework.mock.constraint.RegexMethodNameConstraint;
import org.spockframework.mock.constraint.RegexPropertyNameConstraint;
import org.spockframework.mock.constraint.SpreadWildcardArgumentConstraint;
import org.spockframework.mock.constraint.TargetConstraint;
import org.spockframework.mock.constraint.TypeArgumentConstraint;
import org.spockframework.mock.constraint.WildcardArgumentConstraint;
import org.spockframework.mock.constraint.WildcardMethodNameConstraint;
import org.spockframework.mock.response.CodeResponseGenerator;
import org.spockframework.mock.response.ConstantResponseGenerator;
import org.spockframework.mock.response.DefaultResponseGenerator;
import org.spockframework.mock.response.IterableResponseGenerator;
import org.spockframework.mock.response.ResponseGeneratorChain;
import org.spockframework.mock.response.WildcardResponseGenerator;
import org.spockframework.mock.runtime.MockInteraction;
import org.spockframework.runtime.InvalidSpecException;

public class InteractionBuilder {
    private final int line;
    private final int column;
    private final String text;
    private int minCount = 0;
    private int maxCount = Integer.MAX_VALUE;
    private List<IInvocationConstraint> invConstraints = new ArrayList<IInvocationConstraint>();
    private List<Object> argNames;
    private List<IArgumentConstraint> argConstraints;
    private ResponseGeneratorChain responseGeneratorChain = new ResponseGeneratorChain();
    public static final String SET_FIXED_COUNT = "setFixedCount";
    public static final String SET_RANGE_COUNT = "setRangeCount";
    public static final String ADD_EQUAL_TARGET = "addEqualTarget";
    public static final String ADD_WILDCARD_TARGET = "addWildcardTarget";
    public static final String ADD_EQUAL_PROPERTY_NAME = "addEqualPropertyName";
    public static final String ADD_REGEX_PROPERTY_NAME = "addRegexPropertyName";
    public static final String ADD_EQUAL_METHOD_NAME = "addEqualMethodName";
    public static final String ADD_REGEX_METHOD_NAME = "addRegexMethodName";
    public static final String SET_ARG_LIST_KIND = "setArgListKind";
    public static final String ADD_ARG_NAME = "addArgName";
    public static final String ADD_CODE_ARG = "addCodeArg";
    public static final String ADD_EQUAL_ARG = "addEqualArg";
    public static final String TYPE_LAST_ARG = "typeLastArg";
    public static final String NEGATE_LAST_ARG = "negateLastArg";
    public static final String ADD_CONSTANT_RESPONSE = "addConstantResponse";
    public static final String ADD_CODE_RESPONSE = "addCodeResponse";
    public static final String ADD_ITERABLE_RESPONSE = "addIterableResponse";
    public static final String BUILD = "build";

    public InteractionBuilder(int line, int column, String text) {
        this.line = line;
        this.column = column;
        this.text = text;
    }

    public InteractionBuilder setFixedCount(Object count) {
        if (count instanceof Wildcard) {
            this.minCount = 0;
            this.maxCount = Integer.MAX_VALUE;
        } else {
            this.minCount = this.maxCount = InteractionBuilder.convertCount(count, true);
        }
        return this;
    }

    public InteractionBuilder setRangeCount(Object minCount, Object maxCount, boolean inclusive) {
        this.minCount = minCount instanceof Wildcard ? 0 : InteractionBuilder.convertCount(minCount, true);
        int n = this.maxCount = maxCount instanceof Wildcard ? Integer.MAX_VALUE : InteractionBuilder.convertCount(maxCount, inclusive);
        if (this.minCount > this.maxCount) {
            throw new InvalidSpecException("lower bound of invocation count must come before upper bound");
        }
        return this;
    }

    public InteractionBuilder addEqualTarget(Object target) {
        this.invConstraints.add(new TargetConstraint(target));
        return this;
    }

    public InteractionBuilder addWildcardTarget() {
        this.invConstraints.add(new TargetConstraint(Wildcard.INSTANCE));
        return this;
    }

    public InteractionBuilder addEqualPropertyName(String name) {
        if (name.equals(Wildcard.INSTANCE.toString())) {
            this.invConstraints.add(WildcardMethodNameConstraint.INSTANCE);
        } else {
            this.invConstraints.add(new EqualPropertyNameConstraint(name));
        }
        return this;
    }

    public InteractionBuilder addRegexPropertyName(String regex) {
        this.invConstraints.add(new RegexPropertyNameConstraint(regex));
        return this;
    }

    public InteractionBuilder addEqualMethodName(String name) {
        if (name.equals(Wildcard.INSTANCE.toString())) {
            this.invConstraints.add(WildcardMethodNameConstraint.INSTANCE);
        } else {
            this.invConstraints.add(new EqualMethodNameConstraint(name));
        }
        return this;
    }

    public InteractionBuilder addRegexMethodName(String regex) {
        this.invConstraints.add(new RegexMethodNameConstraint(regex));
        return this;
    }

    public InteractionBuilder setArgListKind(boolean isPositional) {
        return this.setArgListKind(isPositional, false);
    }

    public InteractionBuilder setArgListKind(boolean isPositional, boolean isMixed) {
        this.argConstraints = new ArrayList<IArgumentConstraint>();
        this.argNames = new ArrayList<Object>();
        if (isPositional) {
            this.invConstraints.add(new PositionalArgumentListConstraint(this.argConstraints, isMixed));
        } else {
            this.invConstraints.add(new NamedArgumentListConstraint(this.argNames, this.argConstraints, isMixed));
        }
        return this;
    }

    public InteractionBuilder addArgName(String name) {
        this.argNames.add(name);
        return this;
    }

    public InteractionBuilder addCodeArg(Closure closure) {
        this.argConstraints.add(new CodeArgumentConstraint(closure));
        return this;
    }

    public InteractionBuilder addEqualArg(Object arg) {
        this.argConstraints.add(arg instanceof Wildcard ? WildcardArgumentConstraint.INSTANCE : (arg instanceof SpreadWildcard ? SpreadWildcardArgumentConstraint.INSTANCE : new EqualArgumentConstraint(arg)));
        return this;
    }

    public InteractionBuilder typeLastArg(Class<?> type) {
        IArgumentConstraint last = this.argConstraints.get(this.argConstraints.size() - 1);
        this.argConstraints.set(this.argConstraints.size() - 1, new TypeArgumentConstraint(type, last));
        return this;
    }

    public InteractionBuilder negateLastArg() {
        IArgumentConstraint last = this.argConstraints.get(this.argConstraints.size() - 1);
        this.argConstraints.set(this.argConstraints.size() - 1, new NegatingArgumentConstraint(last));
        return this;
    }

    public InteractionBuilder addConstantResponse(Object constant) {
        this.responseGeneratorChain.addFirst(constant instanceof Wildcard ? new WildcardResponseGenerator() : new ConstantResponseGenerator(constant));
        return this;
    }

    public InteractionBuilder addCodeResponse(Closure closure) {
        this.responseGeneratorChain.addFirst(new CodeResponseGenerator(closure));
        return this;
    }

    public InteractionBuilder addIterableResponse(Object iterable) {
        this.responseGeneratorChain.addFirst(new IterableResponseGenerator(iterable));
        return this;
    }

    public IMockInteraction build() {
        return new MockInteraction(this.line, this.column, this.text, this.minCount, this.maxCount, this.invConstraints, this.responseGeneratorChain.isEmpty() ? new DefaultResponseGenerator() : this.responseGeneratorChain);
    }

    private static int convertCount(Object count, boolean inclusive) {
        if (!(count instanceof Number)) {
            throw new InvalidSpecException("invocation count must be a number");
        }
        int intCount = ((Number)count).intValue();
        if (!inclusive) {
            --intCount;
        }
        if (intCount < 0) {
            throw new InvalidSpecException("invocation count must be >= 0");
        }
        return intCount;
    }
}

