/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IExcludable;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.ReflectionUtil;

public class MethodInfo
extends NodeInfo<SpecInfo, Method>
implements IExcludable,
IInterceptable {
    private MethodKind kind;
    private FeatureInfo feature;
    private IterationInfo iteration;
    private boolean excluded = false;
    private final List<IMethodInterceptor> interceptors = new ArrayList<IMethodInterceptor>();

    public MethodInfo() {
    }

    public MethodInfo(MethodInfo other) {
        this.kind = other.kind;
        this.feature = other.feature;
        this.iteration = other.iteration;
        this.excluded = other.excluded;
        this.setName(other.getName());
        this.setLine(other.getLine());
        this.setParent(other.getParent());
        this.setReflection(other.getReflection());
        this.setMetadata(other.getMetadata());
        this.setDescription(other.getDescription());
        this.interceptors.addAll(other.interceptors);
    }

    public MethodKind getKind() {
        return this.kind;
    }

    public void setKind(MethodKind kind) {
        this.kind = kind;
    }

    public FeatureInfo getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureInfo feature) {
        this.feature = feature;
    }

    public IterationInfo getIteration() {
        return this.iteration;
    }

    public void setIteration(IterationInfo iteration) {
        this.iteration = iteration;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    @Override
    public List<IMethodInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(IMethodInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public boolean hasBytecodeName(String name) {
        return ((Method)this.getReflection()).getName().equals(name);
    }

    public Object invoke(Object target, Object ... arguments) throws Throwable {
        return ReflectionUtil.invokeMethod(target, (Method)this.getReflection(), arguments);
    }
}

