/*
 * Decompiled with CFR 0.152.
 */
package spock.util.environment;

import org.spockframework.util.VersionNumber;

public class Jvm {
    private final String javaVersion = System.getProperty("java.version");
    private final String javaSpecVersion = System.getProperty("java.specification.version");
    private final VersionNumber javaSpecVersionNumber = VersionNumber.parse(this.javaSpecVersion);

    private Jvm() {
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaSpecificationVersion() {
        return this.javaSpecVersion;
    }

    public boolean isJava5() {
        return "1.5".equals(this.javaSpecVersion);
    }

    public boolean isJava6() {
        return "1.6".equals(this.javaSpecVersion);
    }

    public boolean isJava7() {
        return "1.7".equals(this.javaSpecVersion);
    }

    public boolean isJava8() {
        return "1.8".equals(this.javaSpecVersion);
    }

    public boolean isJava9() {
        return "9".equals(this.javaSpecVersion);
    }

    public boolean isJava10() {
        return "10".equals(this.javaSpecVersion);
    }

    public boolean isJava11() {
        return "11".equals(this.javaSpecVersion);
    }

    public boolean isJava5Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 5;
    }

    public boolean isJava6Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 6;
    }

    public boolean isJava7Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 7;
    }

    public boolean isJava8Compatible() {
        return this.javaSpecVersionNumber.getMajor() > 1 || this.javaSpecVersionNumber.getMinor() >= 8;
    }

    public boolean isJava9Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 9;
    }

    public boolean isJava10Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 10;
    }

    public boolean isJava11Compatible() {
        return this.javaSpecVersionNumber.getMajor() >= 11;
    }

    public static Jvm getCurrent() {
        return new Jvm();
    }
}

