/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.util.ServiceLoaderWithExceptionControl;

public class CloudFactory {
    private List<CloudConnector> cloudConnectors = new ArrayList<CloudConnector>();
    private List<ServiceConnectorCreator<?, ? extends ServiceInfo>> serviceCreators = new ArrayList();

    public CloudFactory() {
        this.scanCloudConnectors();
        this.scanServiceConnectorCreators();
    }

    public Cloud getCloud() {
        CloudConnector suitableCloudConnector = null;
        for (CloudConnector cloudConnector : this.cloudConnectors) {
            if (!cloudConnector.isInMatchingCloud()) continue;
            suitableCloudConnector = cloudConnector;
            break;
        }
        if (suitableCloudConnector == null) {
            throw new CloudException("No suitable cloud connector found");
        }
        return new Cloud(suitableCloudConnector, this.serviceCreators);
    }

    public void registerCloudConnector(CloudConnector cloudConnector) {
        this.cloudConnectors.add(cloudConnector);
    }

    List<CloudConnector> getCloudConnectors() {
        return this.cloudConnectors;
    }

    List<ServiceConnectorCreator<?, ? extends ServiceInfo>> getServiceCreators() {
        return this.serviceCreators;
    }

    private void registerServiceCreator(ServiceConnectorCreator<?, ? extends ServiceInfo> serviceConnectorCreator) {
        this.serviceCreators.add(serviceConnectorCreator);
    }

    private void scanCloudConnectors() {
        ServiceLoader<CloudConnector> loader = ServiceLoader.load(CloudConnector.class);
        for (CloudConnector cloudConnector : loader) {
            this.registerCloudConnector(cloudConnector);
        }
    }

    private void scanServiceConnectorCreators() {
        Iterable<ServiceConnectorCreator> loader = ServiceLoaderWithExceptionControl.load(ServiceConnectorCreator.class);
        for (ServiceConnectorCreator serviceConnectorCreator : loader) {
            if (serviceConnectorCreator == null) continue;
            this.registerServiceCreator(serviceConnectorCreator);
        }
    }
}

