/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.ServletUtils;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

@Order(value=-2147483643)
public class TraceFilter
extends OncePerRequestFilter {
    private static final String HTTP_COMPONENT = "http";
    protected static final String TRACE_REQUEST_ATTR = TraceFilter.class.getName() + ".TRACE";
    public static final String DEFAULT_SKIP_PATTERN = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final Pattern skipPattern;
    private final SpanReporter spanReporter;
    private final SpanExtractor<HttpServletRequest> spanExtractor;
    private final SpanInjector<HttpServletResponse> spanInjector;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public TraceFilter(Tracer tracer, TraceKeys traceKeys, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector) {
        this(tracer, traceKeys, Pattern.compile(DEFAULT_SKIP_PATTERN), spanReporter, spanExtractor, spanInjector);
    }

    public TraceFilter(Tracer tracer, TraceKeys traceKeys, Pattern skipPattern, SpanReporter spanReporter, SpanExtractor<HttpServletRequest> spanExtractor, SpanInjector<HttpServletResponse> spanInjector) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.skipPattern = skipPattern;
        this.spanReporter = spanReporter;
        this.spanExtractor = spanExtractor;
        this.spanInjector = spanInjector;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        boolean skip = this.skipPattern.matcher(uri).matches() || "0".equals(ServletUtils.getHeader(request, response, "X-B3-Sampled"));
        Span spanFromRequest = (Span)request.getAttribute(TRACE_REQUEST_ATTR);
        if (spanFromRequest != null) {
            this.tracer.continueSpan(spanFromRequest);
        }
        this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
        String name = "http:" + uri;
        spanFromRequest = this.createSpan(request, skip, spanFromRequest, name);
        Throwable exception = null;
        try {
            this.addRequestTags(request);
            this.spanInjector.inject(spanFromRequest, response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable e) {
            try {
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                if (this.isAsyncStarted(request) || request.isAsyncStarted()) {
                    this.tracer.detach(spanFromRequest);
                    return;
                }
                this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
                if (spanFromRequest != null) {
                    this.addResponseTags(response, exception);
                    if (spanFromRequest.hasSavedSpan()) {
                        Span parent = spanFromRequest.getSavedSpan();
                        if (parent.isRemote()) {
                            parent.logEvent("ss");
                            parent.stop();
                            this.spanReporter.report(parent);
                        }
                    } else {
                        spanFromRequest.logEvent("ss");
                    }
                    this.tracer.close(spanFromRequest);
                }
                throw throwable;
            }
        }
        if (this.isAsyncStarted(request) || request.isAsyncStarted()) {
            this.tracer.detach(spanFromRequest);
            return;
        }
        this.addToResponseIfNotPresent(response, "X-B3-Sampled", skip ? "0" : "1");
        if (spanFromRequest != null) {
            this.addResponseTags(response, exception);
            if (spanFromRequest.hasSavedSpan()) {
                Span parent = spanFromRequest.getSavedSpan();
                if (parent.isRemote()) {
                    parent.logEvent("ss");
                    parent.stop();
                    this.spanReporter.report(parent);
                }
            } else {
                spanFromRequest.logEvent("ss");
            }
            this.tracer.close(spanFromRequest);
        }
    }

    private Span createSpan(HttpServletRequest request, boolean skip, Span spanFromRequest, String name) {
        if (spanFromRequest != null) {
            return spanFromRequest;
        }
        Span parent = this.spanExtractor.joinTrace(request);
        if (parent != null) {
            spanFromRequest = this.tracer.createSpan(name, parent);
            if (parent.isRemote()) {
                parent.logEvent("sr");
            }
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
        } else {
            spanFromRequest = skip ? this.tracer.createSpan(name, NeverSampler.INSTANCE) : this.tracer.createSpan(name);
            spanFromRequest.logEvent("sr");
            request.setAttribute(TRACE_REQUEST_ATTR, (Object)spanFromRequest);
        }
        return spanFromRequest;
    }

    protected void addRequestTags(HttpServletRequest request) {
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        this.tracer.addTag(this.traceKeys.getHttp().getUrl(), this.getFullUrl(request));
        this.tracer.addTag(this.traceKeys.getHttp().getHost(), request.getServerName());
        this.tracer.addTag(this.traceKeys.getHttp().getPath(), uri);
        this.tracer.addTag(this.traceKeys.getHttp().getMethod(), request.getMethod());
        for (String name : this.traceKeys.getHttp().getHeaders()) {
            Enumeration values = request.getHeaders(name);
            if (!values.hasMoreElements()) continue;
            String key = this.traceKeys.getHttp().getPrefix() + name.toLowerCase();
            ArrayList list = Collections.list(values);
            String value = list.size() == 1 ? (String)list.get(0) : StringUtils.collectionToDelimitedString(list, (String)",", (String)"'", (String)"'");
            this.tracer.addTag(key, value);
        }
    }

    protected void addResponseTags(HttpServletResponse response, Throwable e) {
        int httpStatus = response.getStatus();
        if (httpStatus == 200 && e != null) {
            this.tracer.addTag(this.traceKeys.getHttp().getStatusCode(), String.valueOf(500));
        } else if (httpStatus < 200 || httpStatus > 299) {
            this.tracer.addTag(this.traceKeys.getHttp().getStatusCode(), String.valueOf(response.getStatus()));
        }
    }

    private void addToResponseIfNotPresent(HttpServletResponse response, String name, String value) {
        if (!StringUtils.hasText((String)response.getHeader(name))) {
            response.addHeader(name, value);
        }
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer requestURI = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURI.toString();
        }
        return requestURI.append('?').append(queryString).toString();
    }
}

