/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.client.http.HttpRequest;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;

class RequestBuilderContextInjector
implements SpanInjector<HttpRequest.Builder> {
    RequestBuilderContextInjector() {
    }

    @Override
    public void inject(Span span, HttpRequest.Builder carrier) {
        if (span == null) {
            this.setHeader(carrier, "X-B3-Sampled", "0");
            return;
        }
        this.setHeader(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(carrier, "X-B3-TraceId", Span.idToHex(span.getTraceId()));
        this.setHeader(carrier, "X-B3-SpanId", Span.idToHex(span.getSpanId()));
        this.setHeader(carrier, "X-Span-Name", span.getName());
        if (this.getParentId(span) != null) {
            this.setHeader(carrier, "X-B3-ParentSpanId", Span.idToHex(this.getParentId(span)));
        }
        this.setHeader(carrier, "X-Process-Id", span.getProcessId());
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    public void setHeader(HttpRequest.Builder builder, String name, String value) {
        if (value != null) {
            builder.header(name, value);
        }
    }
}

