/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.log.NoOpSpanLogger;
import org.springframework.cloud.sleuth.log.Slf4jSpanLogger;
import org.springframework.cloud.sleuth.log.SpanLogger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
public class SleuthLogAutoConfiguration {
    @Bean
    @ConditionalOnMissingClass(value={"org.slf4j.MDC"})
    @ConditionalOnMissingBean
    public SpanLogger defaultLoggedSpansHandler() {
        return new NoOpSpanLogger();
    }

    @Configuration
    @ConditionalOnClass(value={MDC.class})
    protected static class Slf4jConfiguration {
        @Value(value="${spring.sleuth.log.slf4j.nameSkipPattern:}")
        private String nameSkipPattern;

        protected Slf4jConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.log.slf4j.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public SpanLogger slf4jSpanLogger() {
            return new Slf4jSpanLogger(this.nameSkipPattern);
        }

        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.log.slf4j.enabled"}, havingValue="false")
        @ConditionalOnMissingBean
        public SpanLogger noOpSlf4jSpanLogger() {
            return new NoOpSpanLogger();
        }
    }
}

