/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.log.SpanLogger;

public class Slf4jSpanLogger
implements SpanLogger {
    private final Logger log;
    private final Pattern nameSkipPattern;

    public Slf4jSpanLogger(String nameSkipPattern) {
        this.nameSkipPattern = Pattern.compile(nameSkipPattern);
        this.log = LoggerFactory.getLogger(Slf4jSpanLogger.class);
    }

    Slf4jSpanLogger(String nameSkipPattern, Logger log) {
        this.nameSkipPattern = Pattern.compile(nameSkipPattern);
        this.log = log;
    }

    @Override
    public void logStartedSpan(Span parent, Span span) {
        MDC.put((String)"X-B3-SpanId", (String)Span.idToHex(span.getSpanId()));
        MDC.put((String)"X-Span-Export", (String)String.valueOf(span.isExportable()));
        MDC.put((String)"X-B3-TraceId", (String)Span.idToHex(span.getTraceId()));
        this.log("Starting span: {}", span);
        if (parent != null) {
            this.log("With parent: {}", parent);
        }
    }

    @Override
    public void logContinuedSpan(Span span) {
        MDC.put((String)"X-B3-SpanId", (String)Span.idToHex(span.getSpanId()));
        MDC.put((String)"X-B3-TraceId", (String)Span.idToHex(span.getTraceId()));
        MDC.put((String)"X-Span-Export", (String)String.valueOf(span.isExportable()));
        this.log("Continued span: {}", span);
    }

    @Override
    public void logStoppedSpan(Span parent, Span span) {
        this.log("Stopped span: {}", span);
        if (span != null && parent != null) {
            this.log("With parent: {}", parent);
            MDC.put((String)"X-B3-SpanId", (String)Span.idToHex(parent.getSpanId()));
            MDC.put((String)"X-Span-Export", (String)String.valueOf(parent.isExportable()));
        } else {
            MDC.remove((String)"X-B3-SpanId");
            MDC.remove((String)"X-Span-Export");
            MDC.remove((String)"X-B3-TraceId");
        }
    }

    private void log(String text, Span span) {
        if (span != null && this.nameSkipPattern.matcher(span.getName()).matches()) {
            return;
        }
        this.log.trace(text, (Object)span);
    }
}

