/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.CrudMethodsSupportedHttpMethods;
import org.springframework.data.rest.core.mapping.MappingResourceMetadata;
import org.springframework.data.rest.core.mapping.PersistentEntitiesResourceMappings;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.util.Assert;

class RepositoryAwareResourceMetadata
implements ResourceMetadata {
    private final CollectionResourceMapping mapping;
    private final PersistentEntitiesResourceMappings provider;
    private final RepositoryMetadata repositoryMetadata;
    private final SupportedHttpMethods crudMethodsSupportedHttpMethods;
    private MappingResourceMetadata mappingMetadata;

    public RepositoryAwareResourceMetadata(PersistentEntity<?, ?> entity, CollectionResourceMapping mapping, RepositoryResourceMappings provider, RepositoryMetadata repositoryMetadata) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        Assert.notNull((Object)mapping, (String)"CollectionResourceMapping must not be null!");
        Assert.notNull((Object)provider, (String)"ResourceMetadataProvider must not be null!");
        Assert.notNull((Object)repositoryMetadata, (String)"RepositoryMetadata must not be null!");
        this.mapping = mapping;
        this.provider = provider;
        this.repositoryMetadata = repositoryMetadata;
        this.crudMethodsSupportedHttpMethods = new CrudMethodsSupportedHttpMethods(repositoryMetadata.getCrudMethods());
    }

    public boolean isPrimary() {
        return AnnotationUtils.findAnnotation((Class)this.repositoryMetadata.getRepositoryInterface(), Primary.class) != null;
    }

    @Override
    public Class<?> getDomainType() {
        return this.repositoryMetadata.getDomainType();
    }

    @Override
    public PropertyAwareResourceMapping getProperty(String mappedPath) {
        if (this.mappingMetadata == null) {
            this.mappingMetadata = this.provider.getMappingMetadataFor(this.getDomainType());
        }
        return this.mappingMetadata.getProperty(mappedPath);
    }

    @Override
    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        return this.provider.getMappingFor(property);
    }

    @Override
    public boolean isExported(PersistentProperty<?> property) {
        return this.provider.isMapped(property);
    }

    @Override
    public boolean isExported() {
        return this.mapping.isExported();
    }

    @Override
    public String getRel() {
        return this.mapping.getRel();
    }

    @Override
    public String getItemResourceRel() {
        return this.mapping.getItemResourceRel();
    }

    @Override
    public Path getPath() {
        return this.mapping.getPath();
    }

    @Override
    public boolean isPagingResource() {
        return this.mapping.isPagingResource();
    }

    @Override
    public ResourceDescription getDescription() {
        return this.mapping.getDescription();
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        return this.mapping.getItemResourceDescription();
    }

    @Override
    public Class<?> getExcerptProjection() {
        return this.mapping.getExcerptProjection();
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings() {
        return this.provider.getSearchResourceMappings(this.repositoryMetadata.getDomainType());
    }

    @Override
    public SupportedHttpMethods getSupportedHttpMethods() {
        return this.crudMethodsSupportedHttpMethods;
    }
}

