/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Date;
import org.springframework.integration.event.IntegrationEvent;
import org.springframework.integration.support.context.NamedComponent;

public class MessageGroupExpiredEvent
extends IntegrationEvent {
    private static final long serialVersionUID = -7126221042599333919L;
    private final Object groupId;
    private final int messageCount;
    private final Date lastModified;
    private final Date expired;
    private final boolean discarded;

    public MessageGroupExpiredEvent(Object source, Object groupId, int messageCount, Date lastModified, Date expired, boolean discarded) {
        super(source);
        this.groupId = groupId;
        this.messageCount = messageCount;
        this.lastModified = lastModified;
        this.expired = expired;
        this.discarded = discarded;
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    protected Date getLastModified() {
        return this.lastModified;
    }

    public Date getExpired() {
        return this.expired;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        String sourceName = this.source instanceof NamedComponent ? ((NamedComponent)this.source).getComponentName() : this.source.toString();
        builder.append("MessageGroupExpiredEvent [groupId=").append(this.groupId).append(", messageCount=").append(this.messageCount).append(", lastModified=").append(this.lastModified).append(", expiredAt=").append(this.expired).append(", discarded=").append(this.discarded).append(", source=").append((Object)sourceName).append("]");
        return builder.toString();
    }
}

