/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.ArrayDeque;
import java.util.List;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.messaging.Message;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPollableChannel
extends AbstractMessageChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private volatile int executorInterceptorsSize;

    @Override
    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    @Override
    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    @Override
    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    @Override
    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    public final Message<?> receive() {
        return this.receive(-1L);
    }

    public final Message<?> receive(long timeout) {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque<ChannelInterceptor> interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + this + "'"));
            }
            if (interceptorList.getSize() > 0 && !interceptorList.preReceive(this, interceptorStack = new ArrayDeque<ChannelInterceptor>())) {
                return null;
            }
            Message<?> message = this.doReceive(timeout);
            if (countsEnabled) {
                this.getMetrics().afterReceive();
                counted = true;
            }
            if (message != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("postReceive on channel '" + this + "', message: " + message));
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("postReceive on channel '" + this + "', message is null"));
            }
            if (!CollectionUtils.isEmpty(interceptorStack)) {
                message = interceptorList.postReceive(message, this);
                interceptorList.afterReceiveCompletion(message, this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                this.getMetrics().afterError();
            }
            if (!CollectionUtils.isEmpty(interceptorStack)) {
                interceptorList.afterReceiveCompletion(null, this, e, interceptorStack);
            }
            throw e;
        }
    }

    @Override
    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    @Override
    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    @Override
    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    @Override
    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }

    protected abstract Message<?> doReceive(long var1);
}

