/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.integration.config.SpelFunctionFactoryBean;
import org.springframework.integration.config.SpelPropertyAccessorRegistrar;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.util.Assert;

public class IntegrationEvaluationContextFactoryBean
implements FactoryBean<StandardEvaluationContext>,
ApplicationContextAware,
InitializingBean {
    private volatile Map<String, PropertyAccessor> propertyAccessors = new LinkedHashMap<String, PropertyAccessor>();
    private volatile Map<String, Method> functions = new LinkedHashMap<String, Method>();
    private TypeConverter typeConverter = new StandardTypeConverter();
    private volatile TypeLocator typeLocator;
    private BeanResolver beanResolver;
    private ApplicationContext applicationContext;
    private volatile boolean initialized;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setPropertyAccessors(Map<String, PropertyAccessor> accessors) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'propertyAccessors' can't be changed after initialization.");
        Assert.notNull(accessors, (String)"'accessors' must not be null.");
        Assert.noNullElements((Object[])accessors.values().toArray(), (String)"'accessors' cannot have null values.");
        this.propertyAccessors = new LinkedHashMap<String, PropertyAccessor>(accessors);
    }

    public Map<String, PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors;
    }

    public void setFunctions(Map<String, Method> functionsArg) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'functions' can't be changed after initialization.");
        Assert.notNull(functionsArg, (String)"'functions' must not be null.");
        Assert.noNullElements((Object[])functionsArg.values().toArray(), (String)"'functions' cannot have null values.");
        this.functions = new LinkedHashMap<String, Method>(functionsArg);
    }

    public Map<String, Method> getFunctions() {
        return this.functions;
    }

    public void setTypeLocator(TypeLocator typeLocator) {
        this.typeLocator = typeLocator;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null) {
            ApplicationContext parent;
            this.beanResolver = new BeanFactoryResolver((BeanFactory)this.applicationContext);
            ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)this.applicationContext);
            if (conversionService != null) {
                this.typeConverter = new StandardTypeConverter(conversionService);
            }
            Map functionFactoryBeanMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, SpelFunctionFactoryBean.class);
            for (Object spelFunctionFactoryBean : functionFactoryBeanMap.values()) {
                if (this.functions.containsKey(((SpelFunctionFactoryBean)spelFunctionFactoryBean).getFunctionName())) continue;
                this.functions.put(((SpelFunctionFactoryBean)spelFunctionFactoryBean).getFunctionName(), ((SpelFunctionFactoryBean)spelFunctionFactoryBean).getObject());
            }
            try {
                SpelPropertyAccessorRegistrar propertyAccessorRegistrar = (SpelPropertyAccessorRegistrar)this.applicationContext.getBean(SpelPropertyAccessorRegistrar.class);
                for (Map.Entry entry : propertyAccessorRegistrar.getPropertyAccessors().entrySet()) {
                    if (this.propertyAccessors.containsKey(entry.getKey())) continue;
                    this.propertyAccessors.put((String)entry.getKey(), (PropertyAccessor)entry.getValue());
                }
            }
            catch (NoSuchBeanDefinitionException propertyAccessorRegistrar) {
                // empty catch block
            }
            if ((parent = this.applicationContext.getParent()) != null && parent.containsBean("integrationEvaluationContext")) {
                IntegrationEvaluationContextFactoryBean parentFactoryBean = (IntegrationEvaluationContextFactoryBean)parent.getBean("&integrationEvaluationContext", IntegrationEvaluationContextFactoryBean.class);
                for (Map.Entry<String, PropertyAccessor> entry : parentFactoryBean.getPropertyAccessors().entrySet()) {
                    if (this.propertyAccessors.containsKey(entry.getKey())) continue;
                    this.propertyAccessors.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Method> entry : parentFactoryBean.getFunctions().entrySet()) {
                    if (this.functions.containsKey(entry.getKey())) continue;
                    this.functions.put(entry.getKey(), entry.getValue());
                }
            }
        }
        this.initialized = true;
    }

    public StandardEvaluationContext getObject() throws Exception {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        if (this.typeLocator != null) {
            evaluationContext.setTypeLocator(this.typeLocator);
        }
        evaluationContext.setBeanResolver(this.beanResolver);
        evaluationContext.setTypeConverter(this.typeConverter);
        for (PropertyAccessor propertyAccessor : this.propertyAccessors.values()) {
            evaluationContext.addPropertyAccessor(propertyAccessor);
        }
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        for (Map.Entry entry : this.functions.entrySet()) {
            evaluationContext.registerFunction((String)entry.getKey(), (Method)entry.getValue());
        }
        return evaluationContext;
    }

    public Class<?> getObjectType() {
        return StandardEvaluationContext.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

