/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management.graph;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.handler.CompositeMessageHandler;
import org.springframework.integration.handler.DiscardingMessageHandler;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.integration.router.RecipientListRouterManagement;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.MappingMessageRouterManagement;
import org.springframework.integration.support.management.graph.CompositeMessageHandlerNode;
import org.springframework.integration.support.management.graph.DiscardingMessageHandlerNode;
import org.springframework.integration.support.management.graph.EndpointNode;
import org.springframework.integration.support.management.graph.ErrorCapableCompositeMessageHandlerNode;
import org.springframework.integration.support.management.graph.ErrorCapableDiscardingMessageHandlerNode;
import org.springframework.integration.support.management.graph.ErrorCapableMessageHandlerNode;
import org.springframework.integration.support.management.graph.ErrorCapableNode;
import org.springframework.integration.support.management.graph.ErrorCapableRoutingNode;
import org.springframework.integration.support.management.graph.Graph;
import org.springframework.integration.support.management.graph.IntegrationNode;
import org.springframework.integration.support.management.graph.LinkNode;
import org.springframework.integration.support.management.graph.MessageChannelNode;
import org.springframework.integration.support.management.graph.MessageGatewayNode;
import org.springframework.integration.support.management.graph.MessageHandlerNode;
import org.springframework.integration.support.management.graph.MessageProducerNode;
import org.springframework.integration.support.management.graph.MessageSourceNode;
import org.springframework.integration.support.management.graph.RoutingMessageHandlerNode;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class IntegrationGraphServer
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final float GRAPH_VERSION = 1.0f;
    private final NodeFactory nodeFactory = new NodeFactory();
    private ApplicationContext applicationContext;
    private Graph graph;
    private String applicationName;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph getGraph() {
        if (this.graph == null) {
            IntegrationGraphServer integrationGraphServer = this;
            synchronized (integrationGraphServer) {
                if (this.graph == null) {
                    this.buildGraph();
                }
            }
        }
        return this.graph;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.applicationContext)) {
            this.buildGraph();
        }
    }

    private synchronized Graph buildGraph() {
        String implementationVersion = IntegrationGraphServer.class.getPackage().getImplementationVersion();
        if (implementationVersion == null) {
            implementationVersion = "unknown - is Spring Integration running from the distribution jar?";
        }
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        descriptor.put("provider", "spring-integration");
        descriptor.put("providerVersion", implementationVersion);
        descriptor.put("providerFormatVersion", Float.valueOf(1.0f));
        String name = this.applicationName;
        if (name == null) {
            name = this.applicationContext.getEnvironment().getProperty("spring.application.name");
        }
        if (name != null) {
            descriptor.put("name", name);
        }
        this.nodeFactory.reset();
        ArrayList<IntegrationNode> nodes = new ArrayList<IntegrationNode>();
        ArrayList<LinkNode> links = new ArrayList<LinkNode>();
        Map<String, MessageChannelNode> channelNodes = this.channels(nodes);
        this.pollingAdapters(nodes, links, channelNodes);
        this.gateways(nodes, links, channelNodes);
        this.producers(nodes, links, channelNodes);
        this.consumers(nodes, links, channelNodes);
        this.graph = new Graph(descriptor, nodes, links);
        return this.graph;
    }

    private Map<String, MessageChannelNode> channels(Collection<IntegrationNode> nodes) {
        Map channels = this.applicationContext.getBeansOfType(MessageChannel.class);
        HashMap<String, MessageChannelNode> channelNodes = new HashMap<String, MessageChannelNode>();
        for (Map.Entry entry : channels.entrySet()) {
            MessageChannel channel = (MessageChannel)entry.getValue();
            MessageChannelNode channelNode = this.nodeFactory.channelNode((String)entry.getKey(), channel);
            String beanName = (String)entry.getKey();
            nodes.add(channelNode);
            channelNodes.put(beanName, channelNode);
        }
        return channelNodes;
    }

    private void pollingAdapters(Collection<IntegrationNode> nodes, Collection<LinkNode> links, Map<String, MessageChannelNode> channelNodes) {
        Map spcas = this.applicationContext.getBeansOfType(SourcePollingChannelAdapter.class);
        for (Map.Entry entry : spcas.entrySet()) {
            SourcePollingChannelAdapter adapter = (SourcePollingChannelAdapter)entry.getValue();
            MessageSourceNode sourceNode = this.nodeFactory.sourceNode((String)entry.getKey(), adapter);
            nodes.add(sourceNode);
            this.producerLink(links, channelNodes, sourceNode);
        }
    }

    private void gateways(Collection<IntegrationNode> nodes, Collection<LinkNode> links, Map<String, MessageChannelNode> channelNodes) {
        Map gateways = this.applicationContext.getBeansOfType(MessagingGatewaySupport.class);
        for (Map.Entry entry : gateways.entrySet()) {
            MessagingGatewaySupport gateway = (MessagingGatewaySupport)entry.getValue();
            MessageGatewayNode gatewayNode = this.nodeFactory.gatewayNode((String)entry.getKey(), gateway);
            nodes.add(gatewayNode);
            this.producerLink(links, channelNodes, gatewayNode);
        }
        Map gpfbs = this.applicationContext.getBeansOfType(GatewayProxyFactoryBean.class);
        for (Map.Entry entry : gpfbs.entrySet()) {
            Map<Method, MessagingGatewaySupport> methodMap = ((GatewayProxyFactoryBean)entry.getValue()).getGateways();
            for (Map.Entry<Method, MessagingGatewaySupport> gwEntry : methodMap.entrySet()) {
                MessagingGatewaySupport gateway = gwEntry.getValue();
                Method method = gwEntry.getKey();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] parameterTypeNames = new String[parameterTypes.length];
                int i = 0;
                for (Class<?> type : parameterTypes) {
                    parameterTypeNames[i++] = type.getName();
                }
                String signature = method.getName() + "(" + StringUtils.arrayToCommaDelimitedString((Object[])parameterTypeNames) + ")";
                MessageGatewayNode gatewayNode = this.nodeFactory.gatewayNode(((String)entry.getKey()).substring(1) + "." + signature, gateway);
                nodes.add(gatewayNode);
                this.producerLink(links, channelNodes, gatewayNode);
            }
        }
    }

    private void producers(Collection<IntegrationNode> nodes, Collection<LinkNode> links, Map<String, MessageChannelNode> channelNodes) {
        Map producers = this.applicationContext.getBeansOfType(MessageProducerSupport.class);
        for (Map.Entry entry : producers.entrySet()) {
            MessageProducerSupport producer = (MessageProducerSupport)entry.getValue();
            MessageProducerNode producerNode = this.nodeFactory.producerNode((String)entry.getKey(), producer);
            nodes.add(producerNode);
            this.producerLink(links, channelNodes, producerNode);
        }
    }

    private void consumers(Collection<IntegrationNode> nodes, Collection<LinkNode> links, Map<String, MessageChannelNode> channelNodes) {
        Map consumers = this.applicationContext.getBeansOfType(IntegrationConsumer.class);
        for (Map.Entry entry : consumers.entrySet()) {
            IntegrationConsumer consumer = (IntegrationConsumer)entry.getValue();
            MessageHandlerNode handlerNode = consumer instanceof PollingConsumer ? this.nodeFactory.polledHandlerNode((String)entry.getKey(), (PollingConsumer)consumer) : this.nodeFactory.handlerNode((String)entry.getKey(), consumer);
            nodes.add(handlerNode);
            MessageChannelNode channelNode = channelNodes.get(handlerNode.getInput());
            if (channelNode != null) {
                links.add(new LinkNode(channelNode.getNodeId(), handlerNode.getNodeId(), LinkNode.Type.input));
            }
            this.producerLink(links, channelNodes, handlerNode);
        }
    }

    private void producerLink(Collection<LinkNode> links, Map<String, MessageChannelNode> channelNodes, EndpointNode endpointNode) {
        MessageChannelNode channelNode;
        if (endpointNode.getOutput() != null && (channelNode = channelNodes.get(endpointNode.getOutput())) != null) {
            links.add(new LinkNode(endpointNode.getNodeId(), channelNode.getNodeId(), LinkNode.Type.output));
        }
        if (endpointNode instanceof ErrorCapableNode && (channelNode = channelNodes.get(((ErrorCapableNode)((Object)endpointNode)).getErrors())) != null) {
            links.add(new LinkNode(endpointNode.getNodeId(), channelNode.getNodeId(), LinkNode.Type.error));
        }
        if (endpointNode instanceof DiscardingMessageHandlerNode && (channelNode = channelNodes.get(((DiscardingMessageHandlerNode)endpointNode).getDiscards())) != null) {
            links.add(new LinkNode(endpointNode.getNodeId(), channelNode.getNodeId(), LinkNode.Type.discard));
        }
        if (endpointNode instanceof RoutingMessageHandlerNode) {
            Collection<String> routes = ((RoutingMessageHandlerNode)endpointNode).getRoutes();
            for (String route : routes) {
                channelNode = channelNodes.get(route);
                if (channelNode == null) continue;
                links.add(new LinkNode(endpointNode.getNodeId(), channelNode.getNodeId(), LinkNode.Type.route));
            }
        }
    }

    public Graph rebuild() {
        return this.buildGraph();
    }

    private static final class NodeFactory {
        private final AtomicInteger nodeId = new AtomicInteger();

        private NodeFactory() {
        }

        private MessageChannelNode channelNode(String name, MessageChannel channel) {
            return new MessageChannelNode(this.nodeId.incrementAndGet(), name, channel);
        }

        private MessageGatewayNode gatewayNode(String name, MessagingGatewaySupport gateway) {
            String errorChannel = gateway.getErrorChannel() != null ? gateway.getErrorChannel().toString() : null;
            return new MessageGatewayNode(this.nodeId.incrementAndGet(), name, gateway, gateway.getRequestChannel().toString(), errorChannel);
        }

        private MessageProducerNode producerNode(String name, MessageProducerSupport producer) {
            String errorChannel = producer.getErrorChannel() != null ? producer.getErrorChannel().toString() : null;
            return new MessageProducerNode(this.nodeId.incrementAndGet(), name, producer, producer.getOutputChannel().toString(), errorChannel);
        }

        private MessageSourceNode sourceNode(String name, SourcePollingChannelAdapter adapter) {
            String errorChannel = adapter.getDefaultErrorChannel() != null ? adapter.getDefaultErrorChannel().toString() : null;
            return new MessageSourceNode(this.nodeId.incrementAndGet(), name, adapter.getMessageSource(), adapter.getOutputChannel().toString(), errorChannel);
        }

        private MessageHandlerNode handlerNode(String name, IntegrationConsumer consumer) {
            MessageChannel outputChannel = consumer.getOutputChannel();
            String outputChannelName = outputChannel == null ? null : outputChannel.toString();
            MessageHandler handler = consumer.getHandler();
            if (handler instanceof CompositeMessageHandler) {
                return this.compositeHandler(name, consumer, (CompositeMessageHandler)handler, outputChannelName, null, false);
            }
            if (handler instanceof DiscardingMessageHandler) {
                return this.discardingHandler(name, consumer, (DiscardingMessageHandler)handler, outputChannelName, null, false);
            }
            if (handler instanceof MappingMessageRouterManagement) {
                return this.routingHandler(name, consumer, handler, (MappingMessageRouterManagement)handler, outputChannelName, null, false);
            }
            if (handler instanceof RecipientListRouterManagement) {
                return this.recipientListRoutingHandler(name, consumer, handler, (RecipientListRouterManagement)handler, outputChannelName, null, false);
            }
            return new MessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), outputChannelName);
        }

        private MessageHandlerNode polledHandlerNode(String name, PollingConsumer consumer) {
            MessageChannel outputChannel = consumer.getOutputChannel();
            String outputChannelName = outputChannel == null ? null : outputChannel.toString();
            String errorChannel = consumer.getDefaultErrorChannel() != null ? consumer.getDefaultErrorChannel().toString() : null;
            MessageHandler handler = consumer.getHandler();
            if (handler instanceof CompositeMessageHandler) {
                return this.compositeHandler(name, consumer, (CompositeMessageHandler)handler, outputChannelName, errorChannel, true);
            }
            if (handler instanceof DiscardingMessageHandler) {
                return this.discardingHandler(name, consumer, (DiscardingMessageHandler)handler, outputChannelName, errorChannel, true);
            }
            if (handler instanceof MappingMessageRouterManagement) {
                return this.routingHandler(name, consumer, handler, (MappingMessageRouterManagement)handler, outputChannelName, errorChannel, true);
            }
            if (handler instanceof RecipientListRouterManagement) {
                return this.recipientListRoutingHandler(name, consumer, handler, (RecipientListRouterManagement)handler, outputChannelName, errorChannel, true);
            }
            return new ErrorCapableMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), outputChannelName, errorChannel);
        }

        private MessageHandlerNode compositeHandler(String name, IntegrationConsumer consumer, CompositeMessageHandler handler, String output, String errors, boolean polled) {
            List<MessageHandler> handlers = handler.getHandlers();
            ArrayList<CompositeMessageHandlerNode.InnerHandler> innerHandlers = new ArrayList<CompositeMessageHandlerNode.InnerHandler>();
            for (MessageHandler innerHandler : handlers) {
                if (!(innerHandler instanceof NamedComponent)) continue;
                NamedComponent named = (NamedComponent)innerHandler;
                innerHandlers.add(new CompositeMessageHandlerNode.InnerHandler(named.getComponentName(), named.getComponentType()));
            }
            return polled ? new ErrorCapableCompositeMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, errors, innerHandlers) : new CompositeMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, innerHandlers);
        }

        private MessageHandlerNode discardingHandler(String name, IntegrationConsumer consumer, DiscardingMessageHandler handler, String output, String errors, boolean polled) {
            String discards = handler.getDiscardChannel() != null ? handler.getDiscardChannel().toString() : null;
            return polled ? new ErrorCapableDiscardingMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, discards, errors) : new DiscardingMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, discards);
        }

        private MessageHandlerNode routingHandler(String name, IntegrationConsumer consumer, MessageHandler handler, MappingMessageRouterManagement router, String output, String errors, boolean polled) {
            Collection<String> routes = router.getChannelMappings().values();
            Collection<String> dynamicChannelNames = router.getDynamicChannelNames();
            if (dynamicChannelNames.size() > 0) {
                routes = new ArrayList<String>(routes);
                routes.addAll(dynamicChannelNames);
            }
            return polled ? new ErrorCapableRoutingNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, errors, routes) : new RoutingMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, routes);
        }

        private MessageHandlerNode recipientListRoutingHandler(String name, IntegrationConsumer consumer, MessageHandler handler, RecipientListRouterManagement router, String output, String errors, boolean polled) {
            Collection<?> recipients = router.getRecipients();
            ArrayList<String> routes = new ArrayList<String>(recipients.size());
            for (Object recipient : recipients) {
                routes.add(((RecipientListRouter.Recipient)recipient).getChannel().toString());
            }
            return polled ? new ErrorCapableRoutingNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, errors, routes) : new RoutingMessageHandlerNode(this.nodeId.incrementAndGet(), name, handler, consumer.getInputChannel().toString(), output, routes);
        }

        private void reset() {
            this.nodeId.set(0);
        }
    }
}

