/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.util.BeanFactoryTypeConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public abstract class AbstractExpressionEvaluator
implements BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private volatile StandardEvaluationContext evaluationContext;
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.beanFactory = beanFactory;
            this.typeConverter.setBeanFactory(beanFactory);
            if (this.evaluationContext != null && this.evaluationContext.getBeanResolver() == null) {
                this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            }
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setConversionService(ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.getEvaluationContext();
        if (this.beanFactory != null) {
            this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
        }
    }

    protected StandardEvaluationContext getEvaluationContext() {
        return this.getEvaluationContext(true);
    }

    protected final StandardEvaluationContext getEvaluationContext(boolean beanFactoryRequired) {
        if (this.evaluationContext == null) {
            ConversionService conversionService;
            this.evaluationContext = this.beanFactory == null && !beanFactoryRequired ? ExpressionUtils.createStandardEvaluationContext() : ExpressionUtils.createStandardEvaluationContext(this.beanFactory);
            this.evaluationContext.setTypeConverter((TypeConverter)this.typeConverter);
            if (this.beanFactory != null && (conversionService = IntegrationUtils.getConversionService(this.beanFactory)) != null) {
                this.typeConverter.setConversionService(conversionService);
            }
        }
        return this.evaluationContext;
    }

    protected <T> T evaluateExpression(Expression expression, Message<?> message, Class<T> expectedType) {
        try {
            return this.evaluateExpression(expression, (Object)message, expectedType);
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"SpEL Expression evaluation failed with EvaluationException.", (Throwable)e);
            }
            throw new MessageHandlingException(message, "Expression evaluation failed: " + expression.getExpressionString(), cause == null ? e : cause);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SpEL Expression evaluation failed with Exception." + e));
            }
            throw new MessageHandlingException(message, "Expression evaluation failed: " + expression.getExpressionString(), (Throwable)e);
        }
    }

    protected Object evaluateExpression(String expression, Object input) {
        return this.evaluateExpression(expression, input, null);
    }

    protected <T> T evaluateExpression(String expression, Object input, Class<T> expectedType) {
        return (T)EXPRESSION_PARSER.parseExpression(expression).getValue((EvaluationContext)this.getEvaluationContext(), input, expectedType);
    }

    protected Object evaluateExpression(Expression expression, Object input) {
        return this.evaluateExpression(expression, input, null);
    }

    protected <T> T evaluateExpression(Expression expression, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.getEvaluationContext(), expectedType);
    }

    protected Object evaluateExpression(Expression expression) {
        return expression.getValue((EvaluationContext)this.getEvaluationContext());
    }

    protected <T> T evaluateExpression(Expression expression, Object input, Class<T> expectedType) {
        return (T)expression.getValue((EvaluationContext)this.getEvaluationContext(), input, expectedType);
    }
}

