/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.inbound;

import com.gemstone.gemfire.cache.query.CqEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.integration.endpoint.ExpressionMessageProducerSupport;
import org.springframework.integration.gemfire.inbound.CqEventType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ContinuousQueryMessageProducer
extends ExpressionMessageProducerSupport
implements ContinuousQueryListener {
    private static Log logger = LogFactory.getLog(ContinuousQueryMessageProducer.class);
    private final String query;
    private final ContinuousQueryListenerContainer queryListenerContainer;
    private volatile String queryName;
    private boolean durable;
    private volatile Set<CqEventType> supportedEventTypes = new HashSet<CqEventType>(Arrays.asList(CqEventType.CREATED, CqEventType.UPDATED));

    public ContinuousQueryMessageProducer(ContinuousQueryListenerContainer queryListenerContainer, String query) {
        Assert.notNull((Object)queryListenerContainer, (String)"'queryListenerContainer' cannot be null");
        Assert.notNull((Object)query, (String)"'query' cannot be null");
        this.queryListenerContainer = queryListenerContainer;
        this.query = query;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setSupportedEventTypes(CqEventType ... eventTypes) {
        Assert.notEmpty((Object[])eventTypes, (String)"eventTypes must not be empty");
        this.supportedEventTypes = new HashSet<CqEventType>(Arrays.asList(eventTypes));
    }

    public String getComponentType() {
        return "gemfire:cq-inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        if (this.queryName == null) {
            this.queryListenerContainer.addListener(new ContinuousQueryDefinition(this.query, (ContinuousQueryListener)this, this.durable));
        } else {
            this.queryListenerContainer.addListener(new ContinuousQueryDefinition(this.queryName, this.query, (ContinuousQueryListener)this, this.durable));
        }
    }

    public void onEvent(CqEvent event) {
        if (this.isEventSupported(event)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("processing cq event key [%s] event [%s]", event.getQueryOperation().toString(), event.getKey()));
            }
            Message message = null;
            Object object = this.evaluatePayloadExpression(event);
            message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            this.sendMessage(message);
        }
    }

    private boolean isEventSupported(CqEvent event) {
        String eventName = event.getQueryOperation().toString() + (event.getQueryOperation().toString().endsWith("Y") ? "ED" : "D");
        CqEventType eventType = CqEventType.valueOf(eventName);
        return this.supportedEventTypes.contains((Object)eventType);
    }
}

