/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.metadata;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;

public class GemfireMetadataStore
implements ConcurrentMetadataStore {
    public static final String KEY = "MetaData";
    private final Region<String, String> region;

    public GemfireMetadataStore(Cache cache) {
        Assert.notNull((Object)cache, (String)"'cache' must not be null");
        this.region = cache.createRegionFactory().setScope(Scope.LOCAL).create(KEY);
    }

    public GemfireMetadataStore(Region<String, String> region) {
        Assert.notNull(region, (String)"'region' must not be null");
        this.region = region;
    }

    public void put(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        this.region.put((Object)key, (Object)value);
    }

    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        return (String)this.region.putIfAbsent((Object)key, (Object)value);
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
        Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
        return this.region.replace((Object)key, (Object)oldValue, (Object)newValue);
    }

    public String get(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        return (String)this.region.get((Object)key);
    }

    public String remove(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        return (String)this.region.remove((Object)key);
    }
}

