/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import org.springframework.messaging.Message;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.statemachine.security.EventSecurityExpressionRoot;
import org.springframework.util.Assert;

public class DefaultEventSecurityExpressionHandler<T>
extends AbstractSecurityExpressionHandler<Message<T>> {
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    protected SecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, Message<T> invocation) {
        EventSecurityExpressionRoot root = new EventSecurityExpressionRoot(authentication, invocation);
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.trustResolver);
        root.setRoleHierarchy(this.getRoleHierarchy());
        return root;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, (String)"trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }
}

