/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineFunction;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.service.StateMachineService;
import org.springframework.util.Assert;

public class DefaultStateMachineService<S, E>
implements StateMachineService<S, E>,
DisposableBean {
    private static final Log log = LogFactory.getLog(DefaultStateMachineService.class);
    private final StateMachineFactory<S, E> stateMachineFactory;
    private final Map<String, StateMachine<S, E>> machines = new HashMap<String, StateMachine<S, E>>();
    private StateMachinePersist<S, E, String> stateMachinePersist;

    public DefaultStateMachineService(StateMachineFactory<S, E> stateMachineFactory) {
        this(stateMachineFactory, null);
    }

    public DefaultStateMachineService(StateMachineFactory<S, E> stateMachineFactory, StateMachinePersist<S, E, String> stateMachinePersist) {
        Assert.notNull(stateMachineFactory, (String)"'stateMachineFactory' must be set");
        this.stateMachineFactory = stateMachineFactory;
        this.stateMachinePersist = stateMachinePersist;
    }

    public final void destroy() throws Exception {
        this.doStop();
    }

    @Override
    public StateMachine<S, E> acquireStateMachine(String machineId) {
        return this.acquireStateMachine(machineId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachine<S, E> acquireStateMachine(String machineId, boolean start) {
        log.info((Object)("Acquiring machine with id " + machineId));
        Map<String, StateMachine<S, E>> map = this.machines;
        synchronized (map) {
            StateMachine<S, E> stateMachine = this.machines.get(machineId);
            if (stateMachine == null) {
                log.info((Object)("Getting new machine from factory with id " + machineId));
                stateMachine = this.stateMachineFactory.getStateMachine(machineId);
                if (this.stateMachinePersist != null) {
                    try {
                        StateMachineContext<S, E> stateMachineContext = this.stateMachinePersist.read(machineId);
                        stateMachine = this.restoreStateMachine(stateMachine, stateMachineContext);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error handling context", (Throwable)e);
                        throw new StateMachineException("Unable to read context from store", e);
                    }
                }
                this.machines.put(machineId, stateMachine);
            }
            return this.handleStart(stateMachine, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseStateMachine(String machineId) {
        log.info((Object)("Releasing machine with id " + machineId));
        Map<String, StateMachine<S, E>> map = this.machines;
        synchronized (map) {
            StateMachine<S, E> stateMachine = this.machines.remove(machineId);
            if (stateMachine != null) {
                log.info((Object)("Found machine with id " + machineId));
                stateMachine.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseStateMachine(String machineId, boolean stop) {
        log.info((Object)("Releasing machine with id " + machineId));
        Map<String, StateMachine<S, E>> map = this.machines;
        synchronized (map) {
            StateMachine<S, E> stateMachine = this.machines.remove(machineId);
            if (stateMachine != null) {
                log.info((Object)("Found machine with id " + machineId));
                this.handleStop(stateMachine, stop);
            }
        }
    }

    public void setStateMachinePersist(StateMachinePersist<S, E, String> stateMachinePersist) {
        this.stateMachinePersist = stateMachinePersist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        log.info((Object)"Entering stop sequence, stopping all managed machines");
        Map<String, StateMachine<S, E>> map = this.machines;
        synchronized (map) {
            ArrayList<String> machineIds = new ArrayList<String>(this.machines.keySet());
            for (String machineId : machineIds) {
                this.releaseStateMachine(machineId, true);
            }
        }
    }

    protected StateMachine<S, E> restoreStateMachine(StateMachine<S, E> stateMachine, final StateMachineContext<S, E> stateMachineContext) {
        if (stateMachineContext == null) {
            return stateMachine;
        }
        stateMachine.stop();
        stateMachine.getStateMachineAccessor().doWithAllRegions(new StateMachineFunction<StateMachineAccess<S, E>>(){

            @Override
            public void apply(StateMachineAccess<S, E> function) {
                function.resetStateMachine(stateMachineContext);
            }
        });
        return stateMachine;
    }

    protected StateMachine<S, E> handleStart(StateMachine<S, E> stateMachine, boolean start) {
        if (start && !((Lifecycle)stateMachine).isRunning()) {
            StartListener<S, E> listener = new StartListener<S, E>(stateMachine);
            stateMachine.addStateListener(listener);
            stateMachine.start();
            try {
                listener.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return stateMachine;
    }

    protected StateMachine<S, E> handleStop(StateMachine<S, E> stateMachine, boolean stop) {
        if (stop && ((Lifecycle)stateMachine).isRunning()) {
            StopListener<S, E> listener = new StopListener<S, E>(stateMachine);
            stateMachine.addStateListener(listener);
            stateMachine.stop();
            try {
                listener.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return stateMachine;
    }

    private static class StopListener<S, E>
    extends StateMachineListenerAdapter<S, E> {
        final CountDownLatch latch = new CountDownLatch(1);
        final StateMachine<S, E> stateMachine;

        public StopListener(StateMachine<S, E> stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public void stateMachineStopped(StateMachine<S, E> stateMachine) {
            this.stateMachine.removeStateListener(this);
            this.latch.countDown();
        }
    }

    private static class StartListener<S, E>
    extends StateMachineListenerAdapter<S, E> {
        final CountDownLatch latch = new CountDownLatch(1);
        final StateMachine<S, E> stateMachine;

        public StartListener(StateMachine<S, E> stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public void stateMachineStarted(StateMachine<S, E> stateMachine) {
            this.stateMachine.removeStateListener(this);
            this.latch.countDown();
        }
    }
}

