/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.access.StateMachineFunction;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.state.AbstractState;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.transition.Transition;
import org.springframework.statemachine.transition.TransitionKind;

public class StateMachineState<S, E>
extends AbstractState<S, E> {
    private final Collection<S> ids = new ArrayList<S>();

    public StateMachineState(S id, StateMachine<S, E> submachine) {
        super(id, null, null, null, null, submachine);
        this.ids.add(id);
    }

    public StateMachineState(S id, StateMachine<S, E> submachine, Collection<E> deferred) {
        super(id, deferred, null, null, null, submachine);
        this.ids.add(id);
    }

    public StateMachineState(S id, StateMachine<S, E> submachine, PseudoState<S, E> pseudoState) {
        super(id, null, null, null, pseudoState, submachine);
        this.ids.add(id);
    }

    public StateMachineState(S id, StateMachine<S, E> submachine, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState) {
        super(id, deferred, entryActions, exitActions, pseudoState, submachine);
        this.ids.add(id);
    }

    public StateMachineState(S id, StateMachine<S, E> submachine, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        super(id, deferred, entryActions, exitActions, null, submachine);
        this.ids.add(id);
    }

    @Override
    public Collection<S> getIds() {
        ArrayList<S> ret = new ArrayList<S>(this.ids);
        State state = this.getSubmachine().getState();
        if (state != null) {
            ret.addAll(state.getIds());
        }
        return ret;
    }

    @Override
    public Collection<State<S, E>> getStates() {
        ArrayList states = new ArrayList();
        states.add(this);
        for (State s : this.getSubmachine().getStates()) {
            states.addAll(s.getStates());
        }
        return states;
    }

    @Override
    public void exit(StateContext<S, E> context) {
        super.exit(context);
        if (this.getSubmachine().getState() != null && context.getTransition() != null && context.getTransition().getSource().getId() != this.getSubmachine().getState().getId()) {
            this.getSubmachine().stop();
        } else if (context.getTransition() != null && !StateMachineUtils.isSubstate(context.getTransition().getTarget(), context.getTransition().getSource())) {
            this.getSubmachine().stop();
        }
        if (!this.isLocal(context)) {
            for (Action action : this.getExitActions()) {
                this.executeAction(action, context);
            }
        }
    }

    @Override
    public void entry(final StateContext<S, E> context) {
        super.entry(context);
        if (!this.isLocal(context)) {
            for (Action action : this.getEntryActions()) {
                this.executeAction(action, context);
            }
        }
        if (context.getTransition() != null) {
            State<S, E> target = context.getTransition().getTarget();
            State immediateDeepParent = this.findDeepParent(this.getSubmachine().getStates(), target);
            if (context.getEvent() != null) {
                this.getSubmachine().getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                    @Override
                    public void apply(StateMachineAccess<S, E> function) {
                        function.setForwardedInitialEvent(MessageBuilder.withPayload(context.getEvent()).copyHeaders((Map)context.getMessageHeaders()).build());
                    }
                });
            }
            if (immediateDeepParent != null && immediateDeepParent.isSubmachineState() && !this.isInitial(target)) {
                ((StateMachineState)immediateDeepParent).getSubmachine().getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                    @Override
                    public void apply(StateMachineAccess<S, E> function) {
                        function.setInitialEnabled(false);
                    }
                });
            }
            if (immediateDeepParent != null && !this.isInitial(immediateDeepParent)) {
                this.getSubmachine().getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                    @Override
                    public void apply(StateMachineAccess<S, E> function) {
                        function.setInitialEnabled(false);
                    }
                });
            } else if (immediateDeepParent != null && this.isInitial(immediateDeepParent) && this.isInitial(target)) {
                ((StateMachineState)immediateDeepParent).getSubmachine().getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                    @Override
                    public void apply(StateMachineAccess<S, E> function) {
                        function.setInitialEnabled(false);
                    }
                });
            }
            if (immediateDeepParent == null && this.getSubmachine().getStates().contains(target) && !this.isInitial(target) && StateMachineUtils.isSubstate(context.getTransition().getSource(), context.getTransition().getTarget())) {
                this.getSubmachine().getStateMachineAccessor().doWithRegion(new StateMachineFunction<StateMachineAccess<S, E>>(){

                    @Override
                    public void apply(StateMachineAccess<S, E> function) {
                        function.setInitialEnabled(false);
                    }
                });
            }
        }
        this.getSubmachine().start();
    }

    private boolean isInitial(State<S, E> state) {
        return state.getPseudoState() != null && state.getPseudoState().getKind() == PseudoStateKind.INITIAL;
    }

    private State<S, E> findDeepParent(Collection<State<S, E>> states, State<S, E> state) {
        for (State<S, E> s : states) {
            if (!s.getStates().contains(state) || s == state) continue;
            return s;
        }
        return null;
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        StateMachine machine = this.getSubmachine();
        if (machine != null) {
            return machine.sendEvent(event);
        }
        return super.sendEvent(event);
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        State state;
        StateMachine machine = this.getSubmachine();
        if (machine != null && (state = machine.getState()) != null && state.getDeferredEvents().contains(event.getPayload())) {
            return true;
        }
        return super.shouldDefer(event);
    }

    private boolean isLocal(StateContext<S, E> context) {
        Transition<S, E> transition = context.getTransition();
        return transition != null && TransitionKind.LOCAL == transition.getKind() && this == transition.getTarget();
    }

    @Override
    public String toString() {
        return "StateMachineState [getIds()=" + this.getIds() + ", toString()=" + super.toString() + ", getClass()=" + this.getClass() + "]";
    }
}

