/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.support.ObservableMap;

public class DefaultExtendedState
implements ExtendedState {
    private final Map<Object, Object> variables;
    private ExtendedState.ExtendedStateChangeListener listener;

    public DefaultExtendedState() {
        this.variables = new ObservableMap<Object, Object>(new ConcurrentHashMap(), new LocalMapChangeListener());
    }

    public DefaultExtendedState(Map<Object, Object> variables) {
        this.variables = variables;
    }

    @Override
    public Map<Object, Object> getVariables() {
        return this.variables;
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.variables.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for variable '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    @Override
    public void setExtendedStateChangeListener(ExtendedState.ExtendedStateChangeListener listener) {
        this.listener = listener;
    }

    public String toString() {
        return "DefaultExtendedState [variables=" + this.variables + "]";
    }

    private class LocalMapChangeListener
    implements ObservableMap.MapChangeListener<Object, Object> {
        private LocalMapChangeListener() {
        }

        @Override
        public void added(Object key, Object value) {
            if (DefaultExtendedState.this.listener != null) {
                DefaultExtendedState.this.listener.changed(key, value);
            }
        }

        @Override
        public void changed(Object key, Object value) {
            if (DefaultExtendedState.this.listener != null) {
                DefaultExtendedState.this.listener.changed(key, value);
            }
        }

        @Override
        public void removed(Object key, Object value) {
            if (DefaultExtendedState.this.listener != null) {
                DefaultExtendedState.this.listener.changed(key, value);
            }
        }
    }
}

