/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.statemachine.support.StateMachineContextUtils;
import org.springframework.util.Assert;

public abstract class LifecycleObjectSupport
implements InitializingBean,
DisposableBean,
SmartLifecycle,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(LifecycleObjectSupport.class);
    private volatile boolean autoStartup = false;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private TaskScheduler taskScheduler;
    private TaskExecutor taskExecutor;
    private volatile BeanFactory beanFactory;
    private final AtomicBoolean afterPropertiesSetCalled = new AtomicBoolean(false);

    public final void afterPropertiesSet() {
        try {
            if (this.afterPropertiesSetCalled.compareAndSet(false, true)) {
                this.onInit();
            } else {
                log.debug((Object)"afterPropertiesSet() is already called, not calling onInit()");
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BeanInitializationException("failed to initialize", (Throwable)e);
        }
    }

    public final void destroy() throws Exception {
        log.info((Object)"destroy called");
        this.doDestroy();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting bean factory: " + beanFactory + " for " + this));
        }
        this.beanFactory = beanFactory;
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.running = true;
                this.doStart();
                if (log.isInfoEnabled()) {
                    log.info((Object)("started " + this));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("already started " + this));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop() {
        if (!this.lifecycleLock.tryLock()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("already stopping " + this));
            }
            return;
        }
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)("stopped " + this));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("already stopped " + this));
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"taskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    protected TaskScheduler getTaskScheduler() {
        if (this.taskScheduler == null && this.getBeanFactory() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting taskScheduler service from bean factory " + this.getBeanFactory()));
            }
            this.taskScheduler = StateMachineContextUtils.getTaskScheduler(this.getBeanFactory());
        }
        return this.taskScheduler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"taskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        if (this.taskExecutor == null && this.getBeanFactory() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting taskExecutor service from bean factory " + this.getBeanFactory()));
            }
            this.taskExecutor = StateMachineContextUtils.getTaskExecutor(this.getBeanFactory());
        }
        return this.taskExecutor;
    }

    protected void onInit() throws Exception {
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doDestroy() {
    }
}

