/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support.tree;

import java.util.ArrayDeque;
import java.util.Iterator;
import org.springframework.statemachine.support.tree.AbstractIterator;
import org.springframework.util.Assert;

public abstract class TreeTraverser<T> {
    public abstract Iterable<T> children(T var1);

    public final Iterable<T> postOrderTraversal(final T root) {
        Assert.notNull(root);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return TreeTraverser.this.postOrderIterator(root);
            }
        };
    }

    Iterator<T> postOrderIterator(T root) {
        return new PostOrderIterator(root);
    }

    private final class PostOrderIterator
    extends AbstractIterator<T> {
        private final ArrayDeque<PostOrderNode<T>> stack = new ArrayDeque();

        PostOrderIterator(T root) {
            this.stack.addLast(this.expand(root));
        }

        @Override
        protected T computeNext() {
            while (!this.stack.isEmpty()) {
                PostOrderNode top = this.stack.getLast();
                if (top.childIterator.hasNext()) {
                    Object child = top.childIterator.next();
                    this.stack.addLast(this.expand(child));
                    continue;
                }
                this.stack.removeLast();
                return top.root;
            }
            return this.endOfData();
        }

        private PostOrderNode<T> expand(T t) {
            return new PostOrderNode(t, TreeTraverser.this.children(t).iterator());
        }
    }

    private static final class PostOrderNode<T> {
        final T root;
        final Iterator<T> childIterator;

        PostOrderNode(T root, Iterator<T> childIterator) {
            Assert.notNull(root);
            Assert.notNull(childIterator);
            this.root = root;
            this.childIterator = childIterator;
        }
    }
}

