/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.ObjWithLock;
import org.tio.utils.lock.SetWithLock;

public class Tokens {
    private static Logger log = LoggerFactory.getLogger(Tokens.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> mapWithLock = new MapWithLock(new HashMap());

    public void bind(String token, ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            return;
        }
        String key = token;
        ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.getLock().writeLock();
        lock.lock();
        try {
            Map map = (Map)this.mapWithLock.getObj();
            SetWithLock setWithLock = (SetWithLock)map.get(key);
            if (setWithLock == null) {
                setWithLock = new SetWithLock(new HashSet());
                map.put(key, setWithLock);
            }
            setWithLock.add((Object)channelContext);
            channelContext.setToken(token);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public SetWithLock<ChannelContext> find(GroupContext groupContext, String token) {
        if (groupContext.isShortConnection()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String key = token;
        ReentrantReadWriteLock.ReadLock lock = this.mapWithLock.getLock().readLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            SetWithLock setWithLock = (SetWithLock)m.get(key);
            return setWithLock;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ObjWithLock<Map<String, SetWithLock<ChannelContext>>> getMap() {
        return this.mapWithLock;
    }

    public void unbind(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        String token = channelContext.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            log.info("{}, {}, \u5e76\u6ca1\u6709\u7ed1\u5b9a\u7528\u6237", (Object)groupContext.getName(), (Object)channelContext.toString());
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.getLock().writeLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            SetWithLock setWithLock = (SetWithLock)m.get(token);
            if (setWithLock == null) {
                log.info("{}, {}, token:{}, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684SetWithLock", new Object[]{groupContext.getName(), channelContext.toString(), token});
                return;
            }
            channelContext.setToken(null);
            setWithLock.remove((Object)channelContext);
            if (((Set)setWithLock.getObj()).size() == 0) {
                m.remove(token);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(GroupContext groupContext, String token) {
        if (groupContext.isShortConnection()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.getLock().writeLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            SetWithLock setWithLock = (SetWithLock)m.get(token);
            if (setWithLock == null) {
                return;
            }
            ReentrantReadWriteLock.WriteLock writeLock = setWithLock.getLock().writeLock();
            writeLock.lock();
            try {
                Set set = (Set)setWithLock.getObj();
                if (set.size() > 0) {
                    for (ChannelContext channelContext : set) {
                        channelContext.setToken(null);
                    }
                    set.clear();
                }
                m.remove(token);
                writeLock.unlock();
            }
            catch (Throwable e) {
                try {
                    log.error(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

