/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.ISSLListener;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.SendRunnable;

public class SslListener
implements ISSLListener {
    private static Logger log = LoggerFactory.getLogger(SslListener.class);
    private ChannelContext channelContext = null;

    public SslListener(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void onWrappedData(SslVo sslVo) {
        log.info("{}, \u6536\u5230SSL\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff0c\u51c6\u5907\u53d1\u9001\u51fa\u53bb\uff0c{}", (Object)this.channelContext, (Object)sslVo);
        Object obj = sslVo.getObj();
        if (obj == null) {
            Packet p = new Packet();
            p.setPreEncodedByteBuffer(sslVo.getByteBuffer());
            p.setSslEncrypted(true);
            SendRunnable sendRunnable = this.channelContext.getSendRunnable();
            boolean isAdded = this.channelContext.getSendRunnable().addMsg(p);
            if (isAdded) {
                this.channelContext.getGroupContext().getTioExecutor().execute((Runnable)((Object)sendRunnable));
            }
        }
    }

    @Override
    public void onPlainData(ByteBuffer plainBuffer) {
        SslFacadeContext sslFacadeContext = this.channelContext.getSslFacadeContext();
        if (sslFacadeContext.isHandshakeCompleted()) {
            log.info("{}, \u6536\u5230SSL\u89e3\u5bc6\u540e\u7684\u6570\u636e\uff0cSSL\u63e1\u624b\u5df2\u7ecf\u5b8c\u6210\uff0c\u51c6\u5907\u89e3\u7801\uff0c{}, isSSLHandshakeCompleted {}", new Object[]{this.channelContext, plainBuffer, sslFacadeContext.isHandshakeCompleted()});
            DecodeRunnable decodeRunnable = this.channelContext.getDecodeRunnable();
            decodeRunnable.setNewByteBuffer(plainBuffer);
            decodeRunnable.run();
        } else {
            log.info("{}, \u6536\u5230SSL\u89e3\u5bc6\u540e\u7684\u6570\u636e\uff0c\u4f46SSL\u63e1\u624b\u8fd8\u6ca1\u5b8c\u6210\uff0c{}, isSSLHandshakeCompleted {}", new Object[]{this.channelContext, plainBuffer, sslFacadeContext.isHandshakeCompleted()});
        }
    }

    public static void main(String[] args) {
    }
}

